/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionActionSuppressor;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorActionStatus;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.PermissionsKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.ExecutionManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunState;
import com.intellij.execution.ui.RunStatusHistory;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.platform.ide.core.permissions.RequiresPermissions;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SpinningProgressIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExecutorAction
extends AnAction
implements DumbAware,
RequiresPermissions,
ActionIdProvider {
    public static final Key<Boolean> WOULD_BE_ENABLED_BUT_STARTING = Key.create((String)"WOULD_BE_ENABLED_BUT_STARTING");
    private static final Logger LOG = Logger.getInstance(ExecutorAction.class);
    private static final Key<SpinningProgressIcon> spinningIconKey = Key.create((String)"spinning-icon-key");
    private static final Key<RunCurrentFileInfo> CURRENT_FILE_RUN_CONFIGS_KEY = Key.create((String)"CURRENT_FILE_RUN_CONFIGS");
    protected final Executor myExecutor;

    protected ExecutorAction(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorAction.$$$reportNull$$$0(0);
        }
        super(() -> ((Executor)executor).getStartActionText(), () -> ((Executor)executor).getDescription(), () -> ((Executor)executor).getIcon());
        this.myExecutor = executor;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExecutorAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        String text;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        presentation.putClientProperty(ExecutorActionStatus.KEY, null);
        Project project = e.getProject();
        if (project == null || !project.isInitialized() || project.isDisposed()) {
            presentation.setEnabled(false);
            return;
        }
        RunManager runManager = RunManager.getInstanceIfCreated((Project)project);
        if (runManager == null) {
            presentation.setEnabled(false);
            return;
        }
        RunnerAndConfigurationSettings selectedSettings = this.getSelectedConfiguration(e);
        boolean enabled = false;
        ExecutorActionStatus actionStatus = null;
        boolean runConfigAsksToHideDisabledExecutorButtons = false;
        if (selectedSettings != null) {
            if (DumbService.isDumb((Project)project) && !selectedSettings.getType().isDumbAware()) {
                presentation.setEnabled(false);
                return;
            }
            actionStatus = this.setupActionStatus(e, project, selectedSettings, presentation);
            presentation.setIcon(this.getInformativeIcon(project, selectedSettings, e));
            RunConfiguration configuration = selectedSettings.getConfiguration();
            Ref isStartingTracker = Ref.create((Object)false);
            if (!ExecutorAction.isSuppressed(project) && (enabled = ExecutorRegistryImpl.RunnerHelper.canRun(project, this.myExecutor, configuration, (Ref<Boolean>)isStartingTracker)) && isStartingTracker.get() == Boolean.TRUE) {
                enabled = false;
                presentation.putClientProperty(WOULD_BE_ENABLED_BUT_STARTING, (Object)true);
            }
            if (!(configuration instanceof CompoundRunConfiguration)) {
                runConfigAsksToHideDisabledExecutorButtons = configuration.hideDisabledExecutorButtons();
            }
            if (enabled) {
                presentation.setDescription(this.myExecutor.getDescription());
            }
            if (ExperimentalUI.isNewUI() && ExecutorAction.needRerunPresentation(selectedSettings.getConfiguration(), this.getRunningDescriptors(project, selectedSettings))) {
                text = this.myExecutor.getId().equals("Run") ? ExecutionBundle.message((String)"run.toolbar.widget.rerun.text", (Object[])new Object[]{configuration}) : ExecutionBundle.message((String)"run.toolbar.widget.restart.text", (Object[])new Object[]{this.myExecutor.getActionName(), configuration.getName()});
            } else {
                ProgramRunner runner = ProgramRunner.getRunner((String)this.getId(), (RunProfile)configuration);
                String actionText = runner == null ? null : runner.getStartActionText(this.myExecutor, configuration);
                text = actionText != null ? actionText : this.myExecutor.getStartActionText(configuration.getName());
            }
        } else if (RunConfigurationsComboBoxAction.hasRunCurrentFileItem(project)) {
            RunnerAndConfigurationSettings config;
            if (!project.isDefault() && !StartupManager.getInstance((Project)project).postStartupActivityPassed()) {
                presentation.setEnabled(false);
                return;
            }
            RunCurrentFileActionStatus status = this.getRunCurrentFileActionStatus(e, false);
            Iterator<RunnerAndConfigurationSettings> iterator = status.myRunConfigs.iterator();
            while (iterator.hasNext() && (actionStatus = this.setupActionStatus(e, project, config = iterator.next(), presentation)) == ExecutorActionStatus.NORMAL) {
            }
            enabled = status.enabled;
            text = status.tooltip;
            presentation.setIcon(status.icon);
        } else {
            text = this.getTemplatePresentation().getTextWithMnemonic();
        }
        if (actionStatus != ExecutorActionStatus.LOADING && runConfigAsksToHideDisabledExecutorButtons) {
            presentation.setEnabledAndVisible(enabled);
        } else {
            presentation.setEnabled(enabled);
        }
        if (presentation.isVisible()) {
            presentation.setVisible(this.myExecutor.isApplicable(project));
        }
        presentation.putClientProperty(ExecutorActionStatus.KEY, (Object)actionStatus);
        presentation.setText(text);
    }

    private ExecutorActionStatus setupActionStatus(@NotNull AnActionEvent e, Project project, RunnerAndConfigurationSettings selectedSettings, Presentation presentation) {
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(3);
        }
        ExecutorActionStatus status = ExecutorActionStatus.NORMAL;
        if ("NewUiRunToolbar".equals(e.getPlace())) {
            boolean isLoading;
            RunStatusHistory startHistory = RunStatusHistory.getInstance(project);
            boolean bl = isLoading = startHistory.firstOrNull(selectedSettings, it -> it.getExecutorId().equals(this.myExecutor.getId()) && it.getState() == RunState.SCHEDULED) != null;
            if (isLoading) {
                status = ExecutorActionStatus.LOADING;
                SpinningProgressIcon spinningIcon = (SpinningProgressIcon)presentation.getClientProperty(spinningIconKey);
                if (spinningIcon == null) {
                    spinningIcon = new SpinningProgressIcon();
                    spinningIcon.setIconColor(JBUI.CurrentTheme.RunWidget.ICON_COLOR);
                    presentation.putClientProperty(spinningIconKey, (Object)spinningIcon);
                }
                presentation.setDisabledIcon((Icon)spinningIcon);
            } else {
                if (!this.getRunningDescriptors(project, selectedSettings).isEmpty()) {
                    status = ExecutorActionStatus.RUNNING;
                }
                presentation.putClientProperty(spinningIconKey, null);
                presentation.setDisabledIcon(null);
            }
        }
        return status;
    }

    @NotNull
    private RunCurrentFileActionStatus getRunCurrentFileActionStatus(@NotNull AnActionEvent e, boolean resetCache) {
        VirtualFile vFile;
        Project project;
        Object[] files;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(4);
        }
        if ((files = FileEditorManager.getInstance((Project)(project = Objects.requireNonNull(e.getProject()))).getSelectedFiles()).length == 1) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(files[0]);
            if (psiFile == null) {
                String tooltip = ExecutionBundle.message((String)"run.button.on.toolbar.tooltip.current.file.not.runnable", (Object[])new Object[0]);
                RunCurrentFileActionStatus runCurrentFileActionStatus = RunCurrentFileActionStatus.createDisabled(tooltip, this.myExecutor.getIcon());
                if (runCurrentFileActionStatus == null) {
                    ExecutorAction.$$$reportNull$$$0(5);
                }
                return runCurrentFileActionStatus;
            }
            return this.getRunCurrentFileActionStatus(psiFile, resetCache, e);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            String tooltip = ExecutionBundle.message((String)"run.button.on.toolbar.tooltip.current.file.no.focused.editor", (Object[])new Object[0]);
            RunCurrentFileActionStatus runCurrentFileActionStatus = RunCurrentFileActionStatus.createDisabled(tooltip, this.myExecutor.getIcon());
            if (runCurrentFileActionStatus == null) {
                ExecutorAction.$$$reportNull$$$0(6);
            }
            return runCurrentFileActionStatus;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (psiFile == null || vFile == null || !ArrayUtil.contains((Object)vFile, (Object[])files)) {
            String tooltip = ExecutionBundle.message((String)"run.button.on.toolbar.tooltip.current.file.no.focused.editor", (Object[])new Object[0]);
            RunCurrentFileActionStatus runCurrentFileActionStatus = RunCurrentFileActionStatus.createDisabled(tooltip, this.myExecutor.getIcon());
            if (runCurrentFileActionStatus == null) {
                ExecutorAction.$$$reportNull$$$0(7);
            }
            return runCurrentFileActionStatus;
        }
        return this.getRunCurrentFileActionStatus(psiFile, resetCache, e);
    }

    @NotNull
    private RunCurrentFileActionStatus getRunCurrentFileActionStatus(@NotNull PsiFile psiFile, boolean resetCache, @NotNull AnActionEvent e) {
        List<RunnerAndConfigurationSettings> runConfigs;
        if (psiFile == null) {
            ExecutorAction.$$$reportNull$$$0(8);
        }
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(9);
        }
        if ((runConfigs = ExecutorAction.getRunConfigsForCurrentFile(psiFile, resetCache)).isEmpty()) {
            String tooltip = ExecutionBundle.message((String)"run.button.on.toolbar.tooltip.current.file.not.runnable", (Object[])new Object[0]);
            RunCurrentFileActionStatus runCurrentFileActionStatus = RunCurrentFileActionStatus.createDisabled(tooltip, this.myExecutor.getIcon());
            if (runCurrentFileActionStatus == null) {
                ExecutorAction.$$$reportNull$$$0(10);
            }
            return runCurrentFileActionStatus;
        }
        List<RunnerAndConfigurationSettings> runnableConfigs = this.filterConfigsThatHaveRunner(runConfigs);
        if (runnableConfigs.isEmpty()) {
            RunCurrentFileActionStatus runCurrentFileActionStatus = RunCurrentFileActionStatus.createDisabled(this.myExecutor.getStartActionText(psiFile.getName()), this.myExecutor.getIcon());
            if (runCurrentFileActionStatus == null) {
                ExecutorAction.$$$reportNull$$$0(11);
            }
            return runCurrentFileActionStatus;
        }
        Icon icon = this.myExecutor.getIcon();
        if (runnableConfigs.size() == 1) {
            icon = this.getInformativeIcon(psiFile.getProject(), runnableConfigs.get(0), e);
        } else {
            for (RunnerAndConfigurationSettings config : runnableConfigs) {
                Icon anotherIcon = this.getInformativeIcon(psiFile.getProject(), config, e);
                if (icon != this.myExecutor.getIcon() && (anotherIcon == this.myExecutor.getIcon() || anotherIcon == AllIcons.Actions.Restart)) continue;
                icon = anotherIcon;
            }
        }
        RunCurrentFileActionStatus runCurrentFileActionStatus = RunCurrentFileActionStatus.createEnabled(this.myExecutor.getStartActionText(psiFile.getName()), icon, runnableConfigs);
        if (runCurrentFileActionStatus == null) {
            ExecutorAction.$$$reportNull$$$0(12);
        }
        return runCurrentFileActionStatus;
    }

    public String getId() {
        return this.myExecutor.getId();
    }

    @ApiStatus.Internal
    public static List<RunnerAndConfigurationSettings> getRunConfigsForCurrentFile(@NotNull PsiFile psiFile, boolean resetCache) {
        if (psiFile == null) {
            ExecutorAction.$$$reportNull$$$0(13);
        }
        if (resetCache) {
            psiFile.putUserData(CURRENT_FILE_RUN_CONFIGS_KEY, null);
        }
        long psiModCount = PsiModificationTracker.getInstance((Project)psiFile.getProject()).getModificationCount();
        RunCurrentFileInfo cache = (RunCurrentFileInfo)psiFile.getUserData(CURRENT_FILE_RUN_CONFIGS_KEY);
        if (cache == null || cache.myPsiModCount != psiModCount) {
            ConfigurationContext configurationContext = new ConfigurationContext((PsiElement)psiFile);
            List configurationsFromContext = configurationContext.createConfigurationsFromContext();
            List runConfigs = configurationsFromContext == null ? List.of() : ContainerUtil.map((Collection)configurationsFromContext, ConfigurationFromContext::getConfigurationSettings);
            VirtualFile vFile = psiFile.getVirtualFile();
            if (!runConfigs.isEmpty()) {
                String filePath = vFile == null ? null : vFile.getPath();
                for (RunnerAndConfigurationSettings config : runConfigs) {
                    ((RunnerAndConfigurationSettingsImpl)config).setFilePathIfRunningCurrentFile(filePath);
                }
            }
            cache = new RunCurrentFileInfo(psiModCount, runConfigs);
            psiFile.putUserData(CURRENT_FILE_RUN_CONFIGS_KEY, (Object)cache);
        }
        return cache.myRunConfigs;
    }

    @NotNull
    private List<RunnerAndConfigurationSettings> filterConfigsThatHaveRunner(@NotNull List<? extends RunnerAndConfigurationSettings> runConfigs) {
        if (runConfigs == null) {
            ExecutorAction.$$$reportNull$$$0(14);
        }
        List list = ContainerUtil.filter(runConfigs, config -> ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)config.getConfiguration()) != null);
        if (list == null) {
            ExecutorAction.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static boolean isSuppressed(Project project) {
        for (ExecutionActionSuppressor suppressor : ExecutionActionSuppressor.EP_NAME.getExtensionList()) {
            if (!suppressor.isSuppressed(project)) continue;
            return true;
        }
        return false;
    }

    protected Icon getInformativeIcon(@NotNull Project project, @NotNull RunnerAndConfigurationSettings selectedConfiguration, @NotNull AnActionEvent e) {
        RunnerIconProvider provider;
        Icon icon;
        RunConfiguration configuration;
        if (project == null) {
            ExecutorAction.$$$reportNull$$$0(16);
        }
        if (selectedConfiguration == null) {
            ExecutorAction.$$$reportNull$$$0(17);
        }
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(18);
        }
        if ((configuration = selectedConfiguration.getConfiguration()) instanceof RunnerIconProvider && (icon = (provider = (RunnerIconProvider)configuration).getExecutorIcon(configuration, this.myExecutor)) != null) {
            return icon;
        }
        List<RunContentDescriptor> runningDescriptors = this.getRunningDescriptors(project, selectedConfiguration);
        if (ExecutorAction.needRerunPresentation(configuration, runningDescriptors)) {
            if (ExperimentalUI.isNewUI() && this.myExecutor.getIcon() != this.myExecutor.getRerunIcon()) {
                return this.myExecutor.getRerunIcon();
            }
            if ("Run".equals(this.myExecutor.getId())) {
                return AllIcons.Actions.Restart;
            }
        }
        if (runningDescriptors.isEmpty()) {
            return this.myExecutor.getIcon();
        }
        if (runningDescriptors.size() == 1) {
            return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
        }
        return IconUtil.addText((Icon)this.myExecutor.getIcon(), (String)RunToolbarPopupKt.runCounterToString(e, runningDescriptors.size()));
    }

    private static boolean needRerunPresentation(RunConfiguration configuration, List<RunContentDescriptor> runningDescriptors) {
        return !configuration.isAllowRunningInParallel() && !runningDescriptors.isEmpty();
    }

    @NotNull
    private List<RunContentDescriptor> getRunningDescriptors(@NotNull Project project, @NotNull RunnerAndConfigurationSettings selectedConfiguration) {
        ExecutionManagerImpl executionManager;
        if (project == null) {
            ExecutorAction.$$$reportNull$$$0(19);
        }
        if (selectedConfiguration == null) {
            ExecutorAction.$$$reportNull$$$0(20);
        }
        if ((executionManager = ExecutionManagerImpl.getInstanceIfCreated(project)) == null) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                ExecutorAction.$$$reportNull$$$0(21);
            }
            return list;
        }
        List runningDescriptors = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)s -> ExecutionManagerImplKt.isOfSameType(s, selectedConfiguration)));
        List list = runningDescriptors = ContainerUtil.filter(runningDescriptors, descriptor -> executionManager.getExecutors((RunContentDescriptor)descriptor).contains(this.myExecutor));
        if (list == null) {
            ExecutorAction.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    protected RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(23);
        }
        RunManager runManager = (project = e.getProject()) == null ? null : RunManager.getInstanceIfCreated((Project)project);
        return runManager == null ? null : runManager.getSelectedConfiguration();
    }

    protected void run(@NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
        if (project == null) {
            ExecutorAction.$$$reportNull$$$0(24);
        }
        if (settings == null) {
            ExecutorAction.$$$reportNull$$$0(25);
        }
        if (dataContext == null) {
            ExecutorAction.$$$reportNull$$$0(26);
        }
        ExecutorRegistryImpl.RunnerHelper.run(project, settings.getConfiguration(), settings, dataContext, this.myExecutor);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(27);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return;
        }
        RunnerAndConfigurationSettings selectedConfiguration = this.getSelectedConfiguration(e);
        if (selectedConfiguration != null) {
            this.run(project, selectedConfiguration, e.getDataContext());
        } else if (RunConfigurationsComboBoxAction.hasRunCurrentFileItem(project)) {
            this.runCurrentFile(e);
        }
    }

    private void runCurrentFile(@NotNull AnActionEvent e) {
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(28);
        }
        Project project = Objects.requireNonNull(e.getProject());
        List<RunnerAndConfigurationSettings> runConfigs = this.getRunCurrentFileActionStatus((AnActionEvent)e, (boolean)true).myRunConfigs;
        if (runConfigs.isEmpty()) {
            return;
        }
        if (runConfigs.size() == 1) {
            this.doRunCurrentFile(project, runConfigs.get(0), e.getDataContext());
            return;
        }
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(runConfigs).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                RunnerAndConfigurationSettings runConfig = (RunnerAndConfigurationSettings)value;
                JLabel result2 = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                result2.setIcon(runConfig.getConfiguration().getIcon());
                result2.setText(runConfig.getName());
                return result2;
            }
        }).setItemChosenCallback(runConfig -> this.doRunCurrentFile(project, (RunnerAndConfigurationSettings)runConfig, e.getDataContext()));
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            builder2.createPopup().showUnderneathOf(inputEvent.getComponent());
        } else {
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                LOG.warn("Run Current File (" + String.valueOf(runConfigs) + "): getSelectedTextEditor() == null");
                return;
            }
            builder2.setTitle(this.myExecutor.getActionName()).createPopup().showInBestPositionFor(editor);
        }
    }

    protected void doRunCurrentFile(@NotNull Project project, @NotNull RunnerAndConfigurationSettings runConfig, @NotNull DataContext dataContext) {
        if (project == null) {
            ExecutorAction.$$$reportNull$$$0(29);
        }
        if (runConfig == null) {
            ExecutorAction.$$$reportNull$$$0(30);
        }
        if (dataContext == null) {
            ExecutorAction.$$$reportNull$$$0(31);
        }
        ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)runConfig, (Executor)this.myExecutor, null, null, (DataContext)dataContext, env -> env.setRunningCurrentFile(true));
    }

    @NotNull
    public @NotNull Collection<@NotNull Permission> getRequiredPermissions() {
        List<Permission> list = List.of(PermissionsKt.getFullRunAccess());
        if (list == null) {
            ExecutorAction.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 10, 11, 12, 15, 21, 22, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ExecutorAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigs";
                break;
            }
            case 16: 
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedConfiguration";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ExecutorAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunCurrentFileActionStatus";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterConfigsThatHaveRunner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningDescriptors";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredPermissions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 32: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupActionStatus";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRunCurrentFileActionStatus";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigsForCurrentFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterConfigsThatHaveRunner";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInformativeIcon";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRunningDescriptors";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedConfiguration";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runCurrentFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doRunCurrentFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 10, 11, 12, 15, 21, 22, 32 -> new IllegalStateException(string);
        };
    }

    private record RunCurrentFileActionStatus(boolean enabled, @Nls @NotNull String tooltip, @NotNull Icon icon, @NotNull List<RunnerAndConfigurationSettings> myRunConfigs) {
        @Nls
        @NotNull
        private final String tooltip;
        @NotNull
        private final Icon icon;
        @NotNull
        private final List<RunnerAndConfigurationSettings> myRunConfigs;

        private RunCurrentFileActionStatus(boolean enabled, @Nls @NotNull String tooltip, @NotNull Icon icon, @NotNull List<RunnerAndConfigurationSettings> myRunConfigs) {
            if (tooltip == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(1);
            }
            if (myRunConfigs == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        static RunCurrentFileActionStatus createDisabled(@Nls @NotNull String tooltip, @NotNull Icon icon) {
            if (tooltip == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(3);
            }
            if (icon == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(4);
            }
            return new RunCurrentFileActionStatus(false, tooltip, icon, Collections.emptyList());
        }

        @NotNull
        static RunCurrentFileActionStatus createEnabled(@Nls @NotNull String tooltip, @NotNull Icon icon, @NotNull List<RunnerAndConfigurationSettings> runConfigs) {
            if (tooltip == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(5);
            }
            if (icon == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(6);
            }
            if (runConfigs == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(7);
            }
            return new RunCurrentFileActionStatus(true, tooltip, icon, runConfigs);
        }

        @Nls
        @NotNull
        public String tooltip() {
            String string = this.tooltip;
            if (string == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public Icon icon() {
            Icon icon = this.icon;
            if (icon == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(9);
            }
            return icon;
        }

        @NotNull
        public List<RunnerAndConfigurationSettings> myRunConfigs() {
            List<RunnerAndConfigurationSettings> list = this.myRunConfigs;
            if (list == null) {
                RunCurrentFileActionStatus.$$$reportNull$$$0(10);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltip";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myRunConfigs";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfigs";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ExecutorAction$RunCurrentFileActionStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ExecutorAction$RunCurrentFileActionStatus";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tooltip";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "icon";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "myRunConfigs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDisabled";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createEnabled";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    private record RunCurrentFileInfo(long myPsiModCount, @NotNull List<RunnerAndConfigurationSettings> myRunConfigs) {
        @NotNull
        private final List<RunnerAndConfigurationSettings> myRunConfigs;

        /*
         * WARNING - void declaration
         */
        private RunCurrentFileInfo(long myPsiModCount, @NotNull List<RunnerAndConfigurationSettings> list) {
            void myRunConfigs;
            if (list == null) {
                RunCurrentFileInfo.$$$reportNull$$$0(0);
            }
            this.myPsiModCount = myPsiModCount;
            this.myRunConfigs = myRunConfigs;
        }

        @NotNull
        public List<RunnerAndConfigurationSettings> myRunConfigs() {
            List<RunnerAndConfigurationSettings> list = this.myRunConfigs;
            if (list == null) {
                RunCurrentFileInfo.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myRunConfigs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ExecutorAction$RunCurrentFileInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ExecutorAction$RunCurrentFileInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "myRunConfigs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

