/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunConfigurationSelector;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CompoundRunConfigurationSettingsEditor
extends SettingsEditor<CompoundRunConfiguration> {
    private final Project myProject;
    private final JBList<Pair<RunConfiguration, ExecutionTarget>> myList;
    private final RunManagerImpl myRunManager;
    private final SortedListModel<Pair<RunConfiguration, ExecutionTarget>> myModel;
    private CompoundRunConfiguration mySnapshot;

    public CompoundRunConfigurationSettingsEditor(@NotNull Project project) {
        if (project == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRunManager = RunManagerImpl.getInstanceImpl(project);
        this.myModel = new SortedListModel((o1, o2) -> CompoundRunConfiguration.COMPARATOR.compare((RunConfiguration)o1.first, (RunConfiguration)o2.first));
        this.myList = new JBList(this.myModel);
        this.myList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setIcon(((RunConfiguration)value.first).getType().getIcon());
            label2.setText(ConfigurationSelectionUtil.getDisplayText((RunConfiguration)value.first, (ExecutionTarget)value.second));
        }));
        this.myList.setVisibleRowCount(15);
    }

    private boolean canBeAdded(@NotNull RunConfiguration candidate, @NotNull CompoundRunConfiguration root) {
        if (candidate == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(1);
        }
        if (root == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(2);
        }
        if (candidate.getType() == root.getType() && candidate.getName().equals(root.getName())) {
            return false;
        }
        List<BeforeRunTask<?>> tasks = RunManagerImplKt.doGetBeforeRunTasks(candidate);
        for (BeforeRunTask<?> task2 : tasks) {
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runTask;
            RunnerAndConfigurationSettings settings;
            if (!(task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()) == null || this.canBeAdded(settings.getConfiguration(), root)) continue;
            return false;
        }
        if (candidate instanceof CompoundRunConfiguration) {
            for (RunConfiguration configuration : ((CompoundRunConfiguration)candidate).getConfigurationsWithTargets(this.myRunManager).keySet()) {
                if (this.canBeAdded(configuration, root)) continue;
                return false;
            }
        }
        return true;
    }

    protected void resetEditorFrom(@NotNull CompoundRunConfiguration compoundRunConfiguration) {
        if (compoundRunConfiguration == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(3);
        }
        this.myModel.clear();
        Map<RunConfiguration, ExecutionTarget> map = compoundRunConfiguration.getConfigurationsWithTargets(this.myRunManager);
        this.myModel.addAll((Collection)ContainerUtil.map(map.entrySet(), entry -> Pair.create((Object)((RunConfiguration)entry.getKey()), (Object)((ExecutionTarget)entry.getValue()))));
        this.mySnapshot = compoundRunConfiguration;
    }

    protected void applyEditorTo(@NotNull CompoundRunConfiguration compoundConfiguration) throws ConfigurationException {
        if (compoundConfiguration == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(4);
        }
        LinkedHashMap<RunConfiguration, ExecutionTarget> checked = new LinkedHashMap<RunConfiguration, ExecutionTarget>();
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            Pair configurationAndTarget = (Pair)this.myModel.get(i);
            RunConfiguration configuration = (RunConfiguration)configurationAndTarget.first;
            String message = LangBundle.message((String)"compound.run.configuration.cycle", (Object[])new Object[]{configuration.getType().getDisplayName(), configuration.getName()});
            if (!this.canBeAdded(configuration, compoundConfiguration)) {
                throw new ConfigurationException(message);
            }
            checked.put(configuration, (ExecutionTarget)configurationAndTarget.second);
        }
        compoundConfiguration.setConfigurationsWithTargets(checked);
    }

    @NotNull
    protected JComponent createEditor() {
        final ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ArrayList<RunConfiguration> configurations = new ArrayList<RunConfiguration>();
                for (RunnerAndConfigurationSettings settings : CompoundRunConfigurationSettingsEditor.this.myRunManager.getAllSettings()) {
                    RunConfiguration configuration = settings.getConfiguration();
                    if (CompoundRunConfigurationSettingsEditor.this.mySnapshot.getConfigurationsWithTargets(CompoundRunConfigurationSettingsEditor.this.myRunManager).containsKey(configuration) || !CompoundRunConfigurationSettingsEditor.this.canBeAdded(configuration, CompoundRunConfigurationSettingsEditor.this.mySnapshot)) continue;
                    configurations.add(configuration);
                }
                ConfigurationSelectionUtil.createPopup(CompoundRunConfigurationSettingsEditor.this.myProject, CompoundRunConfigurationSettingsEditor.this.myRunManager, configurations, (selectedConfigs, selectedTarget) -> {
                    for (RunConfiguration each : selectedConfigs) {
                        CompoundRunConfigurationSettingsEditor.this.myModel.add((Object)Pair.create((Object)each, (Object)selectedTarget));
                    }
                }).showUnderneathOf((Component)decorator.getActionsPanel());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int index = CompoundRunConfigurationSettingsEditor.this.myList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                RunConfiguration configuration = (RunConfiguration)((Pair)CompoundRunConfigurationSettingsEditor.this.myModel.get((int)index)).first;
                RunConfigurationSelector selector2 = (RunConfigurationSelector)RunConfigurationSelector.KEY.getData(DataManager.getInstance().getDataContext((Component)button.getContextComponent()));
                if (selector2 != null) {
                    selector2.select(configuration);
                }
            }
        });
        JPanel jPanel = decorator.createPanel();
        if (jPanel == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeAdded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

