/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunContentExecutor
implements Disposable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final List<Filter> myFilterList;
    private Runnable myRerunAction;
    private Runnable myStopAction;
    private Runnable myAfterCompletion;
    private Computable<Boolean> myStopEnabled;
    @NlsContexts.TabTitle
    private String myTitle;
    private String myHelpId;
    private boolean myActivateToolWindow;
    private boolean myFocusToolWindow;
    private ConsoleView myUserProvidedConsole;

    public RunContentExecutor(@NotNull Project project, @NotNull ProcessHandler process2) {
        if (project == null) {
            RunContentExecutor.$$$reportNull$$$0(0);
        }
        if (process2 == null) {
            RunContentExecutor.$$$reportNull$$$0(1);
        }
        this.myFilterList = new ArrayList<Filter>();
        this.myTitle = ExecutionBundle.message((String)"output.tab.default.title", (Object[])new Object[0]);
        this.myHelpId = null;
        this.myActivateToolWindow = true;
        this.myFocusToolWindow = true;
        this.myProject = project;
        this.myProcess = process2;
    }

    public RunContentExecutor withFilter(Filter filter) {
        this.myFilterList.add(filter);
        return this;
    }

    public RunContentExecutor withTitle(@NlsContexts.TabTitle String title) {
        this.myTitle = title;
        return this;
    }

    public RunContentExecutor withRerun(Runnable rerun) {
        this.myRerunAction = rerun;
        return this;
    }

    public RunContentExecutor withStop(@NotNull Runnable stop, @NotNull Computable<Boolean> stopEnabled) {
        if (stop == null) {
            RunContentExecutor.$$$reportNull$$$0(2);
        }
        if (stopEnabled == null) {
            RunContentExecutor.$$$reportNull$$$0(3);
        }
        this.myStopAction = stop;
        this.myStopEnabled = stopEnabled;
        return this;
    }

    public RunContentExecutor withAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
        return this;
    }

    public RunContentExecutor withHelpId(String helpId) {
        this.myHelpId = helpId;
        return this;
    }

    public RunContentExecutor withActivateToolWindow(boolean activateToolWindow) {
        this.myActivateToolWindow = activateToolWindow;
        return this;
    }

    public RunContentExecutor withFocusToolWindow(boolean focusToolWindow) {
        this.myFocusToolWindow = focusToolWindow;
        return this;
    }

    private ConsoleView createConsole() {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        consoleBuilder.filters(this.myFilterList);
        ConsoleView console = consoleBuilder.getConsole();
        if (this.myHelpId != null) {
            console.setHelpId(this.myHelpId);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        JComponent consolePanel = RunContentExecutor.createConsolePanel(console, (ActionGroup)actions);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, this.myProcess, consolePanel, this.myTitle);
        descriptor.setActivateToolWindowWhenAdded(this.myActivateToolWindow);
        descriptor.setAutoFocusContent(this.myFocusToolWindow);
        Disposer.register((Disposable)descriptor, (Disposable)this);
        Disposer.register((Disposable)descriptor, (Disposable)console);
        actions.add((AnAction)new RerunAction(consolePanel));
        actions.add((AnAction)new StopAction());
        actions.add((AnAction)new CloseAction(executor, descriptor, this.myProject));
        RunContentManager.getInstance((Project)this.myProject).showRunContent(executor, descriptor);
        return console;
    }

    public void run() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ConsoleView view = this.myUserProvidedConsole != null ? this.myUserProvidedConsole : this.createConsole();
        view.attachToProcess(this.myProcess);
        if (this.myAfterCompletion != null) {
            this.myProcess.addProcessListener(new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(RunContentExecutor.this.myAfterCompletion);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/RunContentExecutor$1", "processTerminated"));
                }
            });
        }
        this.myProcess.startNotify();
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)view.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RunContentExecutor", actions, false);
        actionToolbar.setTargetComponent((JComponent)panel2);
        panel2.add((Component)actionToolbar.getComponent(), "West");
        return panel2;
    }

    public void dispose() {
    }

    @NotNull
    public RunContentExecutor withConsole(@Nullable ConsoleView console) {
        this.myUserProvidedConsole = console;
        RunContentExecutor runContentExecutor = this;
        if (runContentExecutor == null) {
            RunContentExecutor.$$$reportNull$$$0(4);
        }
        return runContentExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopEnabled";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/RunContentExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/RunContentExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withStop";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private final class RerunAction
    extends AnAction {
        RerunAction(JComponent consolePanel) {
            super(CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.text.rerun", (Object[])new Object[0]), AllIcons.Actions.Restart);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consolePanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            RunContentExecutor.this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(RunContentExecutor.this.myRerunAction != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RerunAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/RunContentExecutor$RerunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/RunContentExecutor$RerunAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class StopAction
    extends AnAction
    implements DumbAware {
        StopAction() {
            super(ExecutionBundle.messagePointer((String)"action.AnAction.text.stop", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"action.AnAction.description.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(0);
            }
            RunContentExecutor.this.myStopAction.run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(RunContentExecutor.this.myStopAction != null);
            e.getPresentation().setEnabled(RunContentExecutor.this.myStopEnabled != null && (Boolean)RunContentExecutor.this.myStopEnabled.compute() != false);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                StopAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/RunContentExecutor$StopAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/RunContentExecutor$StopAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

