/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.SyntheticRunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAction
extends BaseRunConfigurationAction {
    public CreateAction() {
        this(null);
    }

    public CreateAction(@Nullable Icon icon) {
        super((Supplier<String>)ExecutionBundle.messagePointer((String)"create.run.configuration.action.name", (Object[])new Object[0]), (Supplier<String>)Presentation.NULL_STRING, icon);
        this.getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
    }

    @Override
    protected void perform(@NotNull RunnerAndConfigurationSettings configurationSettings, @NotNull ConfigurationContext context) {
        if (configurationSettings == null) {
            CreateAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CreateAction.$$$reportNull$$$0(1);
        }
        this.choosePolicy(context).perform(configurationSettings, context);
    }

    @Override
    protected void updatePresentation(@NotNull Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        if (presentation == null) {
            CreateAction.$$$reportNull$$$0(2);
        }
        if (actionText == null) {
            CreateAction.$$$reportNull$$$0(3);
        }
        this.choosePolicy(context).update(presentation, context, actionText);
    }

    private BaseCreatePolicy choosePolicy(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration = this.findExisting(context);
        if (configuration == null) {
            return Holder.CREATE_AND_EDIT;
        }
        if (configuration.getConfiguration() instanceof SyntheticRunConfigurationBase) {
            return Holder.DISABLED;
        }
        return Holder.EDIT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/actions/CreateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class BaseCreatePolicy {
        private BaseCreatePolicy() {
        }

        public void update(Presentation presentation, ConfigurationContext context, @NotNull String actionText) {
            if (actionText == null) {
                BaseCreatePolicy.$$$reportNull$$$0(0);
            }
            this.updateText(presentation, actionText);
        }

        protected abstract void updateText(Presentation var1, String var2);

        protected abstract void perform(RunnerAndConfigurationSettings var1, ConfigurationContext var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/CreateAction$BaseCreatePolicy", "update"));
        }
    }

    private static final class Holder {
        private static final BaseCreatePolicy CREATE_AND_EDIT = new CreateAndEditPolicy();
        private static final BaseCreatePolicy EDIT = new EditPolicy();
        private static final BaseCreatePolicy DISABLED = new BaseCreatePolicy(){

            @Override
            public void update(Presentation presentation, ConfigurationContext context, @NotNull String actionText) {
                if (actionText == null) {
                    1.$$$reportNull$$$0(0);
                }
                presentation.setEnabledAndVisible(false);
            }

            @Override
            protected void updateText(Presentation presentation, String actionText) {
            }

            @Override
            protected void perform(RunnerAndConfigurationSettings configurationSettings, ConfigurationContext context) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/execution/actions/CreateAction$Holder$1", "update"));
            }
        };

        private Holder() {
        }
    }

    private static final class EditPolicy
    extends CreateAndEditPolicy {
        private EditPolicy() {
        }

        @Override
        protected void perform(RunnerAndConfigurationSettings configuration, ConfigurationContext context) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunDialog.editConfiguration(context.getProject(), configuration, ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}));
            }
        }
    }

    private static class CreateAndEditPolicy
    extends BaseCreatePolicy {
        private CreateAndEditPolicy() {
        }

        @Override
        protected void updateText(Presentation presentation, String actionText) {
            presentation.setText(ExecutionBundle.message((String)"create.run.configuration.action.name", (Object[])new Object[0]), false);
        }

        @Override
        protected void perform(RunnerAndConfigurationSettings configuration, ConfigurationContext context) {
            if (ApplicationManager.getApplication().isUnitTestMode() || RunDialog.editConfiguration(context.getProject(), configuration, ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}))) {
                RunManagerImpl runManager = (RunManagerImpl)context.getRunManager();
                runManager.addConfiguration(configuration);
                runManager.setSelectedConfiguration(configuration);
                RunConfigurationOptionUsagesCollector.logAddNew(context.getProject(), configuration.getType().getId(), context.getPlace());
            }
        }
    }
}

