/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.impl.BeforeRunStepsPanel;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.impl.ConfigurationSettingsEditorPanel;
import com.intellij.execution.impl.RunConfigurationStorageUi;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunOnTargetPanel;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunConfigurationFragmentedEditor;
import com.intellij.execution.ui.RunnerAndConfigurationSettingsEditor;
import com.intellij.execution.ui.TargetAwareRunConfigurationEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationSettingsEditorWrapper
extends SettingsEditor<RunnerAndConfigurationSettings>
implements BeforeRunStepsPanel.StepsBeforeRunListener,
TargetAwareRunConfigurationEditor {
    public static final DataKey<ConfigurationSettingsEditorWrapper> CONFIGURATION_EDITOR_KEY = DataKey.create((String)"ConfigurationSettingsEditor");
    private final ConfigurationSettingsEditorPanel content;
    private final RunOnTargetPanel myRunOnTargetPanel;
    @Nullable
    private final RunConfigurationStorageUi myRCStorageUi;
    private final BeforeRunStepsPanel myBeforeRunStepsPanel;
    private final ConfigurationSettingsEditor myEditor;

    public <T extends SettingsEditor<?>> T selectExecutorAndGetEditor(ProgramRunner<?> runner, Class<T> editorClass) {
        return this.myEditor.selectExecutorAndGetEditor(runner, editorClass);
    }

    public <T extends SettingsEditor<?>> T selectTabAndGetEditor(Class<T> editorClass) {
        return this.myEditor.selectTabAndGetEditor(editorClass);
    }

    private ConfigurationSettingsEditorWrapper(@NotNull RunnerAndConfigurationSettings settings, @NotNull SettingsEditor<RunConfiguration> configurationEditor) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(0);
        }
        if (configurationEditor == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(1);
        }
        Project project = settings.getConfiguration().getProject();
        if (!project.isDefault() && settings.isTemplate()) {
            this.myRCStorageUi = new RunConfigurationStorageUi(project, () -> this.fireEditorStateChanged());
            this.content = new ConfigurationSettingsEditorPanel(this.myRCStorageUi.createComponent(), configurationEditor.isMaximizeEditorHeight());
            this.myRunOnTargetPanel = new RunOnTargetPanel(settings, this);
            this.myRunOnTargetPanel.buildUi(this.content.targetPanel, null);
        } else {
            this.content = new ConfigurationSettingsEditorPanel(null, configurationEditor.isMaximizeEditorHeight());
            this.myRCStorageUi = null;
            this.myRunOnTargetPanel = null;
        }
        this.myEditor = new ConfigurationSettingsEditor(settings, configurationEditor);
        this.myEditor.addSettingsEditorListener(editor -> this.fireStepsBeforeRunChanged());
        Disposer.register((Disposable)this, (Disposable)this.myEditor);
        this.myBeforeRunStepsPanel = new BeforeRunStepsPanel(this);
        this.content.beforeRunStepsPlaceholder.setComponent((JComponent)this.myBeforeRunStepsPanel);
        this.doReset(settings);
    }

    private void doReset(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(2);
        }
        this.myBeforeRunStepsPanel.doReset(settings);
        this.content.beforeRunStepsRow.visible(!(settings.getConfiguration() instanceof WithoutOwnBeforeRunSteps));
        this.content.isAllowRunningInParallelCheckBox.setSelected(settings.getConfiguration().isAllowRunningInParallel());
        this.content.isAllowRunningInParallelCheckBox.setVisible(settings.isTemplate() && settings.getFactory().getSingletonPolicy().isPolicyConfigurable());
        if (this.myRCStorageUi != null) {
            this.myRCStorageUi.reset(settings);
            this.myRunOnTargetPanel.reset();
        }
    }

    @NotNull
    protected JComponent createEditor() {
        this.content.componentPlace.setLayout(new BorderLayout());
        this.content.componentPlace.add((Component)this.myEditor.getComponent(), "Center");
        JComponent jComponent = UiDataProvider.wrapComponent((JComponent)this.content.panel, sink -> sink.set(CONFIGURATION_EDITOR_KEY, (Object)this));
        if (jComponent == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public boolean isSpecificallyModified() {
        return this.myRCStorageUi != null && this.myRCStorageUi.isModified() || this.myEditor.isSpecificallyModified();
    }

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(4);
        }
        this.myEditor.resetEditorFrom(settings);
        this.doReset(settings);
    }

    public void applyEditorTo(@NotNull RunnerAndConfigurationSettings settings) throws ConfigurationException {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(5);
        }
        this.myEditor.applyEditorTo(settings);
        this.doApply((RunnerAndConfigurationSettingsImpl)settings, false);
        if (this.myRunOnTargetPanel != null) {
            this.myRunOnTargetPanel.apply();
        }
    }

    @NotNull
    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings result2 = this.myEditor.getSnapshot();
        this.doApply((RunnerAndConfigurationSettingsImpl)result2, true);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result2;
        if (runnerAndConfigurationSettings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(6);
        }
        return runnerAndConfigurationSettings;
    }

    boolean supportsSnapshots() {
        return this.myEditor.supportsSnapshots();
    }

    private void doApply(@NotNull RunnerAndConfigurationSettingsImpl settings, boolean isSnapshot) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(7);
        }
        RunConfiguration runConfiguration = settings.getConfiguration();
        List tasks = ContainerUtil.copyList(this.myBeforeRunStepsPanel.getTasks());
        RunnerAndConfigurationSettingsImpl settingsToApply = null;
        if (isSnapshot) {
            runConfiguration.setBeforeRunTasks(tasks);
        } else {
            RunManagerImpl runManager = settings.getManager();
            runManager.setBeforeRunTasks(runConfiguration, tasks);
            settingsToApply = runManager.getSettings(runConfiguration);
        }
        if (settingsToApply == null) {
            settingsToApply = settings;
        }
        settingsToApply.setEditBeforeRun(this.myBeforeRunStepsPanel.needEditBeforeRun());
        settingsToApply.setActivateToolWindowBeforeRun(this.myBeforeRunStepsPanel.needActivateToolWindowBeforeRun());
        settingsToApply.setFocusToolWindowBeforeRun(this.myBeforeRunStepsPanel.needFocusToolWindowBeforeRun());
        if (this.content.isAllowRunningInParallelCheckBox.isVisible()) {
            settings.getConfiguration().setAllowRunningInParallel(this.content.isAllowRunningInParallelCheckBox.isSelected());
        }
        if (this.myRCStorageUi != null) {
            this.myRCStorageUi.apply(settings);
            if (!isSnapshot) {
                this.myRCStorageUi.reset(settings);
            }
        }
    }

    public void addBeforeLaunchStep(@NotNull BeforeRunTask<?> task2) {
        if (task2 == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(8);
        }
        this.myBeforeRunStepsPanel.addTask(task2);
    }

    public void replaceBeforeLaunchSteps(@NotNull List<BeforeRunTask<?>> tasks) {
        if (tasks == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(9);
        }
        this.myBeforeRunStepsPanel.replaceTasks(tasks);
    }

    @NotNull
    public List<BeforeRunTask<?>> getStepsBeforeLaunch() {
        List<BeforeRunTask<?>> list = this.myBeforeRunStepsPanel.getTasks();
        if (list == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public void fireStepsBeforeRunChanged() {
        this.fireEditorStateChanged();
    }

    @Override
    public void titleChanged(@NotNull String title) {
        if (title == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(11);
        }
        this.content.beforeRunStepsRow.setTitle(title);
    }

    @Override
    public void targetChanged(String targetName) {
        this.myEditor.targetChanged(targetName);
    }

    public static SettingsEditor<RunnerAndConfigurationSettings> createWrapper(@NotNull RunnerAndConfigurationSettings settings) {
        SettingsEditor configurationEditor;
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(12);
        }
        return (configurationEditor = settings.getConfiguration().getConfigurationEditor()) instanceof RunConfigurationFragmentedEditor ? new RunnerAndConfigurationSettingsEditor(settings, (RunConfigurationFragmentedEditor)configurationEditor) : new ConfigurationSettingsEditorWrapper(settings, (SettingsEditor<RunConfiguration>)configurationEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationEditor";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepsBeforeLaunch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doReset";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doApply";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeLaunchStep";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceBeforeLaunchSteps";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "titleChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createWrapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 10 -> new IllegalStateException(string);
        };
    }
}

