/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TokenBuffer {
    public static final TokenInfo CR_TOKEN = new TokenInfo(ConsoleViewContentType.SYSTEM_OUTPUT, "\r", null);
    private final int maxCapacity;
    private final Deque<TokenInfo> tokens = new ArrayDeque<TokenInfo>(10);
    private int size;
    private int startIndex;

    @ApiStatus.Internal
    public TokenBuffer(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        if (maxCapacity <= 0) {
            throw new IllegalArgumentException(String.valueOf(maxCapacity));
        }
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        if (text == null) {
            TokenBuffer.$$$reportNull$$$0(0);
        }
        if (contentType == null) {
            TokenBuffer.$$$reportNull$$$0(1);
        }
        int start2 = 0;
        while (start2 < text.length()) {
            TokenInfo tokenInfo;
            int crIndex;
            if (this.hasTrailingCR()) {
                this.combineTrailingCRWith(text);
            }
            if ((crIndex = text.indexOf(13, start2)) == -1 || crIndex == text.length() - 1) {
                tokenInfo = new TokenInfo(contentType, text.substring(start2), info);
                this.tokens.addLast(tokenInfo);
                this.size += tokenInfo.length();
                break;
            }
            if (start2 != crIndex) {
                tokenInfo = new TokenInfo(contentType, text.substring(start2, crIndex), info);
                this.tokens.addLast(tokenInfo);
                this.size += tokenInfo.length();
            }
            this.removeLastLine();
            start2 = crIndex + 1;
        }
        this.trim();
    }

    private boolean hasTrailingCR() {
        return !this.tokens.isEmpty() && this.tokens.peekLast() != CR_TOKEN && StringUtil.endsWithChar((CharSequence)this.tokens.peekLast().getText(), (char)'\r');
    }

    private void combineTrailingCRWith(@NotNull String currentText) {
        if (currentText == null) {
            TokenBuffer.$$$reportNull$$$0(2);
        }
        if (StringUtil.startsWith((CharSequence)currentText, (CharSequence)"\n")) {
            TokenInfo last = this.tokens.removeLast();
            String lastTextWithNoCR = last.getText().substring(0, last.length() - 1);
            if (!lastTextWithNoCR.isEmpty()) {
                TokenInfo newLast = new TokenInfo(last.contentType, lastTextWithNoCR, last.getHyperlinkInfo());
                this.tokens.addLast(newLast);
                --this.size;
            }
            return;
        }
        this.removeLastLine();
    }

    private void removeLastLine() {
        while (!this.tokens.isEmpty() && this.tokens.peekLast() != CR_TOKEN) {
            TokenInfo last = this.tokens.removeLast();
            String text = last.getText();
            int lfIndex = text.lastIndexOf(10);
            if (lfIndex != -1) {
                TokenInfo newToken = new TokenInfo(last.contentType, text.substring(0, lfIndex + 1), last.getHyperlinkInfo());
                this.tokens.addLast(newToken);
                this.size -= text.length() - newToken.length();
                return;
            }
            this.size -= text.length();
        }
        if (this.tokens.isEmpty()) {
            this.tokens.addLast(CR_TOKEN);
            ++this.size;
        }
    }

    private void trim() {
        int excess = this.size - this.maxCapacity;
        while (excess > this.startIndex) {
            TokenInfo info = this.tokens.getFirst();
            int length = info.length();
            if (length > excess) {
                this.startIndex = excess;
                break;
            }
            this.startIndex = 0;
            this.tokens.removeFirst();
            this.size -= info.length();
            excess = this.size - this.maxCapacity;
        }
        assert (this.startIndex >= 0 && this.size >= 0 && this.maxCapacity >= 0) : "startIndex=" + this.startIndex + "; size=" + this.size + "; maxCapacity=" + this.maxCapacity;
    }

    @ApiStatus.Internal
    public int length() {
        return this.size - this.startIndex;
    }

    @ApiStatus.Internal
    public void clear() {
        this.tokens.clear();
        this.startIndex = 0;
        this.size = 0;
    }

    @ApiStatus.Internal
    @NotNull
    public static CharSequence getRawText(@NotNull List<? extends TokenInfo> tokens) {
        if (tokens == null) {
            TokenBuffer.$$$reportNull$$$0(3);
        }
        int size = 0;
        for (TokenInfo tokenInfo : tokens) {
            size += tokenInfo.getText().length();
        }
        StringBuilder result2 = new StringBuilder(size);
        for (TokenInfo tokenInfo : tokens) {
            result2.append(tokenInfo.getText());
        }
        String string = result2.toString();
        if (string == null) {
            TokenBuffer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<TokenInfo> drain() {
        if (this.hasTrailingCR()) {
            this.removeLastLine();
        }
        List<TokenInfo> list = this.getInfos();
        List<TokenInfo> list2 = list;
        if (list2 == null) {
            TokenBuffer.$$$reportNull$$$0(5);
        }
        return list2;
        finally {
            this.clear();
        }
    }

    @NotNull
    private List<TokenInfo> getInfos() {
        ArrayList<TokenInfo> list;
        ArrayList<TokenInfo> arrayList = list = this.tokens.isEmpty() ? Collections.emptyList() : new ArrayList<TokenInfo>(this.tokens);
        if (this.startIndex != 0) {
            TokenInfo first = (TokenInfo)list.get(0);
            TokenInfo sliced = new TokenInfo(first.contentType, first.getText().substring(this.startIndex), first.getHyperlinkInfo());
            List list2 = ContainerUtil.concat(Collections.singletonList(sliced), list.subList(1, list.size()));
            if (list2 == null) {
                TokenBuffer.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<TokenInfo> arrayList2 = list;
        if (arrayList2 == null) {
            TokenBuffer.$$$reportNull$$$0(7);
        }
        return arrayList2;
    }

    public int getCycleBufferSize() {
        return this.maxCapacity;
    }

    public String toString() {
        return TokenBuffer.getRawText(this.getInfos()).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/TokenBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/TokenBuffer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "drain";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineTrailingCRWith";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRawText";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class TokenInfo {
        @NotNull
        public final ConsoleViewContentType contentType;
        private final String text;
        private final HyperlinkInfo myHyperlinkInfo;

        public TokenInfo(@NotNull ConsoleViewContentType contentType, @NotNull String text, @Nullable HyperlinkInfo hyperlinkInfo) {
            if (contentType == null) {
                TokenInfo.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TokenInfo.$$$reportNull$$$0(1);
            }
            this.contentType = contentType;
            this.myHyperlinkInfo = hyperlinkInfo;
            this.text = text;
        }

        @ApiStatus.Internal
        public int length() {
            return this.text.length();
        }

        public String toString() {
            return String.valueOf(this.contentType) + "[" + this.length() + "]";
        }

        @ApiStatus.Internal
        public HyperlinkInfo getHyperlinkInfo() {
            return this.myHyperlinkInfo;
        }

        @NotNull
        @ApiStatus.Internal
        public String getText() {
            String string = this.text;
            if (string == null) {
                TokenInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/TokenBuffer$TokenInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/TokenBuffer$TokenInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

