/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.impl.statistics.FusAwareRunConfiguration;
import com.intellij.execution.multilaunch.MultiLaunchConfigurationError;
import com.intellij.execution.multilaunch.MultiLaunchProfileState;
import com.intellij.execution.multilaunch.design.ExecutableRow;
import com.intellij.execution.multilaunch.design.ExecutableRowFactoryKt;
import com.intellij.execution.multilaunch.design.MultiLaunchConfigurationEditor;
import com.intellij.execution.multilaunch.execution.conditions.Condition;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.execution.executables.ExecutableTemplate;
import com.intellij.execution.multilaunch.execution.executables.TaskExecutableTemplate;
import com.intellij.execution.multilaunch.execution.executables.impl.RunConfigurationExecutableManager;
import com.intellij.execution.multilaunch.state.ExecutableRowSnapshot;
import com.intellij.execution.multilaunch.state.MultiLaunchConfigurationSnapshot;
import com.intellij.execution.multilaunch.statistics.FusCondition;
import com.intellij.execution.multilaunch.statistics.FusExecutable;
import com.intellij.execution.multilaunch.statistics.FusExecutableKind;
import com.intellij.execution.multilaunch.statistics.FusExecutableRows;
import com.intellij.execution.multilaunch.statistics.FusExecutionRow;
import com.intellij.execution.multilaunch.statistics.MultiLaunchCreationOrigin;
import com.intellij.execution.multilaunch.statistics.MultiLaunchEventFields;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001(B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010#\u001a\u00020$H\u0017J\u0012\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/intellij/execution/multilaunch/state/MultiLaunchConfigurationSnapshot;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "Lcom/intellij/execution/impl/statistics/FusAwareRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "parameters", "getParameters", "()Lcom/intellij/execution/multilaunch/state/MultiLaunchConfigurationSnapshot;", "descriptors", "", "Lcom/intellij/execution/multilaunch/design/ExecutableRow;", "getDescriptors", "()Ljava/util/List;", "origin", "Lcom/intellij/execution/multilaunch/statistics/MultiLaunchCreationOrigin;", "getOrigin", "()Lcom/intellij/execution/multilaunch/statistics/MultiLaunchCreationOrigin;", "getState", "Lcom/intellij/execution/multilaunch/MultiLaunchProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "checkConfiguration", "", "validateRows", "rows", "getConfigurationEditor", "Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationEditor;", "getAdditionalUsageData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Companion", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nMultiLaunchConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiLaunchConfiguration.kt\ncom/intellij/execution/multilaunch/MultiLaunchConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1563#2:106\n1634#2,3:107\n1563#2:110\n1634#2,3:111\n*S KotlinDebug\n*F\n+ 1 MultiLaunchConfiguration.kt\ncom/intellij/execution/multilaunch/MultiLaunchConfiguration\n*L\n37#1:106\n37#1:107,3\n100#1:110\n100#1:111,3\n*E\n"})
public final class MultiLaunchConfiguration
extends RunConfigurationBase<MultiLaunchConfigurationSnapshot>
implements WithoutOwnBeforeRunSteps,
FusAwareRunConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<MultiLaunchCreationOrigin> ORIGIN_KEY;

    public MultiLaunchConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.project = project;
    }

    @NotNull
    public final MultiLaunchConfigurationSnapshot getParameters() {
        return this.getState();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExecutableRow> getDescriptors() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getState().getRows();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutableRowSnapshot executableRowSnapshot = (ExecutableRowSnapshot)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExecutableRowFactoryKt.toRow((ExecutableRowSnapshot)it, this.project, this));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final MultiLaunchCreationOrigin getOrigin() {
        MultiLaunchCreationOrigin multiLaunchCreationOrigin = (MultiLaunchCreationOrigin)((Object)this.getUserData(ORIGIN_KEY));
        if (multiLaunchCreationOrigin == null) {
            multiLaunchCreationOrigin = MultiLaunchCreationOrigin.EDIT_CONFIGURATIONS;
        }
        return multiLaunchCreationOrigin;
    }

    @ApiStatus.Internal
    @NotNull
    public MultiLaunchProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new MultiLaunchProfileState(this, this.project);
    }

    @NotNull
    public MultiLaunchConfigurationSnapshot getState() {
        RunConfigurationOptions runConfigurationOptions = this.getOptions();
        Intrinsics.checkNotNull((Object)runConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.execution.multilaunch.state.MultiLaunchConfigurationSnapshot");
        return (MultiLaunchConfigurationSnapshot)runConfigurationOptions;
    }

    public void checkConfiguration() {
        super.checkConfiguration();
        this.validateRows(this.getDescriptors());
    }

    private final void validateRows(List<ExecutableRow> rows) {
        if (this.getDescriptors().isEmpty()) {
            String string = ExecutionBundle.message((String)"run.configurations.multilaunch.error.at.least.one.task.required", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new MultiLaunchConfigurationError(string);
        }
        int n = ((Collection)rows).size();
        for (int i = 0; i < n; ++i) {
            ExecutableRow row = rows.get(i);
            int rowNumber = i + 1;
            if (row.getExecutable() == null) {
                String string = ExecutionBundle.message((String)"run.configurations.multilaunch.error.executable.not.found", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw new MultiLaunchConfigurationError(rowNumber, string);
            }
            Condition condition = row.getCondition();
            if (condition == null) {
                String string = ExecutionBundle.message((String)"run.configurations.multilaunch.error.condition.not.found", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw new MultiLaunchConfigurationError(rowNumber, string);
            }
            condition.validate(this, row);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public MultiLaunchConfigurationEditor getConfigurationEditor() {
        return new MultiLaunchConfigurationEditor(this.project, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getDescriptors();
        ObjectListEventField objectListEventField = FusExecutableRows.INSTANCE.getFIELD();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutableRow executableRow = (ExecutableRow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MultiLaunchConfiguration.getAdditionalUsageData$createEvent$1((ExecutableRow)it));
        }
        EventPair fusRows = objectListEventField.with((Object)((List)destination$iv$iv));
        EventPair fusActivateToolWindows = MultiLaunchEventFields.INSTANCE.getACTIVATE_TOOL_WINDOWS_FIELD().with((Object)this.getState().getActivateToolWindows());
        Object[] objectArray = new EventPair[]{fusRows, fusActivateToolWindows};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private static final ObjectEventData getAdditionalUsageData$createEvent(Executable executable) {
        ExecutableTemplate template = executable.getTemplate();
        ExecutableTemplate executableTemplate = template;
        FusExecutableKind kind = executableTemplate instanceof RunConfigurationExecutableManager ? FusExecutableKind.RUN_CONFIGURATION : (executableTemplate instanceof TaskExecutableTemplate ? FusExecutableKind.TASK : FusExecutableKind.UNKNOWN);
        String string = executable instanceof RunConfigurationExecutableManager.RunConfigurationExecutable ? ((RunConfigurationExecutableManager.RunConfigurationExecutable)executable).getSettings().getType().getId() : (template instanceof TaskExecutableTemplate ? template.getType() : "");
        Intrinsics.checkNotNull((Object)string);
        String typeId = string;
        return FusExecutable.Companion.createData(kind, typeId);
    }

    private static final ObjectEventData getAdditionalUsageData$createEvent$0(Condition condition) {
        return FusCondition.Companion.createData(condition.getTemplate().getType());
    }

    private static final ObjectEventData getAdditionalUsageData$createEvent$1(ExecutableRow row) {
        Executable executable = row.getExecutable();
        if (executable == null) {
            throw new CantRunException(ExecutionBundle.message((String)"run.configurations.multilaunch.error.missing.stored.executable", (Object[])new Object[0]));
        }
        Condition condition = row.getCondition();
        if (condition == null) {
            throw new CantRunException(ExecutionBundle.message((String)"run.configurations.multilaunch.error.missing.stored.condition", (Object[])new Object[0]));
        }
        return FusExecutionRow.Companion.createData(MultiLaunchConfiguration.getAdditionalUsageData$createEvent(executable), MultiLaunchConfiguration.getAdditionalUsageData$createEvent$0(condition), row.getDisableDebugging());
    }

    static {
        Key key = Key.create((String)"ORIGIN");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ORIGIN_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration$Companion;", "", "<init>", "()V", "ORIGIN_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/multilaunch/statistics/MultiLaunchCreationOrigin;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getORIGIN_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<MultiLaunchCreationOrigin> getORIGIN_KEY() {
            return ORIGIN_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

