/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.servicesView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.multilaunch.execution.ExecutableExecutionModel;
import com.intellij.execution.multilaunch.execution.MultiLaunchExecutionModel;
import com.intellij.execution.multilaunch.servicesView.ConfigurationServiceContributor;
import com.intellij.execution.multilaunch.servicesView.ExecutableServiceViewDescriptor;
import com.intellij.execution.multilaunch.servicesView.actions.configuration.DebugMultiLaunchAction;
import com.intellij.execution.multilaunch.servicesView.actions.configuration.RunMultiLaunchAction;
import com.intellij.execution.multilaunch.servicesView.actions.configuration.StopMultiLaunchAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBPanelWithEmptyText;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/multilaunch/servicesView/ConfigurationServiceContributor;", "Lcom/intellij/execution/services/ServiceViewProvidingContributor;", "Lcom/intellij/execution/multilaunch/execution/ExecutableExecutionModel;", "Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;", "model", "<init>", "(Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;)V", "getViewDescriptor", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getServices", "", "asService", "getServiceDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "service", "intellij.platform.execution.impl"})
public final class ConfigurationServiceContributor
implements ServiceViewProvidingContributor<ExecutableExecutionModel, MultiLaunchExecutionModel> {
    @NotNull
    private final MultiLaunchExecutionModel model;

    public ConfigurationServiceContributor(@NotNull MultiLaunchExecutionModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
    }

    @NotNull
    public SimpleServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.model.getConfiguration().getName();
        Icon icon = this.model.getConfiguration().getIcon();
        return new SimpleServiceViewDescriptor(this, string, icon){
            private final Lazy toolbarActions$delegate;
            {
                this.toolbarActions$delegate = LazyKt.lazy(() -> getViewDescriptor.1.toolbarActions_delegate$lambda$0($receiver));
            }

            private final DefaultActionGroup getToolbarActions() {
                Lazy lazy = this.toolbarActions$delegate;
                return (DefaultActionGroup)lazy.getValue();
            }

            public JComponent getContentComponent() {
                JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.configurations.multilaunch.services.select.executable.placeholder", (Object[])new Object[0]));
                Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
                return (JComponent)jBPanelWithEmptyText;
            }

            public ActionGroup getToolbarActions() {
                return (ActionGroup)this.getToolbarActions();
            }

            private static final DefaultActionGroup toolbarActions_delegate$lambda$0(ConfigurationServiceContributor this$0) {
                AnAction[] anActionArray = new AnAction[]{new RunMultiLaunchAction(ConfigurationServiceContributor.access$getModel$p(this$0).getSettings()), new DebugMultiLaunchAction(ConfigurationServiceContributor.access$getModel$p(this$0).getSettings()), new StopMultiLaunchAction(ConfigurationServiceContributor.access$getModel$p(this$0))};
                return new DefaultActionGroup(anActionArray);
            }
        };
    }

    @NotNull
    public List<ExecutableExecutionModel> getServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.toMutableList((Collection)this.model.getExecutables().values());
    }

    @NotNull
    public MultiLaunchExecutionModel asService() {
        return this.model;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull ExecutableExecutionModel service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return new ExecutableServiceViewDescriptor(this.model, service);
    }

    public static final /* synthetic */ MultiLaunchExecutionModel access$getModel$p(ConfigurationServiceContributor $this) {
        return $this.model;
    }
}

