/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.layout.actions.ViewLayoutModificationAction;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.custom.options.CustomContentLayoutOption;
import com.intellij.ui.content.custom.options.CustomContentLayoutOptions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ViewLayoutModeActionGroup
extends DefaultActionGroup
implements ViewLayoutModificationAction {
    @NotNull
    private final Content myContent;

    public ViewLayoutModeActionGroup(@NotNull Content content, @NotNull CustomContentLayoutOptions customContentLayoutOptions) {
        if (content == null) {
            ViewLayoutModeActionGroup.$$$reportNull$$$0(0);
        }
        if (customContentLayoutOptions == null) {
            ViewLayoutModeActionGroup.$$$reportNull$$$0(1);
        }
        super(customContentLayoutOptions.getDisplayName(), true);
        this.add((AnAction)new ViewLayoutModeAction(new HideContentLayoutModeOption(content, customContentLayoutOptions)));
        for (CustomContentLayoutOption option2 : customContentLayoutOptions.getAvailableOptions()) {
            this.add((AnAction)new ViewLayoutModeAction(option2));
        }
        this.myContent = content;
    }

    public boolean isDumbAware() {
        return true;
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            ViewLayoutModeActionGroup.$$$reportNull$$$0(2);
        }
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customContentLayoutOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class ViewLayoutModeAction
    extends DumbAwareToggleAction {
        private final CustomContentLayoutOption myOption;

        public ViewLayoutModeAction(@NotNull CustomContentLayoutOption option2) {
            if (option2 == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(0);
            }
            this.myOption = option2;
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(1);
            }
            return this.myOption.isSelected();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(3);
            }
            this.myOption.select();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            e.getPresentation().setEnabled(this.myOption.isEnabled());
            e.getPresentation().setText(this.myOption.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup$ViewLayoutModeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup$ViewLayoutModeAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class HideContentLayoutModeOption
    implements CustomContentLayoutOption {
        private final Content myContent;
        private final CustomContentLayoutOptions myOptions;

        public HideContentLayoutModeOption(Content content, CustomContentLayoutOptions options) {
            this.myContent = content;
            this.myOptions = options;
        }

        public boolean isSelected() {
            return this.myOptions.isHidden();
        }

        public void select() {
            this.myOptions.onHide();
        }

        public boolean isEnabled() {
            return this.myOptions.isHideOptionVisible();
        }

        @NotNull
        public String getDisplayName() {
            String string = IdeBundle.message((String)"run.layout.do.not.show.view.option.message", (Object[])new Object[0]);
            if (string == null) {
                HideContentLayoutModeOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup$HideContentLayoutModeOption", "getDisplayName"));
        }
    }
}

