/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.process.ColoredOutputTypeRegistryImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.TerminalColorPalette;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/terminal/JBTerminalSchemeColorPalette;", "Lcom/intellij/terminal/TerminalColorPalette;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "defaultForeground", "Lcom/jediterm/core/Color;", "getDefaultForeground", "()Lcom/jediterm/core/Color;", "defaultBackground", "getDefaultBackground", "getAttributesByColorIndex", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "index", "", "intellij.platform.execution.impl"})
public final class JBTerminalSchemeColorPalette
extends TerminalColorPalette {
    @NotNull
    private final EditorColorsScheme colorsScheme;

    public JBTerminalSchemeColorPalette(@NotNull EditorColorsScheme colorsScheme) {
        Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
        this.colorsScheme = colorsScheme;
    }

    @Override
    @NotNull
    public com.jediterm.core.Color getDefaultForeground() {
        Color foregroundColor = this.colorsScheme.getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY).getForegroundColor();
        Color color = foregroundColor;
        if (color == null) {
            Color color2 = this.colorsScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        com.jediterm.core.Color color3 = AwtTransformers.fromAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    @Override
    @NotNull
    public com.jediterm.core.Color getDefaultBackground() {
        Color backgroundColor = this.colorsScheme.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
        Color color = backgroundColor;
        if (color == null) {
            Color color2 = this.colorsScheme.getDefaultBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        }
        com.jediterm.core.Color color3 = AwtTransformers.fromAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    @Override
    @NotNull
    protected TextAttributes getAttributesByColorIndex(int index) {
        TextAttributesKey key = ColoredOutputTypeRegistryImpl.getAnsiColorKey((int)index);
        TextAttributes textAttributes = this.colorsScheme.getAttributes(key);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"getAttributes(...)");
        return textAttributes;
    }
}

