/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.MatchingPathsCollector;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"collectLogPaths", "", "", "pathPattern", "includeAll", "", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nLogFilesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFilesCollector.kt\ncom/intellij/diagnostic/logging/LogFilesCollectorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1634#2,3:95\n1999#2,14:98\n*S KotlinDebug\n*F\n+ 1 LogFilesCollector.kt\ncom/intellij/diagnostic/logging/LogFilesCollectorKt\n*L\n54#1:95,3\n57#1:98,14\n*E\n"})
public final class LogFilesCollectorKt {
    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static final Set<String> collectLogPaths(@Nullable String pathPattern, boolean includeAll) {
        Object v1;
        File root;
        if (pathPattern == null) {
            return SetsKt.emptySet();
        }
        File logFile = new File(pathPattern);
        if (logFile.exists()) {
            return SetsKt.setOf((Object)pathPattern);
        }
        int depth = 0;
        Object patternString = logFile.getName();
        for (root = logFile.getParentFile(); root != null && !root.exists() && depth < 5; root = root.getParentFile(), ++depth) {
            patternString = root.getName() + "/" + (String)patternString;
        }
        if (root == null || !root.exists()) {
            return SetsKt.emptySet();
        }
        Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)patternString));
        ArrayList<Path> matchingPaths = new ArrayList<Path>();
        Path path = root.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Intrinsics.checkNotNull((Object)pattern);
        PathsKt.visitFileTree$default((Path)path, (FileVisitor)new MatchingPathsCollector(pattern, matchingPaths), (int)0, (boolean)false, (int)6, null);
        if (matchingPaths.isEmpty()) {
            return SetsKt.emptySet();
        }
        if (includeAll) {
            void $this$mapTo$iv;
            Iterable iterable = matchingPaths;
            Collection destination$iv = new LinkedHashSet(matchingPaths.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Path path2 = (Path)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            return (Set)destination$iv;
        }
        Iterable $this$maxByOrNull$iv = matchingPaths;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                Path it = (Path)maxElem$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                Comparable maxValue$iv = fileTime;
                do {
                    Object e$iv = iterator$iv.next();
                    Path it2 = (Path)e$iv;
                    $i$a$-maxByOrNull-LogFilesCollectorKt$collectLogPaths$2 = false;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    FileTime fileTime2 = Files.getLastModifiedTime(it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                    Comparable v$iv = fileTime2;
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Path path3 = v1;
        return SetsKt.setOfNotNull((Object)(path3 != null ? ((Object)path3).toString() : null));
    }
}

