/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/diagnostic/logging/MatchingPathsCollector;", "Ljava/nio/file/FileVisitor;", "Ljava/nio/file/Path;", "pattern", "Ljava/util/regex/Pattern;", "result", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "<init>", "(Ljava/util/regex/Pattern;Ljava/util/ArrayList;)V", "relativePath", "", "getRelativePath", "()Ljava/lang/String;", "setRelativePath", "(Ljava/lang/String;)V", "initialDir", "", "getInitialDir", "()Z", "setInitialDir", "(Z)V", "preVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFile", "file", "visitFileFailed", "exc", "Ljava/io/IOException;", "postVisitDirectory", "intellij.platform.execution.impl"})
final class MatchingPathsCollector
implements FileVisitor<Path> {
    @NotNull
    private final Pattern pattern;
    @NotNull
    private final ArrayList<Path> result;
    @NotNull
    private String relativePath;
    private boolean initialDir;

    public MatchingPathsCollector(@NotNull Pattern pattern, @NotNull ArrayList<Path> result2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        this.pattern = pattern;
        this.result = result2;
        this.relativePath = "";
        this.initialDir = true;
    }

    @NotNull
    public final String getRelativePath() {
        return this.relativePath;
    }

    public final void setRelativePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.relativePath = string;
    }

    public final boolean getInitialDir() {
        return this.initialDir;
    }

    public final void setInitialDir(boolean bl) {
        this.initialDir = bl;
    }

    @Override
    @NotNull
    public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        if (!this.initialDir) {
            this.relativePath = this.relativePath + PathsKt.getName((Path)dir) + "/";
        } else {
            this.initialDir = false;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        if (this.pattern.matcher(this.relativePath + PathsKt.getName((Path)file)).matches()) {
            this.result.add(file);
            if (this.result.size() > 100) {
                return FileVisitResult.TERMINATE;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult visitFileFailed(@NotNull Path file, @Nullable IOException exc) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.relativePath = StringsKt.removeSuffix((String)this.relativePath, (CharSequence)(PathsKt.getName((Path)dir) + "/"));
        return FileVisitResult.CONTINUE;
    }
}

