/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.actions.ExecutorGroupActionGroup;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.actions.RunNewConfigurationContextAction;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.runToolbar.ExecutorRunToolbarAction;
import com.intellij.execution.runToolbar.RunToolbarAdditionActionsHolder;
import com.intellij.execution.runToolbar.RunToolbarExecutorGroup;
import com.intellij.execution.runToolbar.RunToolbarExecutorGroupAction;
import com.intellij.execution.runToolbar.RunToolbarGroupProcessAction;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarProcessAction;
import com.intellij.execution.runToolbar.RunToolbarProcessMainAction;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.SplitButtonAction;
import com.intellij.openapi.actionSystem.ex.ActionRuntimeRegistrar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001az\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0010j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a,\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a\u0015\u0010\u0016\u001a\u00070\n\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a<\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a4\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a4\u0010 \u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010!\u001a\u00020\"H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "initExecutorActions", "", "executor", "Lcom/intellij/execution/Executor;", "actionRegistrar", "Lcom/intellij/openapi/actionSystem/ex/ActionRuntimeRegistrar;", "contextActionIdToAction", "", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "contextActionIdSet", "", "idToAction", "runWidgetIdToAction", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "toolbarSettings", "Lcom/intellij/ide/ui/ToolbarSettings;", "initRunToolbarExecutorActions", "RUN_CONTEXT_EXECUTORS_GROUP", "newConfigurationContextActionId", "Lorg/jetbrains/annotations/NonNls;", "isExecutorInMainGroup", "", "registerActionInGroup", "actionId", "anAction", "groupId", "map", "registerAction", "unregisterAction", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nExecutorRegistryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutorRegistryImpl.kt\ncom/intellij/execution/ExecutorRegistryImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,527:1\n13#2:528\n*S KotlinDebug\n*F\n+ 1 ExecutorRegistryImpl.kt\ncom/intellij/execution/ExecutorRegistryImplKt\n*L\n43#1:528\n*E\n"})
public final class ExecutorRegistryImplKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RUN_CONTEXT_EXECUTORS_GROUP = "RunContextExecutorsGroup";

    private static final void initExecutorActions(Executor executor, ActionRuntimeRegistrar actionRegistrar, Map<String, AnAction> contextActionIdToAction, Set<String> contextActionIdSet, Map<String, AnAction> idToAction, HashMap<String, AnAction> runWidgetIdToAction, ToolbarSettings toolbarSettings) {
        if (contextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        AnAction toolbarAction = null;
        AnAction runContextAction = null;
        AnAction runNonExistingContextAction = null;
        if (executor instanceof ExecutorGroup) {
            String delegateId = executor.getId() + "_delegate";
            ExecutorGroupActionGroup actionGroup = new ExecutorGroupActionGroup((ExecutorGroup)executor, arg_0 -> ExecutorRegistryImplKt.initExecutorActions$lambda$1(ExecutorRegistryImplKt::initExecutorActions$lambda$0, arg_0));
            ExecutorRegistryImplKt.registerAction(actionRegistrar, delegateId, (AnAction)actionGroup, idToAction);
            SplitButtonAction toolbarActionGroup = new SplitButtonAction((ActionGroup)actionGroup);
            Presentation presentation = toolbarActionGroup.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
            Presentation presentation2 = presentation;
            presentation2.setIconSupplier(() -> ExecutorRegistryImplKt.initExecutorActions$lambda$2(executor));
            presentation2.setText(executor.getStartActionText());
            presentation2.setDescription(executor.getDescription());
            toolbarAction = (AnAction)toolbarActionGroup;
            runContextAction = (AnAction)new ExecutorGroupActionGroup((ExecutorGroup)executor, arg_0 -> ExecutorRegistryImplKt.initExecutorActions$lambda$4(ExecutorRegistryImplKt::initExecutorActions$lambda$3, arg_0));
            runNonExistingContextAction = (AnAction)new ExecutorGroupActionGroup((ExecutorGroup)executor, arg_0 -> ExecutorRegistryImplKt.initExecutorActions$lambda$6(ExecutorRegistryImplKt::initExecutorActions$lambda$5, arg_0));
        } else {
            toolbarAction = new ExecutorRegistryImpl.ExecutorAction(executor);
            runContextAction = (AnAction)new RunContextAction(executor);
            runNonExistingContextAction = (AnAction)new RunNewConfigurationContextAction(executor);
        }
        String string = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ExecutorRegistryImplKt.registerActionInGroup(actionRegistrar, string, toolbarAction, "RunnerActions", idToAction);
        String string2 = executor.getContextActionId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getContextActionId(...)");
        AnAction action = ExecutorRegistryImplKt.registerAction(actionRegistrar, string2, runContextAction, contextActionIdToAction);
        if (ExecutorRegistryImplKt.isExecutorInMainGroup(executor)) {
            AnAction anAction = actionRegistrar.getActionOrStub(RUN_CONTEXT_EXECUTORS_GROUP);
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            group = (DefaultActionGroup)anAction;
            AnAction anAction2 = (AnAction)group;
            Constraints constraints = Constraints.LAST;
            Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"LAST");
            actionRegistrar.addToGroup(anAction2, action, constraints);
        } else {
            AnAction anAction = actionRegistrar.getActionOrStub("RunContextGroupMore");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            group = (DefaultActionGroup)anAction;
            actionRegistrar.addToGroup((AnAction)group, action, new Constraints(Anchor.BEFORE, "CreateRunConfiguration"));
        }
        AnAction nonExistingAction = ExecutorRegistryImplKt.registerAction(actionRegistrar, ExecutorRegistryImplKt.newConfigurationContextActionId(executor), runNonExistingContextAction, contextActionIdToAction);
        AnAction anAction = actionRegistrar.getActionOrStub("RunContextGroupMore");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        DefaultActionGroup group2 = (DefaultActionGroup)anAction;
        actionRegistrar.addToGroup((AnAction)group2, nonExistingAction, new Constraints(Anchor.BEFORE, "CreateNewRunConfiguration"));
        if (toolbarSettings.isAvailable()) {
            ExecutorRegistryImplKt.initRunToolbarExecutorActions(executor, actionRegistrar, (Map<String, AnAction>)runWidgetIdToAction);
        }
        String string3 = executor.getContextActionId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getContextActionId(...)");
        contextActionIdSet.add(string3);
    }

    private static final void initRunToolbarExecutorActions(Executor executor, ActionRuntimeRegistrar actionRegistrar, Map<String, AnAction> runWidgetIdToAction) {
        String string = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        for (RunToolbarProcess process2 : RunToolbarProcess.Companion.getProcessesByExecutorId(string)) {
            ExecutorRunToolbarAction wrappedAction;
            if (executor instanceof ExecutorGroup) {
                if (process2.getShowInBar()) {
                    Presentation presentation;
                    wrappedAction = new RunToolbarExecutorGroupAction(new RunToolbarExecutorGroup((ExecutorGroup)executor, arg_0 -> ExecutorRegistryImplKt.initRunToolbarExecutorActions$lambda$1(arg_0 -> ExecutorRegistryImplKt.initRunToolbarExecutorActions$lambda$0(process2, arg_0), arg_0), process2));
                    Intrinsics.checkNotNullExpressionValue((Object)wrappedAction.getTemplatePresentation(), (String)"getTemplatePresentation(...)");
                    presentation.setIcon(executor.getIcon());
                    presentation.setText(process2.getName());
                    presentation.setDescription(executor.getDescription());
                    ExecutorRegistryImplKt.registerActionInGroup(actionRegistrar, process2.getActionId(), wrappedAction, "RunToolbarProcessActionGroup", runWidgetIdToAction);
                    continue;
                }
                RunToolbarAdditionActionsHolder holder = new RunToolbarAdditionActionsHolder((ExecutorGroup)executor, process2);
                ExecutorRegistryImplKt.registerActionInGroup(actionRegistrar, RunToolbarAdditionActionsHolder.Companion.getAdditionActionId(process2), holder.getAdditionAction(), process2.getMoreActionSubGroupName(), runWidgetIdToAction);
                ExecutorRegistryImplKt.registerActionInGroup(actionRegistrar, RunToolbarAdditionActionsHolder.Companion.getAdditionActionChooserGroupId(process2), (AnAction)holder.getMoreActionChooserGroup(), process2.getMoreActionSubGroupName(), runWidgetIdToAction);
                continue;
            }
            if (process2.isTemporaryProcess() || !process2.getShowInBar()) continue;
            wrappedAction = new RunToolbarProcessAction(process2, executor);
            RunToolbarProcessMainAction wrappedMainAction = new RunToolbarProcessMainAction(process2, executor);
            ExecutorRegistryImplKt.registerActionInGroup(actionRegistrar, process2.getActionId(), wrappedAction, "RunToolbarProcessActionGroup", runWidgetIdToAction);
            ExecutorRegistryImplKt.registerActionInGroup(actionRegistrar, process2.getMainActionId(), wrappedMainAction, "RunToolbarProcessMainActionGroup", runWidgetIdToAction);
        }
    }

    private static final String newConfigurationContextActionId(Executor executor) {
        return "newConfiguration" + executor.getContextActionId();
    }

    private static final boolean isExecutorInMainGroup(Executor executor) {
        String string = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String id = string;
        return Intrinsics.areEqual((Object)id, (Object)"Run") || Intrinsics.areEqual((Object)id, (Object)"Debug") || !Registry.Companion.is("executor.actions.submenu", true);
    }

    private static final void registerActionInGroup(ActionRuntimeRegistrar actionRegistrar, String actionId, AnAction anAction, String groupId, Map<String, AnAction> map) {
        AnAction action = ExecutorRegistryImplKt.registerAction(actionRegistrar, actionId, anAction, map);
        AnAction group2 = actionRegistrar.getActionOrStub(groupId);
        if (group2 != null) {
            Constraints constraints = Constraints.LAST;
            Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"LAST");
            actionRegistrar.addToGroup(group2, action, constraints);
        }
    }

    private static final AnAction registerAction(ActionRuntimeRegistrar actionRegistrar, String actionId, AnAction anAction, Map<String, AnAction> idToAction) {
        AnAction action = actionRegistrar.getActionOrStub(actionId);
        if (action == null) {
            actionRegistrar.registerAction(actionId, anAction);
            idToAction.put(actionId, anAction);
            action = anAction;
        }
        return action;
    }

    private static final void unregisterAction(String actionId, String groupId, Map<String, AnAction> map, ActionManager actionManager) {
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)actionManager.getAction(groupId);
        if (defaultActionGroup == null) {
            return;
        }
        DefaultActionGroup group2 = defaultActionGroup;
        AnAction action = map.get(actionId);
        if (action == null) {
            action = actionManager.getAction(actionId);
            if (action != null) {
                group2.remove(action, actionManager);
            }
        } else {
            actionManager.unregisterAction(actionId);
            map.remove(actionId);
        }
    }

    private static final AnAction initExecutorActions$lambda$0(Executor it) {
        Intrinsics.checkNotNull((Object)it);
        return new ExecutorRegistryImpl.ExecutorAction(it);
    }

    private static final AnAction initExecutorActions$lambda$1(Function1 $tmp0, Object p0) {
        return (AnAction)$tmp0.invoke(p0);
    }

    private static final Icon initExecutorActions$lambda$2(Executor $executor) {
        return $executor.getIcon();
    }

    private static final AnAction initExecutorActions$lambda$3(Executor it) {
        return (AnAction)new RunContextAction(it);
    }

    private static final AnAction initExecutorActions$lambda$4(Function1 $tmp0, Object p0) {
        return (AnAction)$tmp0.invoke(p0);
    }

    private static final AnAction initExecutorActions$lambda$5(Executor it) {
        return (AnAction)new RunNewConfigurationContextAction(it);
    }

    private static final AnAction initExecutorActions$lambda$6(Function1 $tmp0, Object p0) {
        return (AnAction)$tmp0.invoke(p0);
    }

    private static final AnAction initRunToolbarExecutorActions$lambda$0(RunToolbarProcess $process, Executor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RunToolbarGroupProcessAction($process, it);
    }

    private static final AnAction initRunToolbarExecutorActions$lambda$1(Function1 $tmp0, Object p0) {
        return (AnAction)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$initExecutorActions(Executor executor, ActionRuntimeRegistrar actionRegistrar, Map contextActionIdToAction, Set contextActionIdSet, Map idToAction, HashMap runWidgetIdToAction, ToolbarSettings toolbarSettings) {
        ExecutorRegistryImplKt.initExecutorActions(executor, actionRegistrar, contextActionIdToAction, contextActionIdSet, idToAction, runWidgetIdToAction, toolbarSettings);
    }

    public static final /* synthetic */ void access$unregisterAction(String actionId, String groupId, Map map, ActionManager actionManager) {
        ExecutorRegistryImplKt.unregisterAction(actionId, groupId, map, actionManager);
    }

    public static final /* synthetic */ boolean access$isExecutorInMainGroup(Executor executor) {
        return ExecutorRegistryImplKt.isExecutorInMainGroup(executor);
    }

    public static final /* synthetic */ String access$newConfigurationContextActionId(Executor executor) {
        return ExecutorRegistryImplKt.newConfigurationContextActionId(executor);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExecutorRegistryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

