/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import java.awt.event.ActionEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/actions/ActivateRunToolWindowAction;", "Lcom/intellij/ide/actions/ToolWindowEmptyStateAction;", "<init>", "()V", "ensureToolWindowCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "setupEmptyText", "text", "Lcom/intellij/util/ui/StatusText;", "Manager", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class ActivateRunToolWindowAction
extends ToolWindowEmptyStateAction {
    public ActivateRunToolWindowAction() {
        super("Run", AllIcons.Toolwindows.ToolWindowRun);
    }

    protected void ensureToolWindowCreated(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)runContentManager, (String)"null cannot be cast to non-null type com.intellij.execution.ui.RunContentManagerImpl");
        RunContentManagerImpl runContentManager2 = (RunContentManagerImpl)runContentManager;
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getRunExecutorInstance(...)");
        runContentManager2.registerToolWindow(executor);
    }

    protected void setupEmptyText(@NotNull Project project, @NotNull StatusText text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        text.setCenterAlignText(false);
        text.appendLine(LangBundle.message((String)"run.toolwindow.empty.text.0", (Object[])new Object[0]));
        text.appendLine(LangBundle.message((String)"run.toolwindow.empty.text.1", (Object[])new Object[0]));
        text.appendLine(LangBundle.message((String)"run.toolwindow.empty.text.2", (Object[])new Object[0]));
        Manager.INSTANCE.appendLaunchConfigurationText(text, project, "ChooseRunConfiguration");
        text.appendLine("");
        text.appendLine(AllIcons.General.ContextHelp, LangBundle.message((String)"run.toolwindow.empty.text.help", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, ActivateRunToolWindowAction::setupEmptyText$lambda$0);
    }

    private static final void setupEmptyText$lambda$0(ActionEvent it) {
        HelpManager.getInstance().invokeHelp("procedures.running.run");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/actions/ActivateRunToolWindowAction$Manager;", "", "<init>", "()V", "appendLaunchConfigurationText", "", "text", "Lcom/intellij/util/ui/StatusText;", "project", "Lcom/intellij/openapi/project/Project;", "actionId", "", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nActivateRunToolWindowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivateRunToolWindowAction.kt\ncom/intellij/execution/actions/ActivateRunToolWindowAction$Manager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        public final void appendLaunchConfigurationText(@NotNull StatusText text, @NotNull Project project, @NotNull String actionId) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
                    KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId);
                    object = shortcut;
                    if (object == null) break block2;
                    KeyboardShortcut it = object;
                    boolean bl = false;
                    String string = " (" + KeymapUtil.getShortcutText((Shortcut)((Shortcut)shortcut)) + ")";
                    object = string;
                    if (string != null) break block3;
                }
                object = "";
            }
            Object shortcutText = object;
            Object[] objectArray = new Object[]{shortcutText};
            String string = LangBundle.message((String)"run.toolwindow.empty.text.3", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String line = string;
            text.appendLine(StringsKt.substringBefore$default((String)line, (char)'<', null, (int)2, null));
            text.appendText(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)line, (char)'<', null, (int)2, null), (char)'>', null, (int)2, null), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> Manager.appendLaunchConfigurationText$lambda$1(project, arg_0));
            text.appendText(StringsKt.substringAfter$default((String)line, (char)'>', null, (int)2, null));
        }

        private static final void appendLaunchConfigurationText$lambda$1(Project $project, ActionEvent it) {
            new EditConfigurationsDialog($project).show();
        }
    }
}

