/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup
implements ActionRemoteBehaviorSpecification.BackendOnly,
DumbAware {
    protected static final Logger LOG = Logger.getInstance(BaseRunConfigurationAction.class);

    protected BaseRunConfigurationAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, Icon icon) {
        if (text == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(1);
        }
        super(text, description, icon);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    protected BaseRunConfigurationAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon) {
        if (text == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(2);
        }
        if (description == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(3);
        }
        super(text, description, icon);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = e != null ? this.getChildren(e.getDataContext(), e.getPlace()) : EMPTY_ARRAY;
        if (anActionArray == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    private AnAction @NotNull [] getChildren(@NotNull DataContext dataContext, @Nullable String place) {
        if (dataContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(6);
        }
        if (dataContext.getData(ExecutorAction.getOrderKey()) != null) {
            if (EMPTY_ARRAY == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(7);
            }
            return EMPTY_ARRAY;
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext, (String)place);
        if (!Registry.is((String)"suggest.all.run.configurations.from.context") && this.findExisting(context) != null) {
            if (EMPTY_ARRAY == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(8);
            }
            return EMPTY_ARRAY;
        }
        AnAction[] anActionArray = this.createChildActions(context, this.getConfigurationsFromContext(context)).toArray(EMPTY_ARRAY);
        if (anActionArray == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(9);
        }
        return anActionArray;
    }

    @Nullable
    protected RunnerAndConfigurationSettings findExisting(@NotNull ConfigurationContext context) {
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(10);
        }
        return context.findExisting();
    }

    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(11);
        }
        if (configurations == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(12);
        }
        if (configurations.size() <= 1) {
            List<AnAction> list = Collections.emptyList();
            if (list == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>();
        for (final ConfigurationFromContext configurationFromContext : configurations) {
            ConfigurationType configurationType = configurationFromContext.getConfigurationType();
            String actionName = BaseRunConfigurationAction.childActionName(configurationFromContext);
            AnAction anAction = new AnAction(actionName, configurationType.getDisplayName(), configurationFromContext.getConfiguration().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BaseRunConfigurationAction.this.perform(configurationFromContext, ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/BaseRunConfigurationAction$1", "actionPerformed"));
                }
            };
            anAction.getTemplatePresentation().setText(actionName, false);
            childActions.add(anAction);
        }
        ArrayList<AnAction> arrayList = childActions;
        if (arrayList == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private List<ConfigurationFromContext> getConfigurationsFromContext(@NotNull ConfigurationContext context) {
        List fromContext;
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(15);
        }
        if ((fromContext = context.getConfigurationsFromContext()) == null) {
            List<ConfigurationFromContext> list = Collections.emptyList();
            if (list == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(16);
            }
            return list;
        }
        ArrayList<ConfigurationFromContext> enabledConfigurations = new ArrayList<ConfigurationFromContext>();
        for (ConfigurationFromContext configurationFromContext : fromContext) {
            if (!this.isEnabledFor(configurationFromContext.getConfiguration(), context)) continue;
            enabledConfigurations.add(configurationFromContext);
        }
        ArrayList<ConfigurationFromContext> arrayList = enabledConfigurations;
        if (arrayList == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    protected boolean isEnabledFor(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(18);
        }
        return true;
    }

    protected boolean isEnabledFor(@NotNull RunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(19);
        }
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(20);
        }
        return this.isEnabledFor(configuration);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        ConfigurationContext context;
        RunnerAndConfigurationSettings existing;
        if (e == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(21);
        }
        if ((existing = this.findExisting(context = ConfigurationContext.getFromContext((DataContext)(dataContext = e.getDataContext()), (String)e.getPlace()))) == null || dataContext.getData(ExecutorAction.getOrderKey()) != null) {
            List<ConfigurationFromContext> producers = this.getConfigurationsFromContext(context);
            if (producers.isEmpty()) {
                return;
            }
            ConfigurationFromContext configuration = BaseRunConfigurationAction.getOrderedConfiguration(dataContext, producers);
            if (ActionUtil.isDumbMode((Project)context.getProject()) && !configuration.getConfiguration().getType().isDumbAware()) {
                ActionUtil.showDumbModeWarning((Project)context.getProject(), (AnAction)this, (AnActionEvent[])new AnActionEvent[]{e});
            } else {
                this.perform(configuration, context);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                String configurationClass = existing.getConfiguration().getClass().getName();
                LOG.debug(String.format("Use existing run configuration: %s", configurationClass));
            }
            Project project = Objects.requireNonNull(context.getProject());
            if (ActionUtil.isDumbMode((Project)context.getProject()) && !existing.getType().isDumbAware()) {
                ActionUtil.showDumbModeWarning((Project)project, (AnAction)this, (AnActionEvent[])new AnActionEvent[]{e});
            } else {
                this.perform(existing, context);
            }
        }
    }

    @NotNull
    private static ConfigurationFromContext getOrderedConfiguration(@NotNull DataContext dataContext, @NotNull List<? extends ConfigurationFromContext> producers) {
        Integer order;
        if (dataContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(22);
        }
        if (producers == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(23);
        }
        if ((order = (Integer)dataContext.getData(ExecutorAction.getOrderKey())) != null && order < producers.size()) {
            ConfigurationFromContext configurationFromContext = producers.get(order);
            if (configurationFromContext == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(24);
            }
            return configurationFromContext;
        }
        ConfigurationFromContext configurationFromContext = producers.get(0);
        if (configurationFromContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(25);
        }
        return configurationFromContext;
    }

    private void perform(@NotNull ConfigurationFromContext configurationFromContext, @NotNull ConfigurationContext context) {
        if (configurationFromContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(26);
        }
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(27);
        }
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        RunnerAndConfigurationSettings configurationSettings = configurationFromContext.getConfigurationSettings();
        context.setConfiguration(configurationSettings);
        configurationFromContext.onFirstRun(context, () -> {
            if (LOG.isDebugEnabled()) {
                RunnerAndConfigurationSettings settings = context.getConfiguration();
                RunConfiguration configuration = settings == null ? null : settings.getConfiguration();
                String configurationClass = configuration == null ? null : configuration.getClass().getName();
                LOG.debug(String.format("Create run configuration: %s", configurationClass));
            }
            if (!Utils.isAsyncDataContext((DataContext)context.getDataContext()) && eventCount != IdeEventQueue.getInstance().getEventCount()) {
                IdeEventQueue.getInstance().setEventCount(eventCount);
            }
            this.perform(configurationSettings, context);
        });
    }

    protected void perform(@NotNull RunnerAndConfigurationSettings configurationSettings, @NotNull ConfigurationContext context) {
        if (configurationSettings == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(28);
        }
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(29);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(30);
        }
        DataContext dataContext = event.getDataContext();
        ConfigurationContext context = ConfigurationContext.getFromEvent((AnActionEvent)event);
        Presentation presentation = event.getPresentation();
        RunnerAndConfigurationSettings existing = this.findExisting(context);
        RunnerAndConfigurationSettings configuration = existing;
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        if (configuration == null || ActionUtil.isDumbMode((Project)context.getProject()) && !configuration.getType().isDumbAware()) {
            presentation.setEnabledAndVisible(false);
            presentation.setPerformGroup(false);
        } else {
            presentation.setEnabledAndVisible(true);
            VirtualFile vFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
            if (vFile != null) {
                RunLineMarkerProvider.markRunnable(vFile, true);
            }
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            if (existing == null && fromContext.isEmpty()) {
                presentation.setEnabledAndVisible(false);
                presentation.setPerformGroup(false);
                return;
            }
            if (!(existing != null && dataContext.getData(ExecutorAction.getOrderKey()) == null || fromContext.isEmpty())) {
                ConfigurationFromContext configurationFromContext = BaseRunConfigurationAction.getOrderedConfiguration(dataContext, fromContext);
                configuration = configurationFromContext.getConfigurationSettings();
                context.setConfiguration(configurationFromContext.getConfigurationSettings());
            }
            String name = BaseRunConfigurationAction.suggestRunActionName(configuration.getConfiguration());
            boolean performGroup = existing != null || fromContext.size() <= 1 || dataContext.getData(ExecutorAction.getOrderKey()) != null;
            this.updatePresentation(presentation, performGroup ? name : "", context);
            presentation.setPerformGroup(performGroup);
        }
    }

    @NotNull
    @Nls
    public static String suggestRunActionName(@NotNull RunConfiguration configuration) {
        String actionName;
        if (configuration == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(31);
        }
        if (configuration instanceof LocatableConfigurationBase && ((LocatableConfigurationBase)configuration).isGeneratedName() && (actionName = ((LocatableConfigurationBase)configuration).getActionName()) != null) {
            String string = actionName;
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = ProgramRunnerUtil.shortenName(configuration.getName(), 0);
        if (string == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String suggestRunActionName(@NotNull LocatableConfiguration configuration) {
        if (configuration == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(34);
        }
        return BaseRunConfigurationAction.suggestRunActionName((RunConfiguration)configuration);
    }

    @NotNull
    @Nls
    private static String childActionName(@NotNull ConfigurationFromContext configurationFromContext) {
        String locationDisplayName;
        RunConfiguration configuration;
        if (configurationFromContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(35);
        }
        if (!((configuration = configurationFromContext.getConfiguration()) instanceof LocatableConfiguration)) {
            String string = configurationFromContext.getConfigurationType().getDisplayName();
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (configurationFromContext.isFromAlternativeLocation() && (locationDisplayName = configurationFromContext.getAlternativeLocationDisplayName()) != null) {
            String string = ((LocatableConfigurationBase)configuration).getActionName() + " " + locationDisplayName;
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName(configurationFromContext.getConfiguration()));
        if (string == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(38);
        }
        return string;
    }

    protected abstract void updatePresentation(@NotNull Presentation var1, @NotNull String var2, ConfigurationContext var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9, 13, 14, 16, 17, 24, 25, 32, 33, 36, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/BaseRunConfigurationAction";
                break;
            }
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 20: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 18: 
            case 19: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFromContext";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/BaseRunConfigurationAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildActions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsFromContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedConfiguration";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRunActionName";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "childActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findExisting";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChildActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsFromContext";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedConfiguration";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "suggestRunActionName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "childActionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9, 13, 14, 16, 17, 24, 25, 32, 33, 36, 37, 38 -> new IllegalStateException(string);
        };
    }
}

