/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ChooseRunConfigurationManager {
    @NotNull
    public static List<ChooseRunConfigurationPopup.ItemWrapper<?>> createSettingsList(@NotNull Project project, @NotNull ExecutorProvider executorProvider, @NotNull DataContext dataContext, boolean isCreateEditAction) {
        RunManager runManager;
        if (project == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(0);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(2);
        }
        if ((runManager = RunManager.getInstanceIfCreated((Project)project)) == null) {
            List<ChooseRunConfigurationPopup.ItemWrapper<?>> list = Collections.emptyList();
            if (list == null) {
                ChooseRunConfigurationManager.$$$reportNull$$$0(3);
            }
            return list;
        }
        return ChooseRunConfigurationManager.createSettingsList((RunManagerImpl)runManager, executorProvider, isCreateEditAction, Registry.is((String)"run.popup.move.folders.to.top", (boolean)false), dataContext);
    }

    public static List<ChooseRunConfigurationPopup.ItemWrapper<?>> createFlatSettingsList(@NotNull Project project) {
        if (project == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(4);
        }
        return RunManagerImplKt.createFlatSettingsList(project);
    }

    @TestOnly
    @NotNull
    public static List<ChooseRunConfigurationPopup.ItemWrapper<?>> createSettingsList(@NotNull RunManagerImpl runManager, @NotNull ExecutorProvider executorProvider, boolean isCreateEditAction, boolean isMoveFoldersToTop, @NotNull DataContext dataContext) {
        if (runManager == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(5);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(7);
        }
        ArrayList result2 = new ArrayList();
        if (isCreateEditAction) {
            result2.add(ChooseRunConfigurationManager.createEditAction());
        }
        Project project = runManager.getProject();
        RunnerAndConfigurationSettings selectedConfiguration = runManager.getSelectedConfiguration();
        if (selectedConfiguration != null) {
            ChooseRunConfigurationManager.addActionsForSelected(selectedConfiguration, project, result2);
        }
        LinkedHashMap wrappedExisting = new LinkedHashMap();
        SmartList folderWrappers = new SmartList();
        for (Map<String, List<RunnerAndConfigurationSettings>> folderToConfigurations : runManager.getConfigurationsGroupedByTypeAndFolder(false).values()) {
            String folderName;
            if (isMoveFoldersToTop) {
                for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : folderToConfigurations.entrySet()) {
                    folderName = entry.getKey();
                    List<RunnerAndConfigurationSettings> configurations = entry.getValue();
                    if (folderName != null) {
                        folderWrappers.add(ChooseRunConfigurationManager.createFolderItem(project, executorProvider, selectedConfiguration, folderName, configurations));
                        continue;
                    }
                    for (RunnerAndConfigurationSettings configuration : configurations) {
                        ChooseRunConfigurationManager.wrapAndAdd(project, configuration, selectedConfiguration, wrappedExisting);
                    }
                }
                continue;
            }
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : folderToConfigurations.entrySet()) {
                folderName = entry.getKey();
                if (folderName == null) continue;
                result2.add(ChooseRunConfigurationManager.createFolderItem(project, executorProvider, selectedConfiguration, folderName, entry.getValue()));
            }
            List<RunnerAndConfigurationSettings> configurations = folderToConfigurations.get(null);
            if (ContainerUtil.isEmpty(configurations)) continue;
            for (RunnerAndConfigurationSettings configuration : configurations) {
                result2.add(ChooseRunConfigurationManager.wrapAndAdd(project, configuration, selectedConfiguration, wrappedExisting));
            }
        }
        if (isMoveFoldersToTop) {
            result2.addAll((Collection<ChooseRunConfigurationPopup.ItemWrapper<?>>)folderWrappers);
        }
        if (!DumbService.isDumb((Project)project)) {
            ChooseRunConfigurationManager.populateWithDynamicRunners(result2, wrappedExisting, project, RunManagerEx.getInstanceEx(project), selectedConfiguration, dataContext);
        }
        if (isMoveFoldersToTop) {
            result2.addAll(wrappedExisting.values());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void deleteConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable JBPopup popupToCancel) {
        boolean confirmed;
        RunManagerConfig runManagerConfig;
        if (project == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(9);
        }
        if (configurationSettings == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(10);
        }
        if ((runManagerConfig = RunManagerImpl.getInstanceImpl(project).getConfig()).isDeletionFromPopupRequiresConfirmation()) {
            if (popupToCancel != null) {
                popupToCancel.cancel();
            }
            confirmed = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)CommonBundle.message((String)"title.confirmation", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"are.you.sure.you.want.to.delete.0", (Object[])new Object[]{configurationSettings.getName()})).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    runManagerConfig.setDeletionFromPopupRequiresConfirmation(!isSelected);
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = ExecutionBundle.message((String)"don.t.ask.again", (Object[])new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationManager$1", "getDoNotShowMessage"));
                }
            })).ask(project);
        } else {
            confirmed = true;
        }
        if (confirmed) {
            RunManager.getInstance((Project)project).removeConfiguration(configurationSettings);
        }
    }

    @NotNull
    private static ChooseRunConfigurationPopup.ItemWrapper<?> wrapAndAdd(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration, @Nullable RunnerAndConfigurationSettings selectedConfiguration, @NotNull Map<RunnerAndConfigurationSettings, ChooseRunConfigurationPopup.ItemWrapper<?>> wrappedExisting) {
        if (project == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(12);
        }
        if (wrappedExisting == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(13);
        }
        ChooseRunConfigurationPopup.ItemWrapper<?> wrapped = ChooseRunConfigurationPopup.ItemWrapper.wrap(project, configuration);
        if (configuration == selectedConfiguration) {
            wrapped.setMnemonic(1);
        }
        wrappedExisting.put(configuration, wrapped);
        ChooseRunConfigurationPopup.ItemWrapper<?> itemWrapper = wrapped;
        if (itemWrapper == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(14);
        }
        return itemWrapper;
    }

    @NotNull
    private static FolderWrapper createFolderItem(@NotNull Project project, @NotNull ExecutorProvider executorProvider, @Nullable RunnerAndConfigurationSettings selectedConfiguration, @NotNull String folderName, @NotNull List<? extends RunnerAndConfigurationSettings> configurations) {
        if (project == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(15);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(16);
        }
        if (folderName == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(17);
        }
        if (configurations == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(18);
        }
        boolean isSelected = selectedConfiguration != null && configurations.contains(selectedConfiguration);
        Object value = folderName;
        if (isSelected) {
            value = (String)value + "  (mnemonic is to \"" + selectedConfiguration.getName() + "\")";
        }
        FolderWrapper result2 = new FolderWrapper(project, executorProvider, (String)value, configurations);
        if (isSelected) {
            result2.setMnemonic(1);
        }
        FolderWrapper folderWrapper = result2;
        if (folderWrapper == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(19);
        }
        return folderWrapper;
    }

    private static void addActionsForSelected(final @NotNull RunnerAndConfigurationSettings selectedConfiguration, @NotNull Project project, @NotNull List<ChooseRunConfigurationPopup.ItemWrapper<?>> result2) {
        if (selectedConfiguration == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(22);
        }
        boolean isFirst = true;
        ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)selectedConfiguration.getConfiguration())) {
            ChooseRunConfigurationPopup.ItemWrapper<ExecutionTarget> itemWrapper = new ChooseRunConfigurationPopup.ItemWrapper<ExecutionTarget>(eachTarget, isFirst){

                @Override
                public Icon getIcon() {
                    return Objects.requireNonNull((ExecutionTarget)this.getValue()).getIcon();
                }

                @Override
                public String getText() {
                    return Objects.requireNonNull((ExecutionTarget)this.getValue()).getDisplayName();
                }

                @Override
                public void perform(@NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (executor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    ExecutionTargetManager.setActiveTarget((Project)project, (ExecutionTarget)Objects.requireNonNull((ExecutionTarget)this.getValue()));
                    ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)selectedConfiguration, (Executor)executor, null, null, (DataContext)context);
                }

                @Override
                public boolean available(Executor executor) {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "executor";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager$2";
                    objectArray[2] = "perform";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            itemWrapper.setChecked(eachTarget.equals((Object)activeTarget));
            result2.add(itemWrapper);
            isFirst = false;
        }
    }

    @NotNull
    private static ChooseRunConfigurationPopup.ItemWrapper<Void> createEditAction() {
        ChooseRunConfigurationPopup.ItemWrapper<Void> result2 = new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return AllIcons.Actions.EditSource;
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.editRunConfigurations.text", (Object[])new Object[0]));
            }

            @Override
            public void perform(@NotNull Project project, final @NotNull Executor executor, @NotNull DataContext context) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (executor == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (new EditConfigurationsDialog(this, project){

                    protected void init() {
                        this.setOKButtonText(executor.getActionName());
                        this.myExecutor = executor;
                        super.init();
                    }
                }.showAndGet()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                        if (configuration != null) {
                            ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor, null, null, (DataContext)context);
                        }
                    }, project.getDisposed());
                }
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager$3";
                objectArray[2] = "perform";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        result2.setMnemonic(0);
        ChooseRunConfigurationPopup.ItemWrapper<Void> itemWrapper = result2;
        if (itemWrapper == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(23);
        }
        return itemWrapper;
    }

    private static void populateWithDynamicRunners(List<ChooseRunConfigurationPopup.ItemWrapper<?>> result2, Map<RunnerAndConfigurationSettings, ChooseRunConfigurationPopup.ItemWrapper<?>> existing, final Project project, final RunManager manager, RunnerAndConfigurationSettings selectedConfiguration, @NotNull DataContext dataContext) {
        ConfigurationContext context;
        List producers;
        if (dataContext == null) {
            ChooseRunConfigurationManager.$$$reportNull$$$0(24);
        }
        if ((producers = PreferredProducerFind.getConfigurationsFromContext((Location)(context = ConfigurationContext.getFromContext((DataContext)dataContext, (String)"unknown")).getLocation(), (ConfigurationContext)context, (boolean)false, (boolean)true)) == null) {
            return;
        }
        producers = ContainerUtil.sorted((Collection)producers, (Comparator)ConfigurationFromContext.NAME_COMPARATOR);
        RunnerAndConfigurationSettings[] preferred = new RunnerAndConfigurationSettings[]{null};
        int i = 2;
        for (ConfigurationFromContext fromContext : producers) {
            ChooseRunConfigurationPopup.ItemWrapper<Object> wrapper;
            final RunnerAndConfigurationSettings configuration = fromContext.getConfigurationSettings();
            if (existing.containsKey(configuration)) {
                wrapper = existing.get(configuration);
                if (wrapper.getMnemonic() == 1) continue;
                wrapper.setMnemonic(i);
                ++i;
                continue;
            }
            if (selectedConfiguration != null && configuration.equals((Object)selectedConfiguration)) continue;
            if (preferred[0] == null) {
                preferred[0] = configuration;
            }
            wrapper = new ChooseRunConfigurationPopup.ItemWrapper<Object>((Object)configuration){

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project).getConfigurationIcon(configuration);
                }

                @Override
                public String getText() {
                    return Executor.shortenNameIfNeeded((String)configuration.getName()) + configuration.getConfiguration().getPresentableType();
                }

                @Override
                public boolean available(Executor executor) {
                    return ProgramRunner.getRunner((String)executor.getId(), (RunProfile)configuration.getConfiguration()) != null;
                }

                @Override
                public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (executor == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    manager.setTemporaryConfiguration(configuration);
                    RunManager.getInstance((Project)project2).setSelectedConfiguration(configuration);
                    ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor, null, null, (DataContext)context);
                }

                @Override
                public PopupStep<?> getNextStep(@NotNull Project project2, @NotNull ChooseRunConfigurationPopup action) {
                    if (project2 == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    if (action == null) {
                        4.$$$reportNull$$$0(4);
                    }
                    return new ConfigurationActionsStep(project2, action, configuration, this.isDynamic());
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "action";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "perform";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getNextStep";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            wrapper.setDynamic(true);
            wrapper.setMnemonic(i);
            result2.add(wrapper);
            ++i;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 14, 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorProvider";
                break;
            }
            case 2: 
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedExisting";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedConfiguration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAndAdd";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFolderItem";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsList";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 19: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFlatSettingsList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteConfiguration";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndAdd";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFolderItem";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addActionsForSelected";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "populateWithDynamicRunners";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 14, 19, 23 -> new IllegalStateException(string);
        };
    }

    static final class FolderWrapper
    extends ChooseRunConfigurationPopup.ItemWrapper<String> {
        private final Project myProject;
        private final ExecutorProvider myExecutorProvider;
        final List<? extends RunnerAndConfigurationSettings> myConfigurations;

        private FolderWrapper(Project project, ExecutorProvider executorProvider, @Nullable String value, List<? extends RunnerAndConfigurationSettings> configurations) {
            super(value);
            this.myProject = project;
            this.myExecutorProvider = executorProvider;
            this.myConfigurations = configurations;
        }

        @Override
        public void perform(@NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
            RunManager runManager;
            RunnerAndConfigurationSettings selectedConfiguration;
            if (project == null) {
                FolderWrapper.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                FolderWrapper.$$$reportNull$$$0(1);
            }
            if (context == null) {
                FolderWrapper.$$$reportNull$$$0(2);
            }
            if (this.myConfigurations.contains(selectedConfiguration = (runManager = RunManager.getInstance((Project)project)).getSelectedConfiguration())) {
                runManager.setSelectedConfiguration(selectedConfiguration);
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)Objects.requireNonNull(selectedConfiguration), (Executor)this.myExecutorProvider.getExecutor());
            }
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Nodes.Folder;
            if (icon == null) {
                FolderWrapper.$$$reportNull$$$0(3);
            }
            return icon;
        }

        @Override
        public String getText() {
            return (String)this.getValue();
        }

        @Override
        @Nullable
        public ConfigurationType getType() {
            return Registry.is((String)"run.popup.move.folders.to.top") || this.myConfigurations.isEmpty() ? null : this.myConfigurations.get(0).getType();
        }

        @Override
        public boolean hasActions() {
            return true;
        }

        @Override
        public PopupStep<?> getNextStep(Project project, ChooseRunConfigurationPopup action) {
            ArrayList<ConfigurationActionsStep> steps = new ArrayList<ConfigurationActionsStep>();
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations) {
                steps.add(new ConfigurationActionsStep(project, action, runnerAndConfigurationSettings, false));
            }
            return new FolderStep(this.myProject, this.myExecutorProvider, null, steps, action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationManager$FolderWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager$FolderWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static abstract class ActionWrapper
    extends ChooseRunConfigurationPopup.Wrapper {
        @Nls
        private final String myName;
        private final Icon myIcon;

        ActionWrapper(@Nls String name, Icon icon) {
            this(name, icon, false);
        }

        ActionWrapper(@Nls String name, Icon icon, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myName = name;
            this.myIcon = icon;
        }

        public abstract void perform();

        @Override
        public String getText() {
            return this.myName;
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }
    }

    static final class ConfigurationActionsStep
    extends BaseListPopupStep<ActionWrapper> {
        @NotNull
        private final RunnerAndConfigurationSettings mySettings;
        @NotNull
        private final Project myProject;

        ConfigurationActionsStep(@NotNull Project project, ChooseRunConfigurationPopup action, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            if (project == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(1);
            }
            super(null, (Object[])ConfigurationActionsStep.buildActions(project, action, settings, dynamic));
            this.myProject = project;
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(2);
            }
            return runnerAndConfigurationSettings;
        }

        @NlsContexts.ListItem
        public String getName() {
            return Executor.shortenNameIfNeeded((String)this.mySettings.getName());
        }

        public Icon getIcon() {
            return RunManagerEx.getInstanceEx(this.myProject).getConfigurationIcon(this.mySettings);
        }

        public ListSeparator getSeparatorAbove(ActionWrapper value) {
            return value.addSeparatorAbove() ? new ListSeparator() : null;
        }

        private static ActionWrapper[] buildActions(final @NotNull Project project, final ChooseRunConfigurationPopup action, final @NotNull RunnerAndConfigurationSettings settings, final boolean dynamic) {
            if (project == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(3);
            }
            if (settings == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(4);
            }
            ArrayList<ActionWrapper> result2 = new ArrayList<ActionWrapper>();
            final ExecutionTarget active2 = ExecutionTargetManager.getActiveTarget((Project)project);
            for (final ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)settings.getConfiguration())) {
                result2.add(new ActionWrapper(eachTarget.getDisplayName(), eachTarget.getIcon()){
                    {
                        super(name, icon);
                        this.setChecked(eachTarget.equals((Object)active2));
                    }

                    @Override
                    public void perform() {
                        RunManager manager = RunManager.getInstance((Project)project);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.setSelectedConfiguration(settings);
                        ExecutionTargetManager.setActiveTarget((Project)project, (ExecutionTarget)eachTarget);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)action.getExecutor());
                    }
                });
            }
            boolean isFirst = true;
            ArrayList<Executor> allExecutors = new ArrayList<Executor>();
            for (final Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                if (executor instanceof ExecutorGroup) {
                    allExecutors.addAll(((ExecutorGroup)executor).childExecutors());
                    continue;
                }
                allExecutors.add(executor);
            }
            for (final Executor executor : allExecutors) {
                if (!ExecutorRegistryImpl.RunnerHelper.canRun(project, executor, settings.getConfiguration())) continue;
                result2.add(new ActionWrapper(executor.getActionName(), executor.getIcon(), isFirst){

                    @Override
                    public void perform() {
                        RunManager manager = RunManager.getInstance((Project)project);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        if (!manager.isRiderRunWidgetActive()) {
                            manager.setSelectedConfiguration(settings);
                        }
                        ExecutorRegistryImpl.RunnerHelper.run(project, settings.getConfiguration(), settings, DataContext.EMPTY_CONTEXT, executor);
                    }
                });
                isFirst = false;
            }
            result2.add(new ActionWrapper(ExecutionBundle.message((String)"choose.run.popup.edit", (Object[])new Object[0]), AllIcons.Actions.EditSource, true){

                @Override
                public void perform() {
                    if (dynamic) {
                        RunManager.getInstance((Project)project).setTemporaryConfiguration(settings);
                    }
                    action.editConfiguration(project, settings);
                }
            });
            if (settings.isTemporary() || dynamic) {
                result2.add(new ActionWrapper(ExecutionBundle.message((String)"choose.run.popup.save", (Object[])new Object[0]), AllIcons.Actions.MenuSaveall){

                    @Override
                    public void perform() {
                        RunManager manager = RunManager.getInstance((Project)project);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.makeStable(settings);
                    }
                });
            }
            result2.add(new ActionWrapper(ExecutionBundle.message((String)"choose.run.popup.delete", (Object[])new Object[0]), AllIcons.Actions.Cancel){

                @Override
                public void perform() {
                    ChooseRunConfigurationManager.deleteConfiguration(project, settings, (JBPopup)action.myPopup);
                }
            });
            return result2.toArray(new ActionWrapper[0]);
        }

        public PopupStep<?> onChosen(ActionWrapper selectedValue, boolean finalChoice) {
            return this.doFinalStep(() -> selectedValue.perform());
        }

        public Icon getIconFor(ActionWrapper aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionWrapper value) {
            String string = value.getText();
            if (string == null) {
                ConfigurationActionsStep.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationManager$ConfigurationActionsStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager$ConfigurationActionsStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildActions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    static final class ConfigurationListPopupStep
    extends BaseListPopupStep<ChooseRunConfigurationPopup.ItemWrapper<?>> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myAction;
        private int myDefaultConfiguration;

        ConfigurationListPopupStep(@NotNull ChooseRunConfigurationPopup action, @NotNull Project project, @NotNull @Nls String title, @NotNull List<ChooseRunConfigurationPopup.ItemWrapper<?>> list) {
            boolean hasMnemonics;
            if (action == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(1);
            }
            if (title == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(2);
            }
            if (list == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(3);
            }
            super(title, list);
            this.myDefaultConfiguration = -1;
            this.myProject = project;
            this.myAction = action;
            if (-1 == this.getDefaultOptionIndex()) {
                this.myDefaultConfiguration = this.getDynamicIndex();
            }
            if (hasMnemonics = ContainerUtil.exists((Iterable)this.getValues(), wrapper -> wrapper.getMnemonic() != -1)) {
                this.getValues().forEach(wrapper -> wrapper.setMnemonicsEnabled(true));
            }
        }

        private int getDynamicIndex() {
            int i = 0;
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper : this.getValues()) {
                if (wrapper.isDynamic()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public ListSeparator getSeparatorAbove(ChooseRunConfigurationPopup.ItemWrapper value) {
            if (value.addSeparatorAbove()) {
                return new ListSeparator();
            }
            List configurations = this.getValues();
            int index = configurations.indexOf(value);
            if (index > 0 && index <= configurations.size() - 1) {
                ConfigurationType aboveType;
                ChooseRunConfigurationPopup.ItemWrapper aboveConfiguration = (ChooseRunConfigurationPopup.ItemWrapper)configurations.get(index - 1);
                if (aboveConfiguration != null && aboveConfiguration.isDynamic() != value.isDynamic()) {
                    return new ListSeparator();
                }
                ConfigurationType currentType = value.getType();
                ConfigurationType configurationType = aboveType = aboveConfiguration == null ? null : aboveConfiguration.getType();
                if (aboveType != currentType && currentType != null) {
                    return new ListSeparator();
                }
            }
            return null;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public int getDefaultOptionIndex() {
            RunnerAndConfigurationSettings currentConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (currentConfiguration == null && this.myDefaultConfiguration != -1) {
                return this.myDefaultConfiguration;
            }
            return currentConfiguration instanceof RunnerAndConfigurationSettingsImpl ? this.getValues().indexOf(ChooseRunConfigurationPopup.ItemWrapper.wrap(this.myProject, currentConfiguration)) : -1;
        }

        public PopupStep<?> onChosen(ChooseRunConfigurationPopup.ItemWrapper wrapper, boolean finalChoice) {
            Object o;
            if (this.myAction.myEditConfiguration && (o = wrapper.getValue()) instanceof RunnerAndConfigurationSettingsImpl) {
                return this.doFinalStep(() -> this.myAction.editConfiguration(this.myProject, (RunnerAndConfigurationSettings)o));
            }
            if (finalChoice && wrapper.available(this.myAction.getExecutor())) {
                return this.doFinalStep(() -> {
                    if (this.myAction.getExecutor() == this.myAction.myAlternativeExecutor) {
                        PropertiesComponent.getInstance().setValue(this.myAction.myAddKey, Boolean.toString(true));
                    }
                    wrapper.perform(this.myProject, this.myAction.getExecutor(), DataManager.getInstance().getDataContext());
                });
            }
            return wrapper.getNextStep(this.myProject, this.myAction);
        }

        public boolean isFinal(ChooseRunConfigurationPopup.ItemWrapper wrapper) {
            return this.myAction.myEditConfiguration || wrapper.available(this.myAction.getExecutor()) || wrapper.getNextStep(this.myProject, this.myAction) == FINAL_CHOICE;
        }

        public boolean hasSubstep(ChooseRunConfigurationPopup.ItemWrapper selectedValue) {
            return selectedValue.hasActions();
        }

        @NotNull
        public String getTextFor(ChooseRunConfigurationPopup.ItemWrapper value) {
            String string = value.getText();
            if (string == null) {
                ConfigurationListPopupStep.$$$reportNull$$$0(4);
            }
            return string;
        }

        public Icon getIconFor(ChooseRunConfigurationPopup.ItemWrapper value) {
            return value.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationManager$ConfigurationListPopupStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationManager$ConfigurationListPopupStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    static final class FolderStep
    extends BaseListPopupStep<ConfigurationActionsStep> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myPopup;
        private final ExecutorProvider myExecutorProvider;

        private FolderStep(Project project, ExecutorProvider executorProvider, @NlsSafe String folderName, List<ConfigurationActionsStep> children, ChooseRunConfigurationPopup popup) {
            super(folderName, children, new ArrayList());
            this.myProject = project;
            this.myExecutorProvider = executorProvider;
            this.myPopup = popup;
        }

        public PopupStep<?> onChosen(ConfigurationActionsStep selectedValue, boolean finalChoice) {
            if (finalChoice) {
                if (this.myPopup.myEditConfiguration) {
                    RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    return this.doFinalStep(() -> this.myPopup.editConfiguration(this.myProject, settings));
                }
                return this.doFinalStep(() -> {
                    RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(settings);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)this.myExecutorProvider.getExecutor());
                });
            }
            return selectedValue;
        }

        public Icon getIconFor(ConfigurationActionsStep aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ConfigurationActionsStep value) {
            String string = value.getName();
            if (string == null) {
                FolderStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean hasSubstep(ConfigurationActionsStep selectedValue) {
            return !selectedValue.getValues().isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationManager$FolderStep", "getTextFor"));
        }
    }
}

