/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ExecutionTargetComboBoxActionKt;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001(B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J;\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00132\r\u0010\u001a\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%H\u0014J\b\u0010&\u001a\u00020'H\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/execution/actions/ExecutionTargetComboBoxAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "button", "Ljavax/swing/JComponent;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "getTargetGroupActions", "targets", "Lcom/intellij/execution/ExecutionTarget;", "targetGroupName", "", "Lorg/jetbrains/annotations/Nls;", "activeTarget", "createActionPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "group", "context", "disposeCallback", "Ljava/lang/Runnable;", "getPreselectCondition", "Lcom/intellij/openapi/util/Condition;", "shouldShowDisabledActions", "", "SelectTargetAction", "intellij.platform.execution.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExecutionTargetComboBoxAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionTargetComboBoxAction.kt\ncom/intellij/execution/actions/ExecutionTargetComboBoxAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1491#2:157\n1516#2,3:158\n1519#2,3:168\n1056#2:171\n1869#2,2:172\n382#3,7:161\n*S KotlinDebug\n*F\n+ 1 ExecutionTargetComboBoxAction.kt\ncom/intellij/execution/actions/ExecutionTargetComboBoxAction\n*L\n80#1:157\n80#1:158,3\n80#1:168,3\n88#1:171\n105#1:172,2\n80#1:161,7\n*E\n"})
public final class ExecutionTargetComboBoxAction
extends ComboBoxAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (project == null || project.isDisposed() || !project.isOpen() || !Intrinsics.areEqual((Object)RunManager.IS_RUN_MANAGER_INITIALIZED.get((UserDataHolder)project), (Object)true)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"getActiveTarget(...)");
        ExecutionTarget executionTarget2 = executionTarget;
        if (Intrinsics.areEqual((Object)executionTarget2, (Object)DefaultExecutionTarget.INSTANCE) || executionTarget2.isExternallyManaged()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setEnabledAndVisible(true);
        String string = StringUtil.trimMiddle((String)executionTarget2.getDisplayName(), (int)80);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimMiddle(...)");
        String name = string;
        presentation2.setText(name, false);
        presentation2.setIcon(executionTarget2.getIcon());
        presentation2.setDescription(executionTarget2.getDescription());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext dataContext) {
        ActionGroup additionalActions;
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return actionGroup;
        }
        Project project2 = project;
        actionGroup.addAll((Collection)this.getTargetActions(project2));
        AnAction anAction = ActionManager.getInstance().getAction("ExecutionTargets.Additional");
        ActionGroup actionGroup2 = additionalActions = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (additionalActions != null) {
            actionGroup.add((AnAction)additionalActions);
        }
        return actionGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnAction> getTargetActions(Project project) {
        void $this$groupByTo$iv$iv;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).getSelectedConfiguration();
        if (runnerAndConfigurationSettings == null) {
            return CollectionsKt.emptyList();
        }
        RunnerAndConfigurationSettings selectedConfiguration = runnerAndConfigurationSettings;
        List list = ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)selectedConfiguration.getConfiguration());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTargetsToChooseFor(...)");
        List targets = list;
        ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"getActiveTarget(...)");
        ExecutionTarget activeTarget = executionTarget;
        Iterable $this$groupBy$iv = targets;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            ExecutionTarget it = (ExecutionTarget)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getGroupName();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map targetsGroups = destination$iv$iv;
        List actions = new ArrayList();
        List defaultGroup = (List)targetsGroups.get(null);
        if (defaultGroup != null) {
            actions.addAll((Collection)this.getTargetGroupActions(project, defaultGroup, null, activeTarget));
        }
        Iterable $this$sortedBy$iv = targetsGroups.entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        })) {
            String name = (String)entry.getKey();
            List targetsGroup = (List)entry.getValue();
            if (name == null) continue;
            actions.addAll((Collection)this.getTargetGroupActions(project, targetsGroup, name, activeTarget));
        }
        return actions;
    }

    private final List<AnAction> getTargetGroupActions(Project project, List<? extends ExecutionTarget> targets, String targetGroupName, ExecutionTarget activeTarget) {
        List actions = new ArrayList();
        if (targetGroupName != null) {
            Separator separator = Separator.create((String)targetGroupName);
            Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"create(...)");
            actions.add(separator);
        }
        Iterable $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutionTarget it = (ExecutionTarget)element$iv;
            boolean bl = false;
            actions.add(new SelectTargetAction(project, it, Intrinsics.areEqual((Object)it, (Object)activeTarget), it.isReady()));
        }
        return actions;
    }

    @NotNull
    protected ListPopup createActionPopup(@NotNull DefaultActionGroup group2, @NotNull DataContext context, @Nullable Runnable disposeCallback) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)group2, context, null, this.shouldShowDisabledActions(), disposeCallback, this.getMaxRows(), this.getPreselectCondition(), ExecutionTargetComboBoxActionKt.EXECUTION_TARGETS_COMBO_ACTION_PLACE);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        popup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        return popup;
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        return ExecutionTargetComboBoxAction::getPreselectCondition$lambda$0;
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    private static final boolean getPreselectCondition$lambda$0(AnAction it) {
        return it instanceof SelectTargetAction ? ((SelectTargetAction)it).isSelected() : false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/actions/ExecutionTargetComboBoxAction$SelectTargetAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/execution/ExecutionTarget;", "isSelected", "", "isReady", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/ExecutionTarget;ZZ)V", "()Z", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.execution.impl"})
    private static final class SelectTargetAction
    extends DumbAwareAction {
        @NotNull
        private final Project project;
        @NotNull
        private final ExecutionTarget target;
        private final boolean isSelected;
        private final boolean isReady;

        public SelectTargetAction(@NotNull Project project, @NotNull ExecutionTarget target, boolean isSelected, boolean isReady) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.project = project;
            this.target = target;
            this.isSelected = isSelected;
            this.isReady = isReady;
            String string = this.target.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String name = string;
            this.getTemplatePresentation().setText(name, false);
            Object[] objectArray = new Object[]{name};
            this.getTemplatePresentation().setDescription(ExecutionBundle.message((String)"select.0", (Object[])objectArray));
            this.getTemplatePresentation().setIcon(this.target.getIcon());
        }

        public final boolean isSelected() {
            return this.isSelected;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.isReady);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ExecutionTargetManager.setActiveTarget((Project)this.project, (ExecutionTarget)this.target);
        }
    }
}

