/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ExecutorAction;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ExperimentalUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RunSpecifiedConfigExecutorAction
extends ExecutorAction {
    private static final Logger LOG = Logger.getInstance(RunSpecifiedConfigExecutorAction.class);
    private final RunnerAndConfigurationSettings myRunConfig;
    private final boolean myEditConfigBeforeRun;

    public RunSpecifiedConfigExecutorAction(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings runConfig, boolean editConfigBeforeRun) {
        if (executor == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(0);
        }
        if (runConfig == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(1);
        }
        super(executor);
        this.myRunConfig = runConfig;
        this.myEditConfigBeforeRun = editConfigBeforeRun;
    }

    @Override
    @NotNull
    protected RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(2);
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myRunConfig;
        if (runnerAndConfigurationSettings == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(3);
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(4);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.myEditConfigBeforeRun) {
            presentation.setText(ExecutionBundle.message((String)"choose.run.popup.edit", (Object[])new Object[0]));
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.popup.edit.description", (Object[])new Object[0]));
            presentation.setIcon(!ExperimentalUI.isNewUI() ? AllIcons.Actions.EditSource : null);
        }
        if (!presentation.isEnabled() && presentation.getClientProperty(WOULD_BE_ENABLED_BUT_STARTING) != Boolean.TRUE) {
            presentation.setVisible(false);
        }
    }

    @Override
    protected void run(@NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
        String dialogTitle;
        if (project == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            RunSpecifiedConfigExecutorAction.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(this.myRunConfig == settings);
        if (this.myEditConfigBeforeRun && !RunDialog.editConfiguration(project, this.myRunConfig, dialogTitle = ExecutionBundle.message((String)"dialog.title.edit.configuration.settings", (Object[])new Object[0]), this.myExecutor)) {
            return;
        }
        super.run(project, this.myRunConfig, dataContext);
        RunManager.getInstance((Project)project).setSelectedConfiguration(this.myRunConfig);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunSpecifiedConfigExecutorAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunSpecifiedConfigExecutorAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedConfiguration";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

