/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.configurations.GeneralCommandLine;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentVariablesData {
    public static final EnvironmentVariablesData DEFAULT = new EnvironmentVariablesData(Map.of(), true, null);
    private static final String ENVS = "envs";
    private static final String PASS_PARENT_ENVS = "pass-parent-envs";
    private static final String ENV = "env";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private final Map<String, String> myEnvs;
    private final String myEnvironmentFile;
    private final boolean myPassParentEnvs;

    private EnvironmentVariablesData(@NotNull Map<String, String> envs, boolean passParentEnvs, @Nullable String environmentFile) {
        if (envs == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(0);
        }
        this.myEnvs = envs.isEmpty() ? Map.of() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(envs));
        this.myPassParentEnvs = passParentEnvs;
        this.myEnvironmentFile = environmentFile;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    public String getEnvironmentFile() {
        return this.myEnvironmentFile;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariablesData data = (EnvironmentVariablesData)o;
        return this.myPassParentEnvs == data.myPassParentEnvs && this.myEnvs.equals(data.myEnvs) && Objects.equals(this.myEnvironmentFile, data.myEnvironmentFile);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = this.myEnvs.hashCode();
        result2 = 31 * result2 + (this.myPassParentEnvs ? 1 : 0);
        if (this.myEnvironmentFile != null) {
            result2 = 31 * result2 + this.myEnvironmentFile.hashCode();
        }
        return result2;
    }

    public String toString() {
        return "envs=" + String.valueOf(this.myEnvs) + ", passParentEnvs=" + this.myPassParentEnvs + ", environmentFile=" + this.myEnvironmentFile;
    }

    @NotNull
    public static EnvironmentVariablesData readExternal(@NotNull Element element) {
        Element envsElement;
        if (element == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(2);
        }
        if ((envsElement = element.getChild(ENVS)) == null) {
            EnvironmentVariablesData environmentVariablesData = DEFAULT;
            if (environmentVariablesData == null) {
                EnvironmentVariablesData.$$$reportNull$$$0(3);
            }
            return environmentVariablesData;
        }
        Map<String, String> envs = Map.of();
        String passParentEnvsStr = envsElement.getAttributeValue(PASS_PARENT_ENVS);
        boolean passParentEnvs = passParentEnvsStr == null || Boolean.parseBoolean(passParentEnvsStr);
        for (Element envElement : envsElement.getChildren(ENV)) {
            String envName = envElement.getAttributeValue(NAME);
            String envValue = envElement.getAttributeValue(VALUE);
            if (envName == null || envValue == null) continue;
            if (envs.isEmpty()) {
                envs = new LinkedHashMap<String, String>();
            }
            envs.put(envName, envValue);
        }
        return EnvironmentVariablesData.create(envs, passParentEnvs);
    }

    public void writeExternalNoDefault(@NotNull Element parent) {
        if (parent == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(4);
        }
        if (!DEFAULT.equals(this)) {
            this.writeExternal(parent);
        }
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(5);
        }
        Element envsElement = new Element(ENVS);
        if (!this.myPassParentEnvs) {
            envsElement.setAttribute(PASS_PARENT_ENVS, Boolean.FALSE.toString());
        }
        for (Map.Entry<String, String> entry : this.myEnvs.entrySet()) {
            envsElement.addContent(new Element(ENV).setAttribute(NAME, entry.getKey()).setAttribute(VALUE, entry.getValue()));
        }
        parent.addContent(envsElement);
    }

    public void configureCommandLine(@NotNull GeneralCommandLine commandLine, boolean consoleParentEnvs) {
        if (commandLine == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(6);
        }
        commandLine.withParentEnvironmentType(!this.myPassParentEnvs ? GeneralCommandLine.ParentEnvironmentType.NONE : (consoleParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.SYSTEM));
        commandLine.withEnvironment(this.myEnvs);
    }

    @NotNull
    public static EnvironmentVariablesData create(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        if (envs == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(7);
        }
        return EnvironmentVariablesData.create(envs, passParentEnvs, null);
    }

    @NotNull
    public static EnvironmentVariablesData create(@NotNull Map<String, String> envs, boolean passParentEnvs, @Nullable String environmentFile) {
        if (envs == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(8);
        }
        if (passParentEnvs && envs.isEmpty() && environmentFile == null) {
            EnvironmentVariablesData environmentVariablesData = DEFAULT;
            if (environmentVariablesData == null) {
                EnvironmentVariablesData.$$$reportNull$$$0(9);
            }
            return environmentVariablesData;
        }
        return new EnvironmentVariablesData(envs, passParentEnvs, environmentFile);
    }

    @NotNull
    public EnvironmentVariablesData with(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentVariablesData.$$$reportNull$$$0(10);
        }
        return EnvironmentVariablesData.create(envs, this.myPassParentEnvs, this.myEnvironmentFile);
    }

    @NotNull
    public EnvironmentVariablesData with(boolean passParentEnvs) {
        return passParentEnvs == this.myPassParentEnvs ? this : EnvironmentVariablesData.create(this.myEnvs, passParentEnvs, this.myEnvironmentFile);
    }

    @NotNull
    public EnvironmentVariablesData with(@Nullable String environmentFile) {
        return Objects.equals(environmentFile, this.myEnvironmentFile) ? this : EnvironmentVariablesData.create(this.myEnvs, this.myPassParentEnvs, environmentFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ENVS;
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/EnvironmentVariablesData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/EnvironmentVariablesData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternalNoDefault";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 9 -> new IllegalStateException(string);
        };
    }
}

