/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.impl.RCInArbitraryFileListenerKt;
import com.intellij.execution.impl.RCInArbitraryFileManager;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/impl/RCInArbitraryFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "Lorg/jetbrains/annotations/Nullable;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.platform.execution.impl"})
final class RCInArbitraryFileListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Set deletedRCFilePaths = new LinkedHashSet();
        Set updatedRCFilePaths = new LinkedHashSet();
        for (VFileEvent vFileEvent : events) {
            if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent.getRequestor() instanceof RCInArbitraryFileManager) continue;
            if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFileCreateEvent) {
                String string = vFileEvent.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(string)) {
                    String string2 = vFileEvent.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    updatedRCFilePaths.add(string2);
                    deletedRCFilePaths.remove(vFileEvent.getPath());
                }
            } else if (vFileEvent instanceof VFileCopyEvent) {
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(((VFileCopyEvent)vFileEvent).getNewParent().getPath() + "/" + ((VFileCopyEvent)vFileEvent).getNewChildName())) {
                    String string = ((VFileCopyEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    updatedRCFilePaths.add(string);
                    deletedRCFilePaths.remove(((VFileCopyEvent)vFileEvent).getPath());
                }
            } else if (vFileEvent instanceof VFileDeleteEvent) {
                String string = ((VFileDeleteEvent)vFileEvent).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(string)) {
                    updatedRCFilePaths.remove(((VFileDeleteEvent)vFileEvent).getPath());
                    String string3 = ((VFileDeleteEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    deletedRCFilePaths.add(string3);
                }
            } else if (vFileEvent instanceof VFileMoveEvent) {
                String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(string)) {
                    updatedRCFilePaths.remove(((VFileMoveEvent)vFileEvent).getOldPath());
                    String string4 = ((VFileMoveEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getOldPath(...)");
                    deletedRCFilePaths.add(string4);
                }
                String string5 = ((VFileMoveEvent)vFileEvent).getNewPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getNewPath(...)");
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(string5)) {
                    String string6 = ((VFileMoveEvent)vFileEvent).getNewPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getNewPath(...)");
                    updatedRCFilePaths.add(string6);
                    deletedRCFilePaths.remove(((VFileMoveEvent)vFileEvent).getNewPath());
                }
            } else if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                String string = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(string)) {
                    updatedRCFilePaths.remove(((VFilePropertyChangeEvent)vFileEvent).getOldPath());
                    String string7 = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getOldPath(...)");
                    deletedRCFilePaths.add(string7);
                }
                String string8 = ((VFilePropertyChangeEvent)vFileEvent).getNewPath();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getNewPath(...)");
                if (RCInArbitraryFileListenerKt.access$isFileWithRunConfigs(string8)) {
                    String string9 = ((VFilePropertyChangeEvent)vFileEvent).getNewPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getNewPath(...)");
                    updatedRCFilePaths.add(string9);
                    deletedRCFilePaths.remove(((VFilePropertyChangeEvent)vFileEvent).getNewPath());
                }
            }
            if (!(!((Collection)updatedRCFilePaths).isEmpty()) && !(!((Collection)deletedRCFilePaths).isEmpty())) continue;
            return new AsyncFileListener.ChangeApplier(deletedRCFilePaths, updatedRCFilePaths){
                final /* synthetic */ Set<String> $deletedRCFilePaths;
                final /* synthetic */ Set<String> $updatedRCFilePaths;
                {
                    this.$deletedRCFilePaths = $deletedRCFilePaths;
                    this.$updatedRCFilePaths = $updatedRCFilePaths;
                }

                public void afterVfsChange() {
                    for (Project project : ProjectUtil.getOpenedProjects()) {
                        RunManagerImpl.Companion.getInstanceImpl(project).updateRunConfigsFromArbitraryFiles$intellij_platform_execution_impl((Collection<String>)this.$deletedRCFilePaths, (Collection<String>)this.$updatedRCFilePaths);
                    }
                }
            };
        }
        return null;
    }
}

