/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.impl.RunConfigurableKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.DumbService;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/RunConfigurableTreeRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "<init>", "(Lcom/intellij/execution/impl/RunManagerImpl;)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.platform.execution.impl"})
public final class RunConfigurableTreeRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final RunManagerImpl runManager;

    public RunConfigurableTreeRenderer(@NotNull RunManagerImpl runManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)runManager), (String)"runManager");
        this.runManager = runManager;
    }

    public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof DefaultMutableTreeNode)) {
            return;
        }
        Icon[] userObject = ((DefaultMutableTreeNode)value).getUserObject();
        Boolean isShared = null;
        Intrinsics.checkNotNull((Object)userObject);
        String name = RunConfigurableKt.getUserObjectName(userObject);
        boolean isDumb = DumbService.Companion.isDumb(this.runManager.getProject());
        Icon[] iconArray = userObject;
        if (iconArray instanceof ConfigurationType) {
            TreeNode treeNode = ((DefaultMutableTreeNode)value).getParent();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            SimpleTextAttributes simpleTextAttributes = ((DefaultMutableTreeNode)treeNode).isRoot() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (isDumb && !ConfigurationTypeUtil.isEditableInDumbMode((ConfigurationType)((ConfigurationType)userObject)) ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(name, simpleTextAttributes);
            this.setIcon(((ConfigurationType)userObject).getIcon());
        } else if (iconArray instanceof String) {
            this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(AllIcons.Nodes.Folder);
        } else if (iconArray instanceof ConfigurationFactory) {
            this.append(name, isDumb && !((ConfigurationFactory)userObject).isEditableInDumbMode() ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(((ConfigurationFactory)userObject).getIcon());
        } else {
            RunnerAndConfigurationSettings configuration = null;
            if (userObject instanceof SingleConfigurationConfigurable) {
                RunnerAndConfigurationSettings configurationSettings;
                Object object = ((SingleConfigurationConfigurable)userObject).getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSettings(...)");
                configuration = configurationSettings = (RunnerAndConfigurationSettings)object;
                isShared = ((SingleConfigurationConfigurable)userObject).isStoredInFile();
                this.setIcon(ProgramRunnerUtil.getConfigurationIcon(configurationSettings, !((SingleConfigurationConfigurable)userObject).isValid()));
            } else if (userObject instanceof RunnerAndConfigurationSettings) {
                isShared = ((RunnerAndConfigurationSettings)userObject).isShared();
                this.setIcon(this.runManager.getConfigurationIcon((RunnerAndConfigurationSettings)userObject));
                configuration = (RunnerAndConfigurationSettings)userObject;
            }
            if (configuration != null) {
                SimpleTextAttributes simpleTextAttributes = configuration.isTemporary() ? SimpleTextAttributes.GRAY_ATTRIBUTES : (isDumb && !ConfigurationTypeUtil.isEditableInDumbMode((RunnerAndConfigurationSettings)configuration) ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(name, simpleTextAttributes);
            }
        }
        if (isShared == null) {
            this.setIconTextGap(2);
        } else {
            iconArray = new Icon[]{this.getIcon(), isShared != false ? AllIcons.Nodes.Shared : EmptyIcon.ICON_16};
            this.setIcon((Icon)LayeredIcon.Companion.layeredIcon(iconArray));
            this.setIconTextGap(0);
        }
    }
}

