/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.NameGeneratingListenerDecorator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;

public class RunConfigurationRefactoringElementListenerProvider
implements RefactoringElementListenerProvider {
    private static final Logger LOG = Logger.getInstance(RunConfigurationRefactoringElementListenerProvider.class);

    public RefactoringElementListener getListener(PsiElement element) {
        RefactoringElementListenerComposite composite = null;
        for (RunConfiguration configuration : RunManager.getInstance((Project)element.getProject()).getAllConfigurationsList()) {
            RefactoringElementListener listener2;
            if (!(configuration instanceof RefactoringListenerProvider)) continue;
            try {
                listener2 = ((RefactoringListenerProvider)configuration).getRefactoringElementListener(element);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (listener2 == null) continue;
            if (configuration instanceof LocatableConfiguration) {
                listener2 = new NameGeneratingListenerDecorator((LocatableConfiguration)configuration, listener2);
            }
            if (composite == null) {
                composite = new RefactoringElementListenerComposite();
            }
            composite.addListener(listener2);
        }
        return composite;
    }
}

