/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/impl/statistics/ProgramRunnerUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "RUNNER", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "Ljava/lang/Class;", "RUN_PROFILE", "IS_ASYNC", "", "EXECUTE_ACTIVITY", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "startExecute", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "project", "Lcom/intellij/openapi/project/Project;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "finishExecute", "", "activity", "isAsync", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class ProgramRunnerUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final ProgramRunnerUsageCollector INSTANCE = new ProgramRunnerUsageCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("program.runner", 1, null, 4, null);
    @NotNull
    private static final EventField<Class<?>> RUNNER = (EventField)EventFields.Class((String)"runner");
    @NotNull
    private static final EventField<Class<?>> RUN_PROFILE = (EventField)EventFields.Class((String)"run_profile");
    @NotNull
    private static final EventField<Boolean> IS_ASYNC = (EventField)EventFields.Boolean((String)"async");
    @NotNull
    private static final IdeActivityDefinition EXECUTE_ACTIVITY;

    private ProgramRunnerUsageCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final StructuredIdeActivity startExecute(@NotNull Project project, @NotNull ProgramRunner<?> runner, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return EXECUTE_ACTIVITY.started(project, () -> ProgramRunnerUsageCollector.startExecute$lambda$0(runner, profile));
    }

    public final void finishExecute(@NotNull StructuredIdeActivity activity, @NotNull ProgramRunner<?> runner, @NotNull RunProfile profile, boolean isAsync) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        activity.finished(() -> ProgramRunnerUsageCollector.finishExecute$lambda$0(runner, profile, isAsync));
    }

    private static final List startExecute$lambda$0(ProgramRunner $runner, RunProfile $profile) {
        Object[] objectArray = new EventPair[]{RUNNER.with($runner.getClass()), RUN_PROFILE.with($profile.getClass())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final List finishExecute$lambda$0(ProgramRunner $runner, RunProfile $profile, boolean $isAsync) {
        Object[] objectArray = new EventPair[]{RUNNER.with($runner.getClass()), RUN_PROFILE.with($profile.getClass()), IS_ASYNC.with((Object)$isAsync)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{RUNNER, RUN_PROFILE};
        EventField[] eventFieldArray2 = eventFieldArray;
        eventFieldArray = new EventField[]{RUNNER, RUN_PROFILE, IS_ASYNC};
        EXECUTE_ACTIVITY = EventLogGroup.registerIdeActivity$default((EventLogGroup)GROUP, (String)"execute", (EventField[])eventFieldArray2, (EventField[])eventFieldArray, null, (boolean)false, (int)24, null);
    }
}

