/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
extends LineMarkerProviderDescriptor
implements DumbAware {
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace((RunLineMarkerContributor.Info)a)) {
            return 1;
        }
        if (a.shouldReplace((RunLineMarkerContributor.Info)b)) {
            return -1;
        }
        return 0;
    };
    private static final Key<Boolean> HAS_ANYTHING_RUNNABLE = Key.create((String)"HAS_ANYTHING_RUNNABLE");

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        InjectedLanguageManager injectedLanguageManager;
        if (element == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject())).isInjectedFragment(element.getContainingFile())) {
            return null;
        }
        List contributors = DumbService.getInstance((Project)element.getProject()).filterByDumbAwareness((Collection)RunLineMarkerContributor.EXTENSION.allForLanguageOrAny(element.getLanguage()));
        Icon icon = null;
        List infos = null;
        for (RunLineMarkerContributor contributor : contributors) {
            ProgressManager.checkCanceled();
            RunLineMarkerContributor.Info info = contributor.getInfo(element);
            if (info == null) continue;
            if (icon == null) {
                icon = info.icon;
            }
            if (infos == null) {
                infos = new SmartList();
            }
            infos.add(info);
        }
        if (icon == null) {
            return null;
        }
        return RunLineMarkerProvider.createLineMarker(element, icon, infos);
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            List contributors = DumbService.getInstance((Project)psiElement.getProject()).filterByDumbAwareness((Collection)RunLineMarkerContributor.EXTENSION.allForLanguageOrAny(psiElement.getLanguage()));
            Icon icon = null;
            List infos = null;
            for (RunLineMarkerContributor contributor : contributors) {
                RunLineMarkerContributor.Info info = contributor.getSlowInfo(psiElement);
                if (info == null) continue;
                if (icon == null) {
                    icon = info.icon;
                }
                if (infos == null) {
                    infos = new SmartList();
                }
                infos.add(info);
            }
            if (icon == null) continue;
            result2.add(RunLineMarkerProvider.createLineMarker(psiElement, icon, infos));
        }
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement element, @NotNull Icon icon, @NotNull List<? extends RunLineMarkerContributor.Info> infos) {
        if (element == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (icon == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (infos == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (infos.size() > 1) {
            infos = new ArrayList<RunLineMarkerContributor.Info>(infos);
            infos.sort(COMPARATOR);
            RunLineMarkerContributor.Info first = infos.get(0);
            infos.removeIf(info -> info != first && first.shouldReplace((RunLineMarkerContributor.Info)info));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action : info2.actions) {
                actionGroup.add((AnAction)(action instanceof Separator ? action : new LineMarkerActionWrapper(element, action)));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add((AnAction)new Separator());
        }
        EquatableTooltipProvider tooltipProvider = new EquatableTooltipProvider(infos);
        return new RunLineMarkerInfo(element, icon, tooltipProvider, actionGroup);
    }

    private static String appendShortcut(String tooltip) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return tooltip;
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Run");
        if (executor != null) {
            String actionId = executor.getContextActionId();
            String shortcutText = KeymapUtil.getShortcutText((String)actionId);
            @NotNull String shortcutColor = ColorUtil.toHex((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground());
            return XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.escapeString((String)tooltip).replaceAll("\n", "<br>") + "&nbsp;&nbsp;<font color='#" + shortcutColor + "'>" + XmlStringUtil.escapeString((String)shortcutText) + "</font>"));
        }
        return tooltip;
    }

    @NotNull
    public String getName() {
        String string = ExecutionBundle.message((String)"run.line.marker.name", (Object[])new Object[0]);
        if (string == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    @NotNull
    public static ThreeState hadAnythingRunnable(@NotNull VirtualFile file) {
        Boolean data;
        if (file == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(7);
        }
        ThreeState threeState = (data = (Boolean)file.getUserData(HAS_ANYTHING_RUNNABLE)) == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)data);
        if (threeState == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    public static void markRunnable(@NotNull VirtualFile file, boolean isRunnable) {
        if (file == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(9);
        }
        file.putUserData(HAS_ANYTHING_RUNNABLE, (Object)isRunnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "hadAnythingRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hadAnythingRunnable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "markRunnable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }

    private static final class EquatableTooltipProvider
    implements Function<PsiElement, String> {
        @NotNull
        private final List<? extends RunLineMarkerContributor.Info> myInfos;

        EquatableTooltipProvider(@NotNull List<? extends RunLineMarkerContributor.Info> infos) {
            if (infos == null) {
                EquatableTooltipProvider.$$$reportNull$$$0(0);
            }
            this.myInfos = infos;
        }

        public int hashCode() {
            return this.myInfos.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof EquatableTooltipProvider)) return false;
            EquatableTooltipProvider other = (EquatableTooltipProvider)obj;
            if (!this.myInfos.equals(other.myInfos)) return false;
            return true;
        }

        public String fun(PsiElement element1) {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : this.myInfos) {
                String string;
                if (info.tooltipProvider == null || (string = info.tooltipProvider.apply((PsiElement)element1)) == null) continue;
                if (!tooltip.isEmpty()) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.isEmpty() ? null : RunLineMarkerProvider.appendShortcut(tooltip.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/execution/lineMarker/RunLineMarkerProvider$EquatableTooltipProvider", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static final class RunLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final DefaultActionGroup myActionGroup;

        RunLineMarkerInfo(PsiElement element, Icon icon, Function<? super PsiElement, @Nls String> tooltipProvider, DefaultActionGroup actionGroup) {
            super(element, element.getTextRange(), icon, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER, () -> (String)tooltipProvider.fun((Object)element));
            this.myActionGroup = actionGroup;
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return myActionGroup.getChildrenCount() == 1 ? myActionGroup.getChildActionsOrStubs()[0] : null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }

                public boolean isDumbAware() {
                    return myActionGroup.isDumbAware();
                }
            };
        }

        @NotNull
        public MarkupEditorFilter getEditorFilter() {
            MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsNotDiffFilter();
            if (markupEditorFilter == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(0);
            }
            return markupEditorFilter;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(1);
            }
            return info instanceof RunLineMarkerInfo && info.getIcon() == this.getIcon();
        }

        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return this.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerProvider$RunLineMarkerInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorFilter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerProvider$RunLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

