/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design;

import com.intellij.execution.multilaunch.design.ExecutableRow;
import com.intellij.execution.multilaunch.design.ExecutablesTable;
import com.intellij.execution.multilaunch.design.MultiLaunchConfigurationViewModel;
import com.intellij.execution.multilaunch.design.actions.ManageExecutableAction;
import com.intellij.execution.multilaunch.design.popups.TableSelectorPopupController;
import com.intellij.execution.multilaunch.design.tooltips.TableTooltipsController;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u000b\u001a\u00060\fR\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u001b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0018\u0010\u001e\u001a\u00020\u001b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0018\u0010\u001f\u001a\u00020\u001b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u0018\u0010 \u001a\u00020\u001b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0018\u0010!\u001a\u00020\u001b*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/execution/multilaunch/design/ExecutablesTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/execution/multilaunch/design/ExecutableRow;", "project", "Lcom/intellij/openapi/project/Project;", "viewModel", "Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationViewModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationViewModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "createDefaultTableHeader", "Lcom/intellij/ui/table/JBTable$JBTableHeader;", "Lcom/intellij/ui/table/JBTable;", "adjustColumns", "", "installPopupSelectorsController", "installTooltipsController", "installColumnAutoEdit", "installCursorsController", "installExecutableManageActions", "getCellPopupMinimalBounds", "Ljava/awt/Rectangle;", "row", "", "column", "isUnknownColumn", "", "(I)Z", "isUnknownRow", "isNameColumn", "isConditionColumn", "isModeColumn", "isAddExecutableRow", "Companion", "EditableCellContext", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class ExecutablesTable
extends TableView<ExecutableRow> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MultiLaunchConfigurationViewModel viewModel;
    @NotNull
    private final Lifetime lifetime;
    public static final int UNKNOWN_CELL = -1;
    public static final int NAME_COLUMN = 0;
    public static final int CONDITION_COLUMN = 1;
    public static final int MODE_COLUMN = 2;

    public ExecutablesTable(@NotNull Project project, @NotNull MultiLaunchConfigurationViewModel viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super((ListTableModel)viewModel.getTableModel());
        this.project = project;
        this.viewModel = viewModel;
        this.lifetime = lifetime;
        this.rowSelectionAllowed = false;
        this.putClientProperty(RenderingUtil.PAINT_HOVERED_BACKGROUND, false);
        this.setVisibleRowCount(18);
        this.adjustColumns();
        this.installPopupSelectorsController();
        this.installTooltipsController();
        this.installCursorsController();
        this.installExecutableManageActions();
    }

    @NotNull
    protected JBTable.JBTableHeader createDefaultTableHeader() {
        return new JBTable.JBTableHeader((JBTable)this);
    }

    private final void adjustColumns() {
        TableColumn tableColumn;
        TableColumnModel tableColumnModel;
        TableColumnModel $this$adjustColumns_u24lambda_u240 = tableColumnModel = this.columnModel;
        boolean bl = false;
        TableColumn $this$adjustColumns_u24lambda_u240_u240 = tableColumn = $this$adjustColumns_u24lambda_u240.getColumn(0);
        boolean bl2 = false;
        $this$adjustColumns_u24lambda_u240_u240.setResizable(false);
        TableColumn $this$adjustColumns_u24lambda_u240_u241 = tableColumn = $this$adjustColumns_u24lambda_u240.getColumn(1);
        boolean bl3 = false;
        $this$adjustColumns_u24lambda_u240_u241.setResizable(false);
        TableColumn $this$adjustColumns_u24lambda_u240_u242 = tableColumn = $this$adjustColumns_u24lambda_u240.getColumn(2);
        boolean bl4 = false;
        $this$adjustColumns_u24lambda_u240_u242.setResizable(false);
        $this$adjustColumns_u24lambda_u240_u242.setMaxWidth(JBUI.scale((int)60));
        $this$adjustColumns_u24lambda_u240_u242.setHeaderRenderer(ExecutablesTable::adjustColumns$lambda$0$2$0);
        this.installColumnAutoEdit();
    }

    private final void installPopupSelectorsController() {
        new TableSelectorPopupController().install((JTable)((Object)this));
    }

    private final void installTooltipsController() {
        new TableTooltipsController((Lifetime)this.lifetime.createNested(), null, 2, null).install((JTable)((Object)this));
    }

    private final void installColumnAutoEdit() {
        TableHoverListener.DEFAULT.removeFrom((JComponent)((Object)this));
        new TableHoverListener(this){
            final /* synthetic */ ExecutablesTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void onHover(JTable table, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                if (ExecutablesTable.access$isUnknownColumn(this.this$0, column) || ExecutablesTable.access$isUnknownRow(this.this$0, row)) {
                    return;
                }
                table.editCellAt(row, column);
            }
        }.addTo((JComponent)((Object)this));
    }

    private final void installCursorsController() {
        new TableHoverListener(this){
            final /* synthetic */ ExecutablesTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void onHover(JTable table, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                if (column == -1 || row == -1) {
                    return;
                }
                table.setCursor(!ExecutablesTable.access$isNameColumn(this.this$0, column) && !ExecutablesTable.access$isAddExecutableRow(this.this$0, row) && table.getValueAt(row, column) != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
            }
        }.addTo((JComponent)((Object)this));
    }

    private final void installExecutableManageActions() {
        PopupHandler handler2 = new PopupHandler(this){
            final /* synthetic */ ExecutablesTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void invokePopup(Component comp, int x, int y) {
                EditableCellContext editableCellContext = this.getCellInfo(x, y);
                if (editableCellContext == null) {
                    return;
                }
                EditableCellContext cellInfo = editableCellContext;
                AnAction anAction = ActionManager.getInstance().getAction("multilaunch.ManageExecutableGroup");
                Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                ActionGroup actions = (ActionGroup)anAction;
                ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("popup", actions);
                Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
                ActionPopupMenu popupMenu = actionPopupMenu;
                popupMenu.setDataContext(() -> installExecutableManageActions.handler.1.invokePopup$lambda$0(this.this$0, cellInfo));
                Rectangle rect = this.this$0.getCellRect(cellInfo.getRow(), cellInfo.getColumn(), false);
                popupMenu.getComponent().show((Component)((Object)this.this$0), x, rect.y + rect.height);
            }

            private final EditableCellContext getCellInfo(int mouseX, int mouseY) {
                Point point = new Point(mouseX, mouseY);
                int row = this.this$0.rowAtPoint(point);
                int column = this.this$0.columnAtPoint(point);
                if (!ExecutablesTable.access$isNameColumn(this.this$0, column)) {
                    return null;
                }
                if (ExecutablesTable.access$isUnknownRow(this.this$0, row)) {
                    return null;
                }
                if (ExecutablesTable.access$isAddExecutableRow(this.this$0, row)) {
                    return null;
                }
                ExecutableRow executableRow = ExecutablesTable.access$getViewModel$p(this.this$0).getRows().get(row);
                if (executableRow == null) {
                    return null;
                }
                ExecutableRow executionContext = executableRow;
                Rectangle bounds = ExecutablesTable.access$getCellPopupMinimalBounds(this.this$0, row, column);
                DataContext dataContext = ManageExecutableAction.Companion.createContext(ExecutablesTable.access$getProject$p(this.this$0), ExecutablesTable.access$getViewModel$p(this.this$0), executionContext, bounds);
                return new EditableCellContext(row, column, executionContext, bounds, dataContext);
            }

            private static final DataContext invokePopup$lambda$0(ExecutablesTable this$0, EditableCellContext $cellInfo) {
                return ManageExecutableAction.Companion.createContext(ExecutablesTable.access$getProject$p(this$0), ExecutablesTable.access$getViewModel$p(this$0), $cellInfo.getExecutionContext(), $cellInfo.getPopupMinimalBounds());
            }
        };
        this.addMouseListener((MouseListener)handler2);
    }

    private final Rectangle getCellPopupMinimalBounds(int row, int column) {
        Rectangle cellBounds = this.getCellRect(row, column, false);
        Point tableLocation = this.getLocationOnScreen();
        int cellScreenX = tableLocation.x + cellBounds.x;
        int cellScreenY = tableLocation.y + cellBounds.y + cellBounds.height;
        return new Rectangle(cellScreenX, cellScreenY, cellBounds.width, cellBounds.y);
    }

    private final boolean isUnknownColumn(int $this$isUnknownColumn) {
        return $this$isUnknownColumn == -1;
    }

    private final boolean isUnknownRow(int $this$isUnknownRow) {
        return $this$isUnknownRow == -1;
    }

    private final boolean isNameColumn(int $this$isNameColumn) {
        return $this$isNameColumn == 0;
    }

    private final boolean isConditionColumn(int $this$isConditionColumn) {
        return $this$isConditionColumn == 1;
    }

    private final boolean isModeColumn(int $this$isModeColumn) {
        return $this$isModeColumn == 2;
    }

    private final boolean isAddExecutableRow(int $this$isAddExecutableRow) {
        return $this$isAddExecutableRow == this.getRowCount() - 1;
    }

    private static final Component adjustColumns$lambda$0$2$0(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return new JLabel(AllIcons.General.DebugDisabled);
    }

    public static final /* synthetic */ boolean access$isUnknownColumn(ExecutablesTable $this, int $receiver) {
        return $this.isUnknownColumn($receiver);
    }

    public static final /* synthetic */ boolean access$isUnknownRow(ExecutablesTable $this, int $receiver) {
        return $this.isUnknownRow($receiver);
    }

    public static final /* synthetic */ boolean access$isNameColumn(ExecutablesTable $this, int $receiver) {
        return $this.isNameColumn($receiver);
    }

    public static final /* synthetic */ boolean access$isAddExecutableRow(ExecutablesTable $this, int $receiver) {
        return $this.isAddExecutableRow($receiver);
    }

    public static final /* synthetic */ MultiLaunchConfigurationViewModel access$getViewModel$p(ExecutablesTable $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ Rectangle access$getCellPopupMinimalBounds(ExecutablesTable $this, int row, int column) {
        return $this.getCellPopupMinimalBounds(row, column);
    }

    public static final /* synthetic */ Project access$getProject$p(ExecutablesTable $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/multilaunch/design/ExecutablesTable$Companion;", "", "<init>", "()V", "UNKNOWN_CELL", "", "NAME_COLUMN", "CONDITION_COLUMN", "MODE_COLUMN", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/execution/multilaunch/design/ExecutablesTable$EditableCellContext;", "", "row", "", "column", "executionContext", "Lcom/intellij/execution/multilaunch/design/ExecutableRow;", "popupMinimalBounds", "Ljava/awt/Rectangle;", "manageContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "<init>", "(IILcom/intellij/execution/multilaunch/design/ExecutableRow;Ljava/awt/Rectangle;Lcom/intellij/openapi/actionSystem/DataContext;)V", "getRow", "()I", "getColumn", "getExecutionContext", "()Lcom/intellij/execution/multilaunch/design/ExecutableRow;", "getPopupMinimalBounds", "()Ljava/awt/Rectangle;", "getManageContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.execution.impl"})
    public static final class EditableCellContext {
        private final int row;
        private final int column;
        @NotNull
        private final ExecutableRow executionContext;
        @NotNull
        private final Rectangle popupMinimalBounds;
        @NotNull
        private final DataContext manageContext;

        public EditableCellContext(int row, int column, @NotNull ExecutableRow executionContext, @NotNull Rectangle popupMinimalBounds, @NotNull DataContext manageContext) {
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)popupMinimalBounds, (String)"popupMinimalBounds");
            Intrinsics.checkNotNullParameter((Object)manageContext, (String)"manageContext");
            this.row = row;
            this.column = column;
            this.executionContext = executionContext;
            this.popupMinimalBounds = popupMinimalBounds;
            this.manageContext = manageContext;
        }

        public final int getRow() {
            return this.row;
        }

        public final int getColumn() {
            return this.column;
        }

        @NotNull
        public final ExecutableRow getExecutionContext() {
            return this.executionContext;
        }

        @NotNull
        public final Rectangle getPopupMinimalBounds() {
            return this.popupMinimalBounds;
        }

        @NotNull
        public final DataContext getManageContext() {
            return this.manageContext;
        }

        public final int component1() {
            return this.row;
        }

        public final int component2() {
            return this.column;
        }

        @NotNull
        public final ExecutableRow component3() {
            return this.executionContext;
        }

        @NotNull
        public final Rectangle component4() {
            return this.popupMinimalBounds;
        }

        @NotNull
        public final DataContext component5() {
            return this.manageContext;
        }

        @NotNull
        public final EditableCellContext copy(int row, int column, @NotNull ExecutableRow executionContext, @NotNull Rectangle popupMinimalBounds, @NotNull DataContext manageContext) {
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)popupMinimalBounds, (String)"popupMinimalBounds");
            Intrinsics.checkNotNullParameter((Object)manageContext, (String)"manageContext");
            return new EditableCellContext(row, column, executionContext, popupMinimalBounds, manageContext);
        }

        public static /* synthetic */ EditableCellContext copy$default(EditableCellContext editableCellContext, int n, int n2, ExecutableRow executableRow, Rectangle rectangle, DataContext dataContext, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = editableCellContext.row;
            }
            if ((n3 & 2) != 0) {
                n2 = editableCellContext.column;
            }
            if ((n3 & 4) != 0) {
                executableRow = editableCellContext.executionContext;
            }
            if ((n3 & 8) != 0) {
                rectangle = editableCellContext.popupMinimalBounds;
            }
            if ((n3 & 0x10) != 0) {
                dataContext = editableCellContext.manageContext;
            }
            return editableCellContext.copy(n, n2, executableRow, rectangle, dataContext);
        }

        @NotNull
        public String toString() {
            return "EditableCellContext(row=" + this.row + ", column=" + this.column + ", executionContext=" + this.executionContext + ", popupMinimalBounds=" + this.popupMinimalBounds + ", manageContext=" + this.manageContext + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.row);
            result2 = result2 * 31 + Integer.hashCode(this.column);
            result2 = result2 * 31 + this.executionContext.hashCode();
            result2 = result2 * 31 + this.popupMinimalBounds.hashCode();
            result2 = result2 * 31 + this.manageContext.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EditableCellContext)) {
                return false;
            }
            EditableCellContext editableCellContext = (EditableCellContext)other;
            if (this.row != editableCellContext.row) {
                return false;
            }
            if (this.column != editableCellContext.column) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.executionContext, (Object)editableCellContext.executionContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.popupMinimalBounds, (Object)editableCellContext.popupMinimalBounds)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.manageContext, (Object)editableCellContext.manageContext);
        }
    }
}

