/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design.components;

import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/multilaunch/design/components/RoundedCornerBorder;", "Ljavax/swing/border/Border;", "cornerRadius", "", "<init>", "(I)V", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class RoundedCornerBorder
implements Border {
    private final int cornerRadius;

    public RoundedCornerBorder(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        JBInsets jBInsets = JBUI.insets((int)this.cornerRadius, (int)this.cornerRadius, (int)this.cornerRadius, (int)this.cornerRadius);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(c.getBackground());
        g2d.fillRoundRect(x, y, width - 1, height - 1, this.cornerRadius, this.cornerRadius);
    }
}

