/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design.dialogs;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.design.components.IconCheckBoxList;
import com.intellij.execution.multilaunch.design.dialogs.AddMultipleConfigurationsDialog;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.execution.executables.impl.RunConfigurationExecutableManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\f\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/multilaunch/design/dialogs/AddMultipleConfigurationsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "existingExecutables", "", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;Ljava/util/List;)V", "selector", "com/intellij/execution/multilaunch/design/dialogs/AddMultipleConfigurationsDialog$selector$1", "Lcom/intellij/execution/multilaunch/design/dialogs/AddMultipleConfigurationsDialog$selector$1;", "selectedItems", "", "getSelectedItems", "()Ljava/util/List;", "beforeShowCallback", "", "createCenterPanel", "Ljavax/swing/JPanel;", "doOKAction", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nAddMultipleConfigurationsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddMultipleConfigurationsDialog.kt\ncom/intellij/execution/multilaunch/design/dialogs/AddMultipleConfigurationsDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n774#2:60\n865#2,2:61\n1869#2,2:63\n*S KotlinDebug\n*F\n+ 1 AddMultipleConfigurationsDialog.kt\ncom/intellij/execution/multilaunch/design/dialogs/AddMultipleConfigurationsDialog\n*L\n36#1:60\n36#1:61,2\n37#1:63,2\n*E\n"})
public final class AddMultipleConfigurationsDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiLaunchConfiguration configuration;
    @NotNull
    private final List<Executable> existingExecutables;
    @NotNull
    private final selector.1 selector;
    @NotNull
    private final List<Executable> selectedItems;

    public AddMultipleConfigurationsDialog(@NotNull Project project, @NotNull MultiLaunchConfiguration configuration, @NotNull List<? extends Executable> existingExecutables) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(existingExecutables, (String)"existingExecutables");
        super(project);
        this.project = project;
        this.configuration = configuration;
        this.existingExecutables = existingExecutables;
        this.selector = new IconCheckBoxList<Executable>(){

            public Icon getIcon(Executable item) {
                Executable executable = item;
                return executable != null ? executable.getIcon() : null;
            }

            public String getText(Executable item) {
                Executable executable = item;
                return executable != null ? executable.getName() : null;
            }
        };
        this.selectedItems = new ArrayList();
        this.setTitle(ExecutionBundle.message((String)"run.configurations.multilaunch.add.multiple.configurations.title", (Object[])new Object[0]));
        this.init();
    }

    @NotNull
    public final List<Executable> getSelectedItems() {
        return this.selectedItems;
    }

    /*
     * WARNING - void declaration
     */
    public void beforeShowCallback() {
        void $this$filterTo$iv$iv;
        this.selector.clear();
        Iterable $this$filter$iv = RunConfigurationExecutableManager.Companion.getInstance(this.project).listExecutables(this.configuration);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Executable it = (Executable)element$iv$iv;
            boolean bl = false;
            if (!(!this.existingExecutables.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List executables = (List)destination$iv$iv;
        Iterable $this$forEach$iv = executables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Executable it = (Executable)element$iv;
            boolean bl = false;
            this.selector.addItem(it, it.getName(), false);
        }
    }

    @NotNull
    protected JPanel createCenterPanel() {
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, fill, gap 0", "fill", "fill"));
        boolean bl = false;
        JBScrollPane $this$createCenterPanel_u24lambda_u240_u240 = jBScrollPane = new JBScrollPane((Component)((Object)this.selector));
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u240_u240.setMinimumSize(new Dimension(JBUI.scale((int)350), JBUI.scale((int)200)));
        JBScrollPane listPane = jBScrollPane;
        $this$createCenterPanel_u24lambda_u240.add((Component)listPane, "wrap");
        return jPanel;
    }

    protected void doOKAction() {
        this.selectedItems.clear();
        int n = this.selector.getItemsCount();
        for (int i = 0; i < n; ++i) {
            Executable value;
            if ((Executable)this.selector.getItemAt(i) == null || !this.selector.isItemSelected(i)) continue;
            this.selectedItems.add(value);
        }
        super.doOKAction();
    }
}

