/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.execution;

import com.intellij.execution.multilaunch.execution.ExecutableExecutionModel;
import com.intellij.execution.multilaunch.execution.MultiLaunchExecutionModel;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;)V", "getModel", "()Lcom/intellij/execution/multilaunch/execution/MultiLaunchExecutionModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "executableLifetimes", "", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "getLifetime", "executable", "stop", "", "awaitExecution", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionSession.kt\ncom/intellij/execution/multilaunch/execution/ExecutionSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,40:1\n1193#2,2:41\n1267#2,4:43\n426#3,11:47\n*S KotlinDebug\n*F\n+ 1 ExecutionSession.kt\ncom/intellij/execution/multilaunch/execution/ExecutionSession\n*L\n12#1:41,2\n12#1:43,4\n31#1:47,11\n*E\n"})
public final class ExecutionSession {
    @NotNull
    private final MultiLaunchExecutionModel model;
    @NotNull
    private final LifetimeDefinition lifetime;
    @NotNull
    private final Map<Executable, LifetimeDefinition> executableLifetimes;

    /*
     * WARNING - void declaration
     */
    public ExecutionSession(@NotNull Project project, @NotNull MultiLaunchExecutionModel model) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.lifetime = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        Iterable iterable = this.model.getExecutables().values();
        ExecutionSession executionSession = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ExecutableExecutionModel it = (ExecutableExecutionModel)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getDescriptor().getExecutable(), (Object)this.lifetime.createNested());
            map.put(pair.getFirst(), pair.getSecond());
        }
        executionSession.executableLifetimes = destination$iv$iv;
    }

    @NotNull
    public final MultiLaunchExecutionModel getModel() {
        return this.model;
    }

    @NotNull
    public final LifetimeDefinition getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public final LifetimeDefinition getLifetime(@NotNull Executable executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        return this.executableLifetimes.get(executable);
    }

    public final void stop() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetime, (boolean)false, (int)1, null);
    }

    public final void stop(@NotNull Executable executable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            LifetimeDefinition lifetimeDefinition = this.getLifetime(executable);
            if (lifetimeDefinition == null) break block0;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    @Nullable
    public final Object awaitExecution(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.lifetime.onTermination((Function0)new Function0<Unit>((CancellableContinuation<? super Unit>)it){
            final /* synthetic */ CancellableContinuation<Unit> $it;
            {
                this.$it = $it;
            }

            public final void invoke() {
                ((Continuation)this.$it).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        });
        it.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ ExecutionSession this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(Throwable it) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)ExecutionSession.access$getLifetime$p(this.this$0), (boolean)false, (int)1, null);
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

