/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.execution.messaging;

import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.execution.messaging.ExecutionNotifier;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "subscribe", "Lcom/intellij/util/messages/MessageBusConnection;", "configuration", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "listener", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createPublisher", "Companion", "ScopedExecutionNotifier", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionEventsBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionEventsBus.kt\ncom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class ExecutionEventsBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Topic<ExecutionNotifier> TOPIC;

    public ExecutionEventsBus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final MessageBusConnection subscribe(@NotNull MultiLaunchConfiguration configuration, @NotNull ExecutionNotifier listener2, @NotNull Lifetime lifetime) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        MessageBusConnection $this$subscribe_u24lambda_u240 = messageBusConnection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        boolean bl = false;
        $this$subscribe_u24lambda_u240.subscribe(TOPIC, (Object)new ScopedExecutionNotifier(configuration, listener2));
        return messageBusConnection;
    }

    @NotNull
    public final MessageBusConnection subscribe(@NotNull ExecutionNotifier listener2, @NotNull Lifetime lifetime) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        MessageBusConnection $this$subscribe_u24lambda_u241 = messageBusConnection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        boolean bl = false;
        $this$subscribe_u24lambda_u241.subscribe(TOPIC, (Object)listener2);
        return messageBusConnection;
    }

    @NotNull
    public final ExecutionNotifier createPublisher() {
        Object object = this.project.getMessageBus().syncPublisher(TOPIC);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        return (ExecutionNotifier)object;
    }

    static {
        Topic topic = Topic.create((String)"MultiLaunchExecutionNotifier.TOPIC", ExecutionNotifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nExecutionEventsBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionEventsBus.kt\ncom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,66:1\n30#2,2:67\n*S KotlinDebug\n*F\n+ 1 ExecutionEventsBus.kt\ncom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus$Companion\n*L\n17#1:67,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutionEventsBus getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ExecutionEventsBus> serviceClass$iv = ExecutionEventsBus.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ExecutionEventsBus)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\"\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionEventsBus$ScopedExecutionNotifier;", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;", "configuration", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "actualNotifier", "<init>", "(Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;)V", "start", "", "executables", "", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "cancel", "finish", "beforeExecute", "executable", "execute", "afterExecute", "afterSuccess", "afterCancel", "afterFail", "reason", "", "isApplicable", "", "eventConfiguration", "intellij.platform.execution.impl"})
    private static final class ScopedExecutionNotifier
    implements ExecutionNotifier {
        @NotNull
        private final MultiLaunchConfiguration configuration;
        @NotNull
        private final ExecutionNotifier actualNotifier;

        public ScopedExecutionNotifier(@NotNull MultiLaunchConfiguration configuration, @NotNull ExecutionNotifier actualNotifier) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)actualNotifier, (String)"actualNotifier");
            this.configuration = configuration;
            this.actualNotifier = actualNotifier;
        }

        @Override
        public void start(@NotNull MultiLaunchConfiguration configuration, @NotNull List<? extends Executable> executables) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(executables, (String)"executables");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.start(configuration, executables);
            }
        }

        @Override
        public void cancel(@NotNull MultiLaunchConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.cancel(configuration);
            }
        }

        @Override
        public void finish(@NotNull MultiLaunchConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.finish(configuration);
            }
        }

        @Override
        public void beforeExecute(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.beforeExecute(configuration, executable);
            }
        }

        @Override
        public void execute(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.execute(configuration, executable);
            }
        }

        @Override
        public void afterExecute(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.afterExecute(configuration, executable);
            }
        }

        @Override
        public void afterSuccess(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.afterSuccess(configuration, executable);
            }
        }

        @Override
        public void afterCancel(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.afterCancel(configuration, executable);
            }
        }

        @Override
        public void afterFail(@NotNull MultiLaunchConfiguration configuration, @NotNull Executable executable, @Nullable Throwable reason) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            if (this.isApplicable(configuration)) {
                this.actualNotifier.afterFail(configuration, executable, reason);
            }
        }

        private final boolean isApplicable(MultiLaunchConfiguration eventConfiguration) {
            return Intrinsics.areEqual((Object)eventConfiguration, (Object)this.configuration);
        }
    }
}

