/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.runToolbar.FixWidthSegmentedActionToolbarComponent;
import com.intellij.execution.runToolbar.PopupControllerComponent;
import com.intellij.execution.runToolbar.RTBarAction;
import com.intellij.execution.runToolbar.RunToolbarData;
import com.intellij.execution.runToolbar.RunToolbarMainSlotState;
import com.intellij.execution.runToolbar.RunToolbarMainWidgetComponent;
import com.intellij.execution.runToolbar.RunToolbarPopupController;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarProcessData;
import com.intellij.execution.runToolbar.RunToolbarSettings;
import com.intellij.execution.runToolbar.RunToolbarSlotManager;
import com.intellij.execution.runToolbar.RunWidgetWidthHelper;
import com.intellij.execution.runToolbar.data.RWActiveListener;
import com.intellij.execution.runToolbar.data.RWListenersController;
import com.intellij.execution.runToolbar.data.RWSlotManagerState;
import com.intellij.execution.runToolbar.data.RWStateListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.GotItTooltip;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0002\u0012\u0015\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J2\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0014J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020+H\u0014J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020+H\u0002J\u0010\u00100\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020+H\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\u001aH\u0014J\b\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u001aH\u0014J\u0010\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020+H\u0002J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020+H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarMainWidgetComponent;", "Lcom/intellij/execution/runToolbar/FixWidthSegmentedActionToolbarComponent;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getPresentation", "()Lcom/intellij/openapi/actionSystem/Presentation;", "logNeeded", "", "popupController", "Lcom/intellij/execution/runToolbar/RunToolbarPopupController;", "componentListener", "com/intellij/execution/runToolbar/RunToolbarMainWidgetComponent$componentListener$1", "Lcom/intellij/execution/runToolbar/RunToolbarMainWidgetComponent$componentListener$1;", "managerStateListener", "com/intellij/execution/runToolbar/RunToolbarMainWidgetComponent$managerStateListener$1", "Lcom/intellij/execution/runToolbar/RunToolbarMainWidgetComponent$managerStateListener$1;", "state", "Lcom/intellij/execution/runToolbar/RunToolbarMainSlotState;", "updateState", "", "traceState", "lastIds", "", "filteredIds", "ides", "value", "isOpened", "isOpened$intellij_platform_execution_impl", "()Z", "setOpened$intellij_platform_execution_impl", "(Z)V", "isSuitableAction", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "addNotify", "updateProject", "Lcom/intellij/openapi/project/Project;", "rwActiveListener", "Lcom/intellij/execution/runToolbar/data/RWActiveListener;", "checkGotIt", "project", "clearListeners", "showGotItTooltip", "updateWidthHandler", "rebuildPopupControllerComponent", "removeProject", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "add", "remove", "Companion", "intellij.platform.execution.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRunToolbarMainWidgetComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunToolbarMainWidgetComponent.kt\ncom/intellij/execution/runToolbar/RunToolbarMainWidgetComponent\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,241:1\n3919#2:242\n4434#2,2:243\n*S KotlinDebug\n*F\n+ 1 RunToolbarMainWidgetComponent.kt\ncom/intellij/execution/runToolbar/RunToolbarMainWidgetComponent\n*L\n177#1:242\n177#1:243,2\n*E\n"})
public final class RunToolbarMainWidgetComponent
extends FixWidthSegmentedActionToolbarComponent
implements UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Presentation presentation;
    @Nullable
    private RunToolbarPopupController popupController;
    @NotNull
    private final componentListener.1 componentListener;
    @NotNull
    private final managerStateListener.1 managerStateListener;
    @Nullable
    private RunToolbarMainSlotState state;
    private boolean isOpened;
    @Nullable
    private RWActiveListener rwActiveListener;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static Map<Project, Integer> counter;
    @NotNull
    private static final String GOT_IT_TOOLTIP_ID = "run.toolbar.gotIt";

    public RunToolbarMainWidgetComponent(@NotNull Presentation presentation, @NotNull String place, @NotNull ActionGroup group2) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        super(place, group2);
        this.presentation = presentation;
        this.componentListener = new ContainerListener(this){
            final /* synthetic */ RunToolbarMainWidgetComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentAdded(ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RunToolbarMainWidgetComponent.access$rebuildPopupControllerComponent(this.this$0);
            }

            public void componentRemoved(ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RunToolbarMainWidgetComponent.access$rebuildPopupControllerComponent(this.this$0);
            }
        };
        this.managerStateListener = new RWStateListener(this){
            final /* synthetic */ RunToolbarMainWidgetComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(RWSlotManagerState state) {
                Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
                RunToolbarMainWidgetComponent.access$updateState(this.this$0);
                RunToolbarMainWidgetComponent.access$updateActionsImmediately(this.this$0, true);
            }
        };
    }

    @NotNull
    public final Presentation getPresentation() {
        return this.presentation;
    }

    protected boolean logNeeded() {
        return RunToolbarProcess.Companion.getLogNeeded();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateState() {
        RunToolbarMainWidgetComponent runToolbarMainWidgetComponent = this;
        Project project = this.getProject();
        if (project != null) {
            RunToolbarMainSlotState value;
            void it;
            Project project2 = project;
            RunToolbarMainWidgetComponent runToolbarMainWidgetComponent2 = runToolbarMainWidgetComponent;
            boolean bl = false;
            RunToolbarSlotManager slotManager = RunToolbarSlotManager.Companion.getInstance((Project)it);
            v3 = value = (switch (WhenMappings.$EnumSwitchMapping$0[slotManager.getState$intellij_platform_execution_impl().ordinal()]) {
                case 1 -> RunToolbarMainSlotState.PROCESS;
                case 2, 3 -> {
                    if (this.isOpened) {
                        yield RunToolbarMainSlotState.CONFIGURATION;
                    }
                    yield RunToolbarMainSlotState.INFO;
                }
                case 4 -> RunToolbarMainSlotState.CONFIGURATION;
                case 5 -> {
                    if (this.isOpened) {
                        yield RunToolbarMainSlotState.PROCESS;
                    }
                    yield RunToolbarMainSlotState.INFO;
                }
                default -> throw new NoWhenBranchMatchedException();
            });
            runToolbarMainWidgetComponent = runToolbarMainWidgetComponent2;
        } else {
            v3 = runToolbarMainWidgetComponent.state = null;
        }
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("MAIN SLOT state updated: " + this.state + " RunToolbar");
        }
    }

    protected void traceState(@NotNull List<String> lastIds, @NotNull List<String> filteredIds, @NotNull List<String> ides) {
        Intrinsics.checkNotNullParameter(lastIds, (String)"lastIds");
        Intrinsics.checkNotNullParameter(filteredIds, (String)"filteredIds");
        Intrinsics.checkNotNullParameter(ides, (String)"ides");
        if (this.logNeeded() && !Intrinsics.areEqual(filteredIds, lastIds)) {
            LOG.info("MAIN SLOT state: " + this.state + " new filtered: " + filteredIds + "} visible: " + ides + " RunToolbar");
        }
    }

    public final boolean isOpened$intellij_platform_execution_impl() {
        return this.isOpened;
    }

    public final void setOpened$intellij_platform_execution_impl(boolean value) {
        if (this.isOpened == value) {
            return;
        }
        this.isOpened = value;
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("MAIN SLOT isOpened: " + this.isOpened + " RunToolbar");
        }
        this.updateState();
        if (RunToolbarProcess.Companion.isExperimentalUpdatingEnabled()) {
            this.forceUpdate();
        }
    }

    protected boolean isSuitableAction(@NotNull AnAction action) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        RunToolbarMainSlotState runToolbarMainSlotState = this.state;
        if (runToolbarMainSlotState != null) {
            RunToolbarMainSlotState it = runToolbarMainSlotState;
            boolean bl2 = false;
            bl = action instanceof RTBarAction ? ((RTBarAction)action).checkMainSlotVisibility(it) : true;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void addNotify() {
        block0: {
            super.addNotify();
            Project project = this.getProject();
            if (project == null) break block0;
            Project it = project;
            boolean bl = false;
            RunWidgetWidthHelper.Companion.getInstance(it).setRunConfig(RunToolbarSettings.Companion.getInstance(it).getRunConfigWidth());
            this.checkGotIt(it);
        }
    }

    @Override
    protected void updateProject(@NotNull Project value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super.updateProject(value);
            Project project = this.getProject();
            if (project == null) break block0;
            Project it = project;
            boolean bl = false;
            this.add(it);
        }
    }

    private final void checkGotIt(Project project) {
        RunToolbarSlotManager instance = RunToolbarSlotManager.Companion.getInstance(project);
        if (instance.getInitialized$intellij_platform_execution_impl()) {
            this.showGotItTooltip();
        } else {
            RWActiveListener lst2 = new RWActiveListener(instance, this, project){
                final /* synthetic */ RunToolbarSlotManager $instance;
                final /* synthetic */ RunToolbarMainWidgetComponent this$0;
                final /* synthetic */ Project $project;
                {
                    this.$instance = $instance;
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                public void initialize() {
                    if (!this.$instance.getActive$intellij_platform_execution_impl()) {
                        return;
                    }
                    RunToolbarMainWidgetComponent.access$showGotItTooltip(this.this$0);
                    RunToolbarMainWidgetComponent.access$clearListeners(this.this$0, this.$project);
                }
            };
            this.rwActiveListener = lst2;
            instance.getActiveListener$intellij_platform_execution_impl().addListener(lst2);
        }
    }

    private final void clearListeners(Project project) {
        block0: {
            RWActiveListener rWActiveListener = this.rwActiveListener;
            if (rWActiveListener == null) break block0;
            RWActiveListener it = rWActiveListener;
            boolean bl = false;
            RunToolbarSlotManager.Companion.getInstance(project).getActiveListener$intellij_platform_execution_impl().removeListener(it);
        }
    }

    private final void showGotItTooltip() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        int inclusionState = propertiesComponent.getInt("ide.widget.toolbar.first.inclusion", 0);
        if (inclusionState != 1) {
            return;
        }
        String string = ExecutionBundle.message((String)"run.toolbar.gotIt.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GotItTooltip gotItTooltip = new GotItTooltip(GOT_IT_TOOLTIP_ID, string, (Disposable)this.getProject());
        String string2 = ExecutionBundle.message((String)"run.toolbar.gotIt.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GotItTooltip gotItTooltip2 = gotItTooltip.withHeader(string2);
        if (!gotItTooltip2.canShow()) {
            propertiesComponent.setValue("ide.widget.toolbar.first.inclusion", inclusionState + 1, 0);
            return;
        }
        gotItTooltip2.show((JComponent)((Object)this), RunToolbarMainWidgetComponent::showGotItTooltip$lambda$0);
    }

    @Override
    protected void updateWidthHandler() {
        block0: {
            super.updateWidthHandler();
            Project project = this.getProject();
            if (project == null) break block0;
            Project it = project;
            boolean bl = false;
            RunToolbarSettings.Companion.getInstance(it).setRunConfigWidth(RunWidgetWidthHelper.Companion.getInstance(it).getRunConfig());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildPopupControllerComponent() {
        block1: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            RunToolbarPopupController runToolbarPopupController = this.popupController;
            if (runToolbarPopupController == null) break block1;
            RunToolbarPopupController it = runToolbarPopupController;
            boolean bl = false;
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] objectArray = componentArray;
            RunToolbarPopupController runToolbarPopupController2 = it;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Component it2 = (Component)element$iv$iv;
                boolean bl2 = false;
                if (!(it2 instanceof PopupControllerComponent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            runToolbarPopupController2.updateControllerComponents$intellij_platform_execution_impl(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        }
    }

    @Override
    protected void removeProject() {
        Project project = this.getProject();
        if (project != null) {
            Project it = project;
            boolean bl = false;
            DataManager.removeDataProvider((JComponent)this.getComponent());
            this.clearListeners(it);
            this.remove(it);
        }
        super.removeProject();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        RunToolbarPopupController runToolbarPopupController = this.popupController;
        if (runToolbarPopupController == null || (runToolbarPopupController = runToolbarPopupController.getProject()) == null) {
            return;
        }
        RunToolbarPopupController project = runToolbarPopupController;
        RunToolbarSlotManager slotManager = RunToolbarSlotManager.Companion.getInstance((Project)project);
        sink.set(RunToolbarProcessData.RW_SLOT, (Object)slotManager.getMainSlotData$intellij_platform_execution_impl().getId());
        sink.set(RunToolbarData.RUN_TOOLBAR_DATA_KEY, (Object)slotManager.getMainSlotData$intellij_platform_execution_impl());
        sink.set(RunToolbarData.RUN_TOOLBAR_POPUP_STATE_KEY, (Object)this.isOpened);
        sink.set(RunToolbarData.RUN_TOOLBAR_MAIN_STATE, (Object)this.state);
    }

    private final void add(Project project) {
        this.popupController = new RunToolbarPopupController(project, this);
        int value = ((Number)counter.getOrDefault(project, 0)).intValue() + 1;
        counter.put(project, value);
        RunToolbarSlotManager slotManager = RunToolbarSlotManager.Companion.getInstance(project);
        if (!RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("add value " + value + " RunToolbar");
        }
        if (value == 1) {
            slotManager.getStateListeners$intellij_platform_execution_impl().addListener(this.managerStateListener);
            slotManager.setActive$intellij_platform_execution_impl(true);
        }
        this.rebuildPopupControllerComponent();
        this.addContainerListener(this.componentListener);
    }

    private final void remove(Project project) {
        RunToolbarSlotManager slotManager = !project.isDisposed() ? RunToolbarSlotManager.Companion.getInstance(project) : null;
        Object object = slotManager;
        if (object != null && (object = ((RunToolbarSlotManager)object).getStateListeners$intellij_platform_execution_impl()) != null) {
            ((RWListenersController)object).removeListener(this.managerStateListener);
        }
        Integer n = counter.get(project);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            int value = Math.max(it - 1, 0);
            counter.put(project, value);
            if (value == 0) {
                RunToolbarSlotManager runToolbarSlotManager = slotManager;
                if (runToolbarSlotManager != null) {
                    runToolbarSlotManager.setActive$intellij_platform_execution_impl(false);
                }
                counter.remove(project);
            }
        }
        this.removeContainerListener(this.componentListener);
        RunToolbarPopupController runToolbarPopupController = this.popupController;
        if (runToolbarPopupController != null) {
            RunToolbarPopupController it = runToolbarPopupController;
            boolean bl = false;
            if (!Disposer.isDisposed((Disposable)it)) {
                Disposer.dispose((Disposable)it);
            }
        }
        this.popupController = null;
        this.state = null;
    }

    private static final Point showGotItTooltip$lambda$0(Component c, Balloon b) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new Point(c.getWidth() / 3, c.getHeight());
    }

    public static final /* synthetic */ void access$showGotItTooltip(RunToolbarMainWidgetComponent $this) {
        $this.showGotItTooltip();
    }

    public static final /* synthetic */ void access$clearListeners(RunToolbarMainWidgetComponent $this, Project project) {
        $this.clearListeners(project);
    }

    public static final /* synthetic */ void access$rebuildPopupControllerComponent(RunToolbarMainWidgetComponent $this) {
        $this.rebuildPopupControllerComponent();
    }

    public static final /* synthetic */ void access$updateState(RunToolbarMainWidgetComponent $this) {
        $this.updateState();
    }

    public static final /* synthetic */ void access$updateActionsImmediately(RunToolbarMainWidgetComponent $this, boolean includeInvisible) {
        $this.updateActionsImmediately(includeInvisible);
    }

    static {
        Logger logger = Logger.getInstance(RunToolbarMainWidgetComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        counter = new LinkedHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarMainWidgetComponent$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "counter", "", "Lcom/intellij/openapi/project/Project;", "", "GOT_IT_TOOLTIP_ID", "", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RWSlotManagerState.values().length];
            try {
                nArray[RWSlotManagerState.SINGLE_MAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RWSlotManagerState.SINGLE_PLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RWSlotManagerState.MULTIPLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RWSlotManagerState.INACTIVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RWSlotManagerState.MULTIPLE_WITH_MAIN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

