/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar.components;

import com.intellij.execution.runToolbar.components.ComboBoxArrowIcon;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/runToolbar/components/ComboBoxArrowComponent;", "", "<init>", "()V", "getView", "Ljavax/swing/JComponent;", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class ComboBoxArrowComponent {
    @NotNull
    private final JLabel label = new JLabel(){
        private final ComboBoxArrowIcon defaultIcon;
        {
            this.defaultIcon = new ComboBoxArrowIcon();
            this.updateIcon();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateIcon();
        }

        private final void updateIcon() {
            Icon icon;
            if (UIUtil.isUnderWin10LookAndFeel()) {
                if (this.isEnabled()) {
                    icon = UIManager.getIcon("ComboBoxButton.arrowIcon");
                    if (icon == null) {
                        Icon icon2 = AllIcons.General.ArrowDown;
                        icon = icon2;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ArrowDown");
                    }
                } else {
                    icon = UIManager.getIcon("ComboBoxButton.arrowIconDisabled");
                    if (icon == null) {
                        Icon icon3 = AllIcons.General.ArrowDown;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ArrowDown");
                        icon = IconLoader.getDisabledIcon((Icon)icon3);
                    }
                }
            } else {
                icon = this.defaultIcon;
            }
            this.setIcon(icon);
        }
    };

    @NotNull
    public final JComponent getView() {
        return this.label;
    }

    @NotNull
    public final JLabel getLabel() {
        return this.label;
    }
}

