/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.runners.BackendRunnerAndConfigurationSettingsProxy;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.RunnerAndConfigurationSettingsProxy;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\r\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/runners/BackendExecutionEnvironmentProxy;", "Lcom/intellij/execution/runners/ExecutionEnvironmentProxy;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "isShowInDashboard", "", "getContentDescriptorToolWindowId", "", "getRunProfileName", "Lcom/intellij/openapi/util/NlsSafe;", "getRunConfigurationTypeId", "getIcon", "Ljavax/swing/Icon;", "getRerunIcon", "getRunnerAndConfigurationSettingsProxy", "Lcom/intellij/execution/runners/RunnerAndConfigurationSettingsProxy;", "getContentToReuse", "Lcom/intellij/execution/ui/RunContentDescriptor;", "isStarting", "isStartingFlow", "Lkotlinx/coroutines/flow/Flow;", "performRestart", "", "getExecutionEnvironment", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class BackendExecutionEnvironmentProxy
implements ExecutionEnvironmentProxy {
    @NotNull
    private final ExecutionEnvironment environment;

    public BackendExecutionEnvironmentProxy(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
    }

    @Override
    public boolean isShowInDashboard() {
        RunProfile runProfile = this.environment.getRunProfile();
        Object object = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        if (object == null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.environment.getRunnerAndConfigurationSettings();
            object = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            if (object == null) {
                return false;
            }
        }
        RunConfiguration configuration = object;
        return RunDashboardManager.getInstance((Project)configuration.getProject()).isShowInDashboard(configuration);
    }

    @Override
    @Nullable
    public String getContentDescriptorToolWindowId() {
        return RunContentManager.getInstance((Project)this.environment.getProject()).getContentDescriptorToolWindowId(this.environment);
    }

    @Override
    @NotNull
    public String getRunProfileName() {
        String string = this.environment.getRunProfile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public String getRunConfigurationTypeId() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings;
        RunProfile runProfile = this.environment.getRunProfile();
        Object object = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        if ((object == null || (object = object.getType()) == null || (object = object.getId()) == null) && ((runnerAndConfigurationSettings = this.environment.getRunnerAndConfigurationSettings()) != null && (runnerAndConfigurationSettings = runnerAndConfigurationSettings.getConfiguration()) != null && (runnerAndConfigurationSettings = runnerAndConfigurationSettings.getType()) != null ? runnerAndConfigurationSettings.getId() : (object = null)) == null) {
            object = "FakeMissingTypeIdInEnvironment";
        }
        return object;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.environment.getExecutor().getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
        return icon;
    }

    @Override
    @NotNull
    public Icon getRerunIcon() {
        Icon icon = this.environment.getExecutor().getRerunIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getRerunIcon(...)");
        return icon;
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettingsProxy getRunnerAndConfigurationSettingsProxy() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.environment.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
        return new BackendRunnerAndConfigurationSettingsProxy(runnerAndConfigurationSettings2);
    }

    @Override
    @Nullable
    public RunContentDescriptor getContentToReuse() {
        return this.environment.getContentToReuse();
    }

    @Override
    public boolean isStarting() {
        Project project = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ExecutionManager.Companion.getInstance(project).isStarting(this.environment);
    }

    @Override
    @NotNull
    public Flow<Boolean> isStartingFlow() {
        Project project = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ExecutionManager.Companion.getInstance(project).isStartingFlow(this.environment);
    }

    @Override
    public void performRestart() {
        ExecutionUtil.restart((ExecutionEnvironment)this.environment);
    }

    @Override
    @NotNull
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }
}

