/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.DebuggableRunProfileState;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/runners/DefaultRunProgramRunner;", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "getRunnerId", "", "execute", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "intellij.platform.execution.impl"})
final class DefaultRunProgramRunner
implements ProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "defaultRunRunner";
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = environment.getState();
        if (runProfileState == null) {
            return;
        }
        RunProfileState state = runProfileState;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ExecutionManager.Companion.getInstance(project).startRunProfile(environment, () -> DefaultRunProgramRunner.execute$lambda$0(state, environment, this));
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)"Run", (Object)executorId) && !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }

    private static final Promise execute$lambda$0(RunProfileState $state, ExecutionEnvironment $environment, DefaultRunProgramRunner this$0) {
        Promise promise;
        FileDocumentManager.getInstance().saveAllDocuments();
        if ($state instanceof DebuggableRunProfileState) {
            Promise promise2 = ((DebuggableRunProfileState)$state).execute(-1).then(arg_0 -> DefaultRunProgramRunner.execute$lambda$0$1(arg_0 -> DefaultRunProgramRunner.execute$lambda$0$0($environment, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise2);
            promise = promise2;
        } else {
            promise = Promises.resolvedPromise((Object)DefaultProgramRunnerKt.showRunContent((ExecutionResult)$state.execute($environment.getExecutor(), (ProgramRunner)this$0), (ExecutionEnvironment)$environment));
        }
        return promise;
    }

    private static final RunContentDescriptor execute$lambda$0$0(ExecutionEnvironment $environment, ExecutionResult it) {
        RunContentDescriptor runContentDescriptor2;
        ExecutionResult executionResult = it;
        if (executionResult != null) {
            ExecutionResult it2 = executionResult;
            boolean bl = false;
            runContentDescriptor2 = new RunContentBuilder(it2, $environment).showRunContent($environment.getContentToReuse());
        } else {
            runContentDescriptor2 = null;
        }
        return runContentDescriptor2;
    }

    private static final RunContentDescriptor execute$lambda$0$1(Function1 $tmp0, Object p0) {
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }
}

