/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationManager;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.NewRunConfigurationPopup;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.startup.ProjectStartupRunnerKt;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.execution.startup.ProjectStartupTasksTableModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectStartupConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JBTable myTable;
    private ToolbarDecorator myDecorator;
    private ProjectStartupTasksTableModel myModel;

    ProjectStartupConfigurable(@NotNull Project project) {
        if (project == null) {
            ProjectStartupConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        return "preferences.startup.tasks";
    }

    @Nls
    public String getDisplayName() {
        return ExecutionBundle.message((String)"configurable.ProjectStartupConfigurable.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.settings.startup.tasks";
    }

    @NotNull
    public JComponent createComponent() {
        this.myModel = new ProjectStartupTasksTableModel();
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.setShowGrid(false);
        this.myTable.getEmptyText().setText(ExecutionBundle.message((String)"settings.project.startup.add.run.configurations.with.the.button", (Object[])new Object[0]));
        TableSpeedSearch.installOn((JTable)this.myTable);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        DumbAwareAction.create(e -> {
            int row = this.myTable.getSelectedRow();
            if (row >= 0 && this.myModel.isCellEditable(row, 1)) {
                this.myModel.setValueAt(!Boolean.TRUE.equals(this.myTable.getValueAt(row, 1)), row, 1);
            }
        }).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{32}), (JComponent)this.myTable);
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ProjectStartupConfigurable.this.editRunConfiguration();
                }
            }
        });
        this.installRenderers();
        this.myDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(this::selectAndAddConfiguration).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.editRunConfiguration();
            }
        }).setEditActionUpdater(e -> this.myTable.getSelectedRow() >= 0).disableUpAction().disableDownAction();
        JPanel tasksPanel = this.myDecorator.createPanel();
        JLabel label2 = new JLabel(ExecutionBundle.message((String)"settings.project.startup.run.tasks.and.tools.via.run.configurations", (Object[])new Object[0]));
        label2.setForeground(NamedColorUtil.getInactiveTextColor());
        label2.setHorizontalAlignment(4);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)new JLabel(ExecutionBundle.message((String)"settings.project.startup.to.be.started.on.project.opening", (Object[])new Object[0])), "West");
        wrapper.add((Component)label2, "East");
        wrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)wrapper, "North");
        main.add((Component)tasksPanel, "Center");
        JPanel jPanel = main;
        if (jPanel == null) {
            ProjectStartupConfigurable.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editRunConfiguration() {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        RunnerAndConfigurationSettings selected = this.myModel.getAllConfigurations().get(row);
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        RunnerAndConfigurationSettings was = runManager.getSelectedConfiguration();
        try {
            runManager.setSelectedConfiguration(selected);
            new EditConfigurationsDialog(this.myProject).showAndGet();
        }
        finally {
            runManager.setSelectedConfiguration(was);
        }
        this.myModel.fireTableDataChanged();
        this.refreshDataUpdateSelection(selected);
    }

    private void refreshDataUpdateSelection(RunnerAndConfigurationSettings settings) {
        if (this.myTable.isEmpty()) {
            return;
        }
        this.myModel.reValidateConfigurations((Processor<? super RunnerAndConfigurationSettings>)new Processor<RunnerAndConfigurationSettings>(){
            private final RunManagerImpl runManager;
            {
                this.runManager = RunManagerImpl.getInstanceImpl(ProjectStartupConfigurable.this.myProject);
            }

            public boolean process(RunnerAndConfigurationSettings settings) {
                return this.runManager.getConfigurationById(settings.getUniqueID()) != null;
            }
        });
        if (settings != null) {
            List<RunnerAndConfigurationSettings> configurations = this.myModel.getAllConfigurations();
            for (int i = 0; i < configurations.size(); ++i) {
                RunnerAndConfigurationSettings configuration = configurations.get(i);
                if (configuration != settings) continue;
                TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
                return;
            }
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{0});
        this.myTable.getSelectionModel().setLeadSelectionIndex(0);
    }

    private ChooseRunConfigurationPopup.ItemWrapper<Void> createNewWrapper(final AnActionButton button) {
        return new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return IconUtil.getAddIcon();
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]));
            }

            @Override
            public void perform(@NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (executor == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    4.$$$reportNull$$$0(2);
                }
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
                List typesToShow = ContainerUtil.filter((Collection)ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), configurationType -> {
                    ConfigurationFactory factory = runManager.getFactory((ConfigurationType)configurationType, null);
                    return factory != null && ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runManager.getConfigurationTemplate(factory).getConfiguration()) != null;
                });
                JBPopup popup = NewRunConfigurationPopup.createAddPopup(project, typesToShow, "", (Consumer<? super ConfigurationFactory>)((Consumer)factory -> ApplicationManager.getApplication().invokeLater(() -> {
                    EditConfigurationsDialog dialog = new EditConfigurationsDialog(project, (ConfigurationFactory)factory);
                    if (dialog.showAndGet()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                            if (configuration != null) {
                                ProjectStartupConfigurable.this.addConfiguration(configuration);
                            }
                        }, project.getDisposed());
                    }
                }, project.getDisposed())), null, null, false);
                ProjectStartupConfigurable.showPopup(button, popup);
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/startup/ProjectStartupConfigurable$4";
                objectArray[2] = "perform";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void addConfiguration(RunnerAndConfigurationSettings configuration) {
        if (!ProjectStartupRunnerKt.canBeRun(configuration)) {
            String message = ExecutionBundle.message((String)"settings.project.startup.warning", (Object[])new Object[]{configuration.getName()});
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setHideOnClickOutside(true).setFadeoutTime(3000L).setCloseButtonEnabled(true).createBalloon();
            RelativePoint rp = new RelativePoint((Component)this.myDecorator.getActionsPanel(), new Point(5, 5));
            balloon.show(rp, Balloon.Position.atLeft);
            return;
        }
        this.myModel.addConfiguration(configuration);
        this.refreshDataUpdateSelection(configuration);
    }

    private void selectAndAddConfiguration(AnActionButton button) {
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ArrayList wrappers = new ArrayList();
        wrappers.add(this.createNewWrapper(button));
        List<ChooseRunConfigurationPopup.ItemWrapper<?>> allSettings = ChooseRunConfigurationManager.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        }, DataManager.getInstance().getDataContext((Component)this.myTable), false);
        HashSet<RunnerAndConfigurationSettings> existing = new HashSet<RunnerAndConfigurationSettings>(this.myModel.getAllConfigurations());
        for (ChooseRunConfigurationPopup.ItemWrapper<?> setting2 : allSettings) {
            RunnerAndConfigurationSettings settings;
            Object obj = setting2.getValue();
            if (!(obj instanceof RunnerAndConfigurationSettings) || (settings = (RunnerAndConfigurationSettings)obj).isTemporary() || !ProjectStartupRunnerKt.canBeRun(settings) || existing.contains(settings)) continue;
            wrappers.add(setting2);
        }
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(wrappers).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setIcon(value.getIcon());
            label2.setText(value.getText());
        })).setItemChosenCallback(at -> {
            Object patt0$temp = at.getValue();
            if (patt0$temp instanceof RunnerAndConfigurationSettings) {
                RunnerAndConfigurationSettings added = (RunnerAndConfigurationSettings)patt0$temp;
                this.addConfiguration(added);
            } else {
                at.perform(this.myProject, executor, button.getDataContext());
            }
        }).createPopup();
        ProjectStartupConfigurable.showPopup(button, popup);
    }

    private static void showPopup(AnActionButton button, JBPopup popup) {
        popup.show(button.getPreferredPopupPoint());
    }

    public boolean isModified() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        HashSet<RunnerAndConfigurationSettings> shared = new HashSet<RunnerAndConfigurationSettings>(projectStartupTaskManager.getSharedConfigurations());
        ArrayList<RunnerAndConfigurationSettings> list = new ArrayList<RunnerAndConfigurationSettings>(shared);
        list.addAll(projectStartupTaskManager.getLocalConfigurations());
        list.sort(ProjectStartupTasksTableModel.RunnerAndConfigurationSettingsComparator.getInstance());
        if (!Comparing.equal(list, this.myModel.getAllConfigurations())) {
            return true;
        }
        return !Comparing.equal(shared, this.myModel.getSharedConfigurations());
    }

    public void apply() {
        ArrayList<RunnerAndConfigurationSettings> shared = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> local = new ArrayList<RunnerAndConfigurationSettings>();
        Set<RunnerAndConfigurationSettings> sharedSet = this.myModel.getSharedConfigurations();
        List<RunnerAndConfigurationSettings> allConfigurations = this.myModel.getAllConfigurations();
        for (RunnerAndConfigurationSettings configuration : allConfigurations) {
            if (sharedSet.contains(configuration)) {
                shared.add(configuration);
                continue;
            }
            local.add(configuration);
        }
        ProjectStartupTaskManager.getInstance(this.myProject).setStartupConfigurations(shared, local);
    }

    public void reset() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        this.myModel.setData(projectStartupTaskManager.getSharedConfigurations(), projectStartupTaskManager.getLocalConfigurations());
        this.refreshDataUpdateSelection(null);
    }

    private void installRenderers() {
        TableColumn checkboxColumn = this.myTable.getColumnModel().getColumn(1);
        String header = checkboxColumn.getHeaderValue().toString();
        FontMetrics fm = this.myTable.getFontMetrics(this.myTable.getTableHeader().getFont());
        int width = -new JBCheckBox().getPreferredSize().width + fm.stringWidth(header + "ww");
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn, (int)width);
        checkboxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        nameColumn.setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    6.$$$reportNull$$$0(0);
                }
                RunnerAndConfigurationSettings settings = ProjectStartupConfigurable.this.myModel.getAllConfigurations().get(row);
                this.setIcon(settings.getConfiguration().getIcon());
                this.append(settings.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/execution/startup/ProjectStartupConfigurable$6", "customizeCellRenderer"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/startup/ProjectStartupConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static final class ProjectStartupConfigurableProvider
    extends ConfigurableProvider {
        private final Project myProject;

        ProjectStartupConfigurableProvider(@NotNull Project project) {
            if (project == null) {
                ProjectStartupConfigurableProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public Configurable createConfigurable() {
            return new ProjectStartupConfigurable(this.myProject);
        }

        public boolean canCreateConfigurable() {
            return !PlatformUtils.isDataGrip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$ProjectStartupConfigurableProvider", "<init>"));
        }
    }
}

