/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupConfigurationBase;
import com.intellij.execution.startup.ProjectStartupLocalConfiguration;
import com.intellij.execution.startup.ProjectStartupSharedConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
final class ProjectStartupTaskManager {
    public static final String PREFIX = "Project Startup Tasks: ";
    private final Project myProject;
    private final ProjectStartupSharedConfiguration myShared;
    private final ProjectStartupLocalConfiguration myLocal;

    private void verifyState() {
        if (this.myShared.isEmpty()) {
            return;
        }
        Collection<RunnerAndConfigurationSettings> sharedConfigurations = this.getSharedConfigurations();
        ArrayList<RunnerAndConfigurationSettings> canNotBeShared = new ArrayList<RunnerAndConfigurationSettings>();
        Iterator<RunnerAndConfigurationSettings> iterator = sharedConfigurations.iterator();
        while (iterator.hasNext()) {
            RunnerAndConfigurationSettings configuration = iterator.next();
            if (configuration.isShared()) continue;
            iterator.remove();
            canNotBeShared.add(configuration);
        }
        if (!canNotBeShared.isEmpty()) {
            canNotBeShared.addAll(this.getLocalConfigurations());
            this.setStartupConfigurations(sharedConfigurations, canNotBeShared);
        }
    }

    ProjectStartupTaskManager(@NotNull Project project) {
        if (project == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myShared = (ProjectStartupSharedConfiguration)this.myProject.getService(ProjectStartupSharedConfiguration.class);
        this.myLocal = (ProjectStartupLocalConfiguration)this.myProject.getService(ProjectStartupLocalConfiguration.class);
        this.verifyState();
    }

    private Collection<RunnerAndConfigurationSettings> getConfigurations(ProjectStartupConfigurationBase configuration) {
        if (configuration.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RunnerAndConfigurationSettings> result2 = new ArrayList<RunnerAndConfigurationSettings>();
        List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list = configuration.getList();
        RunManagerImpl runManager = (RunManagerImpl)RunManager.getInstance((Project)this.myProject);
        for (ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor : list) {
            RunnerAndConfigurationSettings settings = runManager.getConfigurationById(descriptor.getId());
            if (settings != null && settings.getName().equals(descriptor.getName())) {
                result2.add(settings);
                continue;
            }
            ProjectStartupTaskManager.getNotificationGroup().createNotification(ExecutionBundle.message((String)"0.run.configuration.1.not.found.removed.from.list", (Object[])new Object[]{PREFIX, descriptor.getName()}), MessageType.WARNING).notify(this.myProject);
        }
        return result2;
    }

    public void checkOnChange(RunnerAndConfigurationSettings settings) {
        if (settings.isShared()) {
            return;
        }
        Collection<RunnerAndConfigurationSettings> sharedConfigurations = this.getSharedConfigurations();
        if (sharedConfigurations.remove(settings)) {
            ArrayList<RunnerAndConfigurationSettings> localConfigurations = new ArrayList<RunnerAndConfigurationSettings>(this.getLocalConfigurations());
            localConfigurations.add(settings);
            this.setStartupConfigurations(sharedConfigurations, localConfigurations);
            ProjectStartupTaskManager.getNotificationGroup().createNotification(ExecutionBundle.message((String)"0.configuration.was.made.not.shared", (Object[])new Object[]{PREFIX, settings.getName()}), MessageType.WARNING).notify(this.myProject);
        }
    }

    public Collection<RunnerAndConfigurationSettings> getSharedConfigurations() {
        return this.getConfigurations(this.myShared);
    }

    public Collection<RunnerAndConfigurationSettings> getLocalConfigurations() {
        return this.getConfigurations(this.myLocal);
    }

    public void setStartupConfigurations(@NotNull Collection<? extends RunnerAndConfigurationSettings> shared, @NotNull Collection<? extends RunnerAndConfigurationSettings> local) {
        if (shared == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(1);
        }
        if (local == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(2);
        }
        this.myShared.setConfigurations(shared);
        this.myLocal.setConfigurations(local);
    }

    public void rename(String oldId, RunnerAndConfigurationSettings settings) {
        if (this.myShared.rename(oldId, settings)) {
            return;
        }
        this.myLocal.rename(oldId, settings);
    }

    public void delete(String id) {
        if (this.myShared.deleteConfiguration(id)) {
            return;
        }
        this.myLocal.deleteConfiguration(id);
    }

    static NotificationGroup getNotificationGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("Project Startup Tasks Messages");
    }

    public boolean isEmpty() {
        return this.myShared.isEmpty() && this.myLocal.isEmpty();
    }

    @NotNull
    public static ProjectStartupTaskManager getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(3);
        }
        ProjectStartupTaskManager projectStartupTaskManager = (ProjectStartupTaskManager)project.getService(ProjectStartupTaskManager.class);
        if (projectStartupTaskManager == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(4);
        }
        return projectStartupTaskManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/startup/ProjectStartupTaskManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupTaskManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStartupConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

