/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehavior;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JList;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/ui/AllRunConfigurationsToggle;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getBehavior", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehavior;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public class AllRunConfigurationsToggle
extends DumbAwareToggleAction
implements ActionRemoteBehaviorSpecification {
    public AllRunConfigurationsToggle() {
        this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Always);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    public ActionRemoteBehavior getBehavior() {
        return ActionRemoteBehavior.FrontendThenBackend;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        return RunConfigurationStartHistory.Companion.getInstance(project).getState().getAllConfigurationsExpanded();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        JList jList;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        RunConfigurationStartHistory.Companion.getInstance(project).getState().setAllConfigurationsExpanded(state);
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent == null) {
            return;
        }
        InputEvent inputEvent2 = inputEvent;
        Object object = inputEvent2.getSource();
        JList jList2 = jList = object instanceof JList ? (JList)object : null;
        ListModel listModel = jList2 != null ? jList2.getModel() : null;
        ListPopupModel listPopupModel = listModel instanceof ListPopupModel ? (ListPopupModel)listModel : null;
        if (listPopupModel == null) {
            return;
        }
        ListPopupModel listPopupModel2 = listPopupModel;
        listPopupModel2.refilter();
        PopupUtil.getPopupContainerFor((Component)jList).pack(true, true);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            AllRunConfigurationsToggle $this$update_u24lambda_u240 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        super.update(e);
        e.getPresentation().setEnabledAndVisible(true);
        e.getPresentation().setIcon(this.isSelected(e) ? AllIcons.General.ChevronDown : AllIcons.General.ChevronRight);
        if (!Intrinsics.areEqual((Object)e.getPresentation().getText(), (Object)this.getTemplatePresentation().getText())) {
            return;
        }
        int count = RunManager.Companion.getInstance(project2).getAllSettings().size();
        String string = ColorUtil.toHex((Color)JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
        String textColor = string;
        Object[] objectArray = new Object[]{"<a style=\"color:#" + textColor + ";\">" + count + "</a>"};
        String string2 = ExecutionBundle.message((String)"run.toolbar.widget.all.configurations", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        e.getPresentation().setText("<html>" + message + "</html>");
    }
}

