/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.ProcessCloseConfirmation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.InstantShutdown;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.concurrency.Semaphore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseContentCloseListener
implements VetoableProjectManagerListener,
ContentManagerListener,
Disposable {
    private static final Key<Boolean> PROJECT_DISPOSING = Key.create((String)"Project disposing is in progress");
    private static final Logger LOG = Logger.getInstance(BaseContentCloseListener.class);
    private Content myContent;
    protected final Project myProject;

    public BaseContentCloseListener(@NotNull Content content, @NotNull Project project) {
        if (content == null) {
            BaseContentCloseListener.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseContentCloseListener.$$$reportNull$$$0(1);
        }
        this(content, project, (Disposable)project);
    }

    public BaseContentCloseListener(@NotNull Content content, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (content == null) {
            BaseContentCloseListener.$$$reportNull$$$0(2);
        }
        if (project == null) {
            BaseContentCloseListener.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            BaseContentCloseListener.$$$reportNull$$$0(4);
        }
        this.myContent = content;
        this.myProject = project;
        ContentManager contentManager = content.getManager();
        if (contentManager != null) {
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }
        content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("contentManager".equals(evt.getPropertyName())) {
                    ContentManager oldValue = (ContentManager)evt.getOldValue();
                    ContentManager newValue = (ContentManager)evt.getNewValue();
                    if (oldValue != null) {
                        oldValue.removeContentManagerListener((ContentManagerListener)BaseContentCloseListener.this);
                    }
                    if (newValue != null) {
                        newValue.addContentManagerListener((ContentManagerListener)BaseContentCloseListener.this);
                    }
                }
            }
        });
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void contentRemoved(@NotNull ContentManagerEvent event) {
        Content content;
        if (event == null) {
            BaseContentCloseListener.$$$reportNull$$$0(5);
        }
        if ((content = event.getContent()) == this.myContent && !((Boolean)Content.TEMPORARY_REMOVED_KEY.get((UserDataHolder)content, (Object)false)).booleanValue()) {
            Disposer.dispose((Disposable)this);
        }
    }

    public void dispose() {
        if (this.myContent == null) {
            return;
        }
        Content content = this.myContent;
        this.myContent = null;
        ContentManager contentManager = content.getManager();
        if (contentManager != null) {
            contentManager.removeContentManagerListener((ContentManagerListener)this);
        }
        ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)this);
        this.disposeContent(content);
    }

    protected abstract void disposeContent(@NotNull Content var1);

    public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
        boolean canClose;
        if (event == null) {
            BaseContentCloseListener.$$$reportNull$$$0(6);
        }
        if (event.getContent() == this.myContent && !(canClose = this.closeQuery(this.myContent, Boolean.TRUE.equals(this.myProject.getUserData(PROJECT_DISPOSING))))) {
            event.consume();
        }
    }

    public void projectClosed(@NotNull Project project) {
        if (project == null) {
            BaseContentCloseListener.$$$reportNull$$$0(7);
        }
        if (this.myContent == null || project != this.myProject) {
            return;
        }
        ContentManager contentManager = this.myContent.getManager();
        if (contentManager != null) {
            contentManager.removeContent(this.myContent, true);
        }
        Disposer.dispose((Disposable)this);
    }

    public void projectClosing(@NotNull Project project) {
        if (project == null) {
            BaseContentCloseListener.$$$reportNull$$$0(8);
        }
        project.putUserData(PROJECT_DISPOSING, (Object)true);
    }

    public boolean canClose(@NotNull Project project) {
        if (project == null) {
            BaseContentCloseListener.$$$reportNull$$$0(9);
        }
        if (this.myContent == null || project != this.myProject) {
            return true;
        }
        boolean canClose = this.closeQuery(this.myContent, true);
        if (canClose && this.myContent != null) {
            Objects.requireNonNull(this.myContent.getManager()).removeContent(this.myContent, true);
            this.myContent = null;
        }
        return canClose;
    }

    protected boolean askUserAndWait(@NotNull ProcessHandler processHandler, @NotNull String sessionName, @NotNull WaitForProcessTask task2) {
        Application application;
        if (processHandler == null) {
            BaseContentCloseListener.$$$reportNull$$$0(10);
        }
        if (sessionName == null) {
            BaseContentCloseListener.$$$reportNull$$$0(11);
        }
        if (task2 == null) {
            BaseContentCloseListener.$$$reportNull$$$0(12);
        }
        if ((application = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            processHandler.destroyProcess();
            LOG.info("Destroying process under write action (name: " + sessionName + ", " + String.valueOf(processHandler.getClass()) + ", " + String.valueOf(processHandler) + ")");
            return true;
        }
        return (Boolean)((InstantShutdown)application.getService(InstantShutdown.class)).computeWithDisabledInstantShutdown(() -> this.doAskUserAndWait(processHandler, sessionName, task2));
    }

    private boolean doAskUserAndWait(@NotNull ProcessHandler processHandler, @NotNull String sessionName, @NotNull WaitForProcessTask task2) {
        boolean destroyProcess;
        ProcessCloseConfirmation rc;
        if (processHandler == null) {
            BaseContentCloseListener.$$$reportNull$$$0(13);
        }
        if (sessionName == null) {
            BaseContentCloseListener.$$$reportNull$$$0(14);
        }
        if (task2 == null) {
            BaseContentCloseListener.$$$reportNull$$$0(15);
        }
        if ((rc = TerminateRemoteProcessDialog.show(this.myProject, sessionName, processHandler)) == null) {
            return false;
        }
        boolean bl = destroyProcess = rc == ProcessCloseConfirmation.TERMINATE;
        if (destroyProcess) {
            processHandler.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)true);
            processHandler.destroyProcess();
        } else {
            processHandler.detachProcess();
        }
        ProgressManager.getInstance().run((Task)task2);
        return true;
    }

    protected abstract boolean closeQuery(@NotNull Content var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/BaseContentCloseListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "contentRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "contentRemoveQuery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosed";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosing";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canClose";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "askUserAndWait";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "doAskUserAndWait";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static abstract class WaitForProcessTask
    extends Task.Backgroundable {
        final ProcessHandler myProcessHandler;
        final boolean myModal;

        protected WaitForProcessTask(@NotNull ProcessHandler processHandler, @NotNull String processName, boolean modal, @Nullable Project project) {
            if (processHandler == null) {
                WaitForProcessTask.$$$reportNull$$$0(0);
            }
            if (processName == null) {
                WaitForProcessTask.$$$reportNull$$$0(1);
            }
            super(project, ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{processName}));
            this.myProcessHandler = processHandler;
            this.myModal = modal;
        }

        public boolean isConditionalModal() {
            return this.myModal;
        }

        public boolean shouldStartInBackground() {
            return !this.myModal;
        }

        public void run(final @NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                WaitForProcessTask.$$$reportNull$$$0(2);
            }
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.myProcessHandler.waitFor();
                }
                finally {
                    semaphore.up();
                }
            });
            progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(2000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    semaphore.up();
                }
            });
            semaphore.waitFor();
        }

        public abstract void onCancel();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/BaseContentCloseListener$WaitForProcessTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

