/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.FilePermissionsKt;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.platform.ide.core.permissions.RequiresPermissions;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/ui/PinConfigurationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/platform/ide/core/permissions/RequiresPermissions;", "conf", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isPinned", "", "<init>", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;Z)V", "getConf", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getText", "", "Lorg/jetbrains/annotations/Nls;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getRequiredPermissions", "", "Lcom/intellij/platform/ide/core/permissions/Permission;", "intellij.platform.execution.impl"})
final class PinConfigurationAction
extends DumbAwareAction
implements RequiresPermissions {
    @NotNull
    private final RunnerAndConfigurationSettings conf;

    public PinConfigurationAction(@NotNull RunnerAndConfigurationSettings conf, boolean isPinned) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.getTemplatePresentation().setText(this.getText(isPinned));
    }

    @NotNull
    public final RunnerAndConfigurationSettings getConf() {
        return this.conf;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final String getText(boolean isPinned) {
        String string;
        if (isPinned) {
            String string2 = ExecutionBundle.message((String)"run.toolbar.widget.dropdown.unpin.action.text", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = ExecutionBundle.message((String)"run.toolbar.widget.dropdown.pin.action.text", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        e.getPresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfPreferred);
        e.getPresentation().setText(this.getText(RunConfigurationStartHistory.Companion.getInstance(project2).pinned().contains(this.conf.getUniqueID())));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        RunConfigurationStartHistory.Companion.getInstance(project2).togglePin(this.conf);
    }

    @NotNull
    public Collection<Permission> getRequiredPermissions() {
        return CollectionsKt.listOf((Object)FilePermissionsKt.getProjectFilesWrite());
    }
}

