/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.ExecutionManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.RedesignedRunWidgetKt;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.WindowHeaderPlaceholder;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ui.JBUI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/ui/RedesignedRunToolbarWrapper;", "Lcom/intellij/execution/ui/WindowHeaderPlaceholder;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "update", "isSomeRunningNow", "", "updateCustomComponent", "component", "intellij.platform.execution.impl"})
final class RedesignedRunToolbarWrapper
extends WindowHeaderPlaceholder {
    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        throw new IllegalStateException("Should not be invoked".toString());
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        ActionToolbar toolbar = RedesignedRunWidgetKt.access$createRunActionToolbar();
        toolbar.getComponent().setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)0, (int)16));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().putClientProperty(RedesignedRunWidgetKt.access$getRunToolbarDataKey$p(), (Object)this.isSomeRunningNow(e));
    }

    private final boolean isSomeRunningNow(AnActionEvent e) {
        CompoundRunConfiguration compoundRunConfiguration;
        RunnerAndConfigurationSettings selectedConfiguration;
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        RunManager runManager = RunManager.Companion.getInstanceIfCreated(project2);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = selectedConfiguration = runManager != null ? runManager.getSelectedConfiguration() : null;
        RunConfiguration runConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        CompoundRunConfiguration compoundRunConfiguration2 = compoundRunConfiguration = runConfiguration instanceof CompoundRunConfiguration ? (CompoundRunConfiguration)runConfiguration : null;
        if (compoundRunConfiguration != null) {
            CompoundRunConfiguration it = compoundRunConfiguration;
            boolean bl = false;
            return it.hasRunningSingletons(null);
        }
        if (selectedConfiguration == null) {
            if (!RunConfigurationsComboBoxAction.hasRunCurrentFileItem(project2)) {
                return false;
            }
            List<RunContentDescriptor> runningDescriptors = ExecutionManagerImpl.Companion.getInstance(project2).getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)arg_0 -> RedesignedRunToolbarWrapper.isSomeRunningNow$lambda$2(RedesignedRunToolbarWrapper::isSomeRunningNow$lambda$1, arg_0)));
            return !runningDescriptors.isEmpty();
        }
        ExecutionManagerImpl executionManagerImpl = ExecutionManagerImpl.Companion.getInstanceIfCreated(project2);
        if (executionManagerImpl == null) {
            return false;
        }
        ExecutionManagerImpl executionManager = executionManagerImpl;
        List<RunContentDescriptor> runningDescriptors = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)arg_0 -> RedesignedRunToolbarWrapper.isSomeRunningNow$lambda$4(arg_0 -> RedesignedRunToolbarWrapper.isSomeRunningNow$lambda$3(selectedConfiguration, arg_0), arg_0)));
        return !runningDescriptors.isEmpty();
    }

    @Override
    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Boolean oldData;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.updateCustomComponent(component, presentation);
        Boolean bl = (Boolean)presentation.getClientProperty(RedesignedRunWidgetKt.access$getRunToolbarDataKey$p());
        if (bl == null) {
            return;
        }
        boolean data = bl;
        String dataPropertyName = "old-run-toolbar-data";
        Object object = component.getClientProperty(dataPropertyName);
        Boolean bl2 = oldData = object instanceof Boolean ? (Boolean)object : null;
        if (oldData == null) {
            component.putClientProperty(dataPropertyName, data);
        } else if (!Intrinsics.areEqual((Object)data, (Object)oldData)) {
            component.repaint();
            component.putClientProperty(dataPropertyName, data);
        }
    }

    private static final boolean isSomeRunningNow$lambda$1(RunnerAndConfigurationSettings it) {
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = it instanceof RunnerAndConfigurationSettingsImpl ? (RunnerAndConfigurationSettingsImpl)it : null;
        return (runnerAndConfigurationSettingsImpl != null ? runnerAndConfigurationSettingsImpl.getFilePathIfRunningCurrentFile() : null) != null;
    }

    private static final boolean isSomeRunningNow$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isSomeRunningNow$lambda$3(RunnerAndConfigurationSettings $selectedConfiguration, RunnerAndConfigurationSettings it) {
        Intrinsics.checkNotNull((Object)it);
        return ExecutionManagerImplKt.isOfSameType(it, $selectedConfiguration);
    }

    private static final boolean isSomeRunningNow$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

