/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class GridImpl
extends Wrapper
implements Grid,
Disposable,
UiDataProvider {
    private final ThreeComponentsSplitter myTopSplit;
    private final Splitter mySplitter;
    private final Map<PlaceInGrid, GridCellImpl> myPlaceInGrid2Cell;
    private final List<Content> myContents;
    private final Map<Content, GridCellImpl> myContent2Cell;
    private final Comparator<Content> myContentComparator;
    private final ViewContextEx myViewContext;

    public GridImpl(@NotNull ViewContextEx viewContext, String sessionName) {
        if (viewContext == null) {
            GridImpl.$$$reportNull$$$0(0);
        }
        this.myTopSplit = new ThreeComponentsSplitter(false, true);
        this.mySplitter = new Splitter(true);
        this.myPlaceInGrid2Cell = new EnumMap<PlaceInGrid, GridCellImpl>(PlaceInGrid.class);
        this.myContents = new ArrayList<Content>();
        this.myContent2Cell = new HashMap<Content, GridCellImpl>();
        this.myContentComparator = Comparator.comparing(o -> this.getCellFor((Content)o).getPlaceInGrid());
        this.myViewContext = viewContext;
        Disposer.register((Disposable)this.myViewContext, (Disposable)this);
        Placeholder left = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.left, new GridCellImpl(this.myViewContext, this, left, PlaceInGrid.left));
        Placeholder center = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.center, new GridCellImpl(this.myViewContext, this, center, PlaceInGrid.center));
        Placeholder right = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.right, new GridCellImpl(this.myViewContext, this, right, PlaceInGrid.right));
        Placeholder bottom = new Placeholder();
        this.myPlaceInGrid2Cell.put(PlaceInGrid.bottom, new GridCellImpl(this.myViewContext, this, bottom, PlaceInGrid.bottom));
        this.setContent((JComponent)this.mySplitter);
        this.setOpaque(false);
        this.setFocusCycleRoot(!ScreenReader.isActive());
        this.myTopSplit.setFirstComponent((JComponent)((Object)left));
        this.myTopSplit.setInnerComponent((JComponent)((Object)center));
        this.myTopSplit.setLastComponent((JComponent)((Object)right));
        this.myTopSplit.setMinSize(48);
        this.mySplitter.setFirstComponent((JComponent)this.myTopSplit);
        this.mySplitter.setSecondComponent((JComponent)((Object)bottom));
    }

    public void addNotify() {
        super.addNotify();
        if (UIUtil.getParentOfType(JBRunnerTabs.class, (Component)((Object)this)) != null) {
            this.processAddToUi(true);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.processRemoveFromUi();
    }

    public void processAddToUi(boolean restoreProportions) {
        if (restoreProportions) {
            for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
                cell.restoreProportions();
            }
        }
        this.updateSelection(true);
    }

    public void processRemoveFromUi() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.updateSelection(false);
    }

    private void updateSelection(boolean isShowing) {
        for (GridCellImpl each : this.myPlaceInGrid2Cell.values()) {
            each.updateSelection(isShowing);
        }
    }

    void add(Content content) {
        GridCellImpl cell = this.getCellFor(content);
        cell.add(content);
        this.myContents.add(content);
        this.myContent2Cell.put(content, cell);
        this.myContents.sort(this.myContentComparator);
    }

    void remove(Content content) {
        this.getCellFor(content).remove(content);
        this.myContents.remove(content);
        this.myContent2Cell.remove(content);
    }

    public void setToolbarHorizontal(boolean horizontal) {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.setToolbarHorizontal(horizontal);
        }
    }

    public void setToolbarBefore(boolean before) {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.setToolbarBefore(before);
        }
    }

    public GridCellImpl getCellFor(Content content) {
        GridCellImpl current = this.myContent2Cell.get(content);
        if (current != null) {
            return current;
        }
        View view = this.getStateFor(content);
        GridCellImpl cell = this.myPlaceInGrid2Cell.get(view.getPlaceInGrid());
        assert (cell != null) : "Unknown place in grid: " + view.getPlaceInGrid().name();
        return cell;
    }

    View getStateFor(Content content) {
        return this.myViewContext.getStateFor(content);
    }

    public boolean updateGridUI() {
        boolean isHidden = this.myViewContext.getLayoutSettings().isTabLabelsHidden();
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            if (isHidden) {
                cell.setHideTabs(cell.getContentCount() == 1);
                continue;
            }
            cell.setHideTabs(this.myContents.size() == 1);
        }
        Content onlyContent = this.myContents.get(0);
        return onlyContent.getSearchComponent() != null;
    }

    public boolean isEmpty() {
        return this.myContent2Cell.isEmpty();
    }

    public ActionCallback restoreLastUiState() {
        ActionCallback result2 = new ActionCallback(this.myPlaceInGrid2Cell.size());
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.restoreLastUiState().notifyWhenDone(result2);
        }
        return result2;
    }

    public void saveUiState() {
        for (GridCellImpl cell : this.myPlaceInGrid2Cell.values()) {
            cell.saveUiState();
        }
    }

    @Nullable
    public Tab getTabIndex() {
        return this.getTab();
    }

    public ActionCallback select(Content content, boolean requestFocus) {
        return this.getCellFor(content).select(content, requestFocus);
    }

    public void processAlert(Content content, boolean activate) {
        GridCellImpl cell = this.getCellFor(content);
        cell.processAlert(content, activate);
    }

    @Nullable
    public GridCellImpl findCell(Content content) {
        return this.myContent2Cell.get(content);
    }

    public void rebuildTabPopup() {
        List<Content> contents = this.getContents();
        for (Content each : contents) {
            GridCellImpl cell = this.findCell(each);
            if (cell == null) continue;
            cell.rebuildPopupGroup();
        }
    }

    public boolean isMinimized(Content content) {
        return this.getCellFor(content).isMinimized(content);
    }

    public void dispose() {
    }

    void saveSplitterProportions(PlaceInGrid placeInGrid) {
        if (this.getRootPane() == null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (bounds.width == 0 && bounds.height == 0) {
            return;
        }
        GridCellImpl cell = this.myPlaceInGrid2Cell.get(placeInGrid);
        if (!cell.isValidForCalculateProportions()) {
            return;
        }
        TabImpl tab = (TabImpl)this.getTab();
        if (tab != null) {
            switch (placeInGrid) {
                case left: {
                    tab.setLeftProportion(this.getLeftProportion());
                    break;
                }
                case right: {
                    tab.setRightProportion(this.getRightProportion());
                    break;
                }
                case bottom: {
                    tab.setBottomProportion(this.getBottomPropertion());
                }
            }
        }
    }

    @Nullable
    public Tab getTab() {
        return this.myViewContext.getTabFor(this);
    }

    void restoreLastSplitterProportions(PlaceInGrid placeInGrid) {
        if (this.getRootPane() == null) {
            return;
        }
        if (!RunnerContentUi.ensureValid((JComponent)((Object)this))) {
            return;
        }
        TabImpl tab = (TabImpl)this.getTab();
        if (tab != null) {
            switch (placeInGrid) {
                case left: {
                    this.setLeftProportion(tab.getLeftProportion());
                    break;
                }
                case right: {
                    this.setRightProportion(tab.getRightProportion());
                    break;
                }
                case bottom: {
                    this.mySplitter.setProportion(tab.getBottomProportion());
                    break;
                }
            }
        }
    }

    float getLeftProportion() {
        float totalSize = this.myTopSplit.getOrientation() ? (float)this.myTopSplit.getHeight() : (float)this.myTopSplit.getWidth();
        float componentSize = this.myTopSplit.getFirstSize();
        return componentSize / (totalSize - 2.0f * (float)this.myTopSplit.getDividerWidth());
    }

    void setLeftProportion(float proportion) {
        int totalSize = this.myTopSplit.getOrientation() ? this.myTopSplit.getHeight() : this.myTopSplit.getWidth();
        this.myTopSplit.setFirstSize((int)(proportion * (float)(totalSize - 2 * this.myTopSplit.getDividerWidth())));
    }

    float getRightProportion() {
        float totalSize = this.myTopSplit.getOrientation() ? (float)this.myTopSplit.getHeight() : (float)this.myTopSplit.getWidth();
        float componentSize = this.myTopSplit.getLastSize();
        return componentSize / (totalSize - 2.0f * (float)this.myTopSplit.getDividerWidth());
    }

    float getBottomPropertion() {
        float totalSize = this.mySplitter.getOrientation() ? (float)this.mySplitter.getHeight() : (float)this.mySplitter.getWidth();
        float componentSize = this.mySplitter.getOrientation() ? (float)this.mySplitter.getFirstComponent().getHeight() : (float)this.mySplitter.getFirstComponent().getWidth();
        return componentSize / (totalSize - (float)this.mySplitter.getDividerWidth());
    }

    void setRightProportion(float proportion) {
        int componentSize = this.myTopSplit.getOrientation() ? this.myTopSplit.getHeight() : this.myTopSplit.getWidth();
        this.myTopSplit.setLastSize((int)(proportion * (float)(componentSize - 2 * this.myTopSplit.getDividerWidth())));
    }

    @NotNull
    public ViewContextEx getViewContext() {
        ViewContextEx viewContextEx = this.myViewContext;
        if (viewContextEx == null) {
            GridImpl.$$$reportNull$$$0(1);
        }
        return viewContextEx;
    }

    @NotNull
    public List<Content> getContents() {
        List<Content> list = this.myContents;
        if (list == null) {
            GridImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void minimize(Content content, final CellTransform.Restore restore) {
        this.myViewContext.getCellTransform().minimize(content, new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                return restore.restoreInGrid();
            }
        });
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            GridImpl.$$$reportNull$$$0(3);
        }
        sink.set(ViewContext.CONTEXT_KEY, (Object)this.myViewContext);
        sink.set(ViewContext.CONTENT_KEY, (Object)this.myContents.toArray(new Content[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/GridImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/GridImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class Placeholder
    extends Wrapper
    implements NullableComponent {
        private ContentProvider myContentProvider;
        private JComponent myComponent;

        public Placeholder() {
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    Component content = this.getContent(true);
                    if (content != null) {
                        return content;
                    }
                    return super.getDefaultComponent(aContainer);
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    Component content = this.getContent(false);
                    if (content != null) {
                        return content;
                    }
                    return super.getLastComponent(aContainer);
                }

                private Component getContent(boolean first) {
                    JComponent preferred;
                    Content[] contents;
                    if (myContentProvider != null && (contents = myContentProvider.getContents()) != null && contents.length > 0 && (preferred = contents[first ? 0 : contents.length - 1].getPreferredFocusableComponent()) != null && preferred.isShowing() && this.accept(preferred)) {
                        return preferred;
                    }
                    return null;
                }
            });
        }

        @VisibleForTesting
        public void setContentProvider(@NotNull ContentProvider provider) {
            if (provider == null) {
                Placeholder.$$$reportNull$$$0(0);
            }
            this.myContentProvider = provider;
        }

        public CellTransform.Restore detach() {
            if (this.getComponentCount() == 1) {
                this.myComponent = (JComponent)this.getComponent(0);
                this.removeAll();
            }
            if (this.getParent() instanceof JComponent) {
                this.getParent().revalidate();
                this.getParent().repaint();
            }
            return new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    if (myComponent != null) {
                        this.setContent(myComponent);
                        myComponent = null;
                    }
                    return ActionCallback.DONE;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/execution/ui/layout/impl/GridImpl$Placeholder", "setContentProvider"));
        }
    }

    public static interface ContentProvider {
        public Content[] getContents();
    }
}

