/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.CloseViewAction;
import com.intellij.execution.ui.layout.actions.CustomContentLayoutSettings;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.actions.RestoreViewAction;
import com.intellij.execution.ui.layout.actions.ViewLayoutModificationAction;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.ui.customization.DefaultActionGroupWithDelegate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.TwoSideComponent;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunnerContentUi
implements ContentUI,
Disposable,
CellTransform.Facade,
ViewContextEx,
PropertyChangeListener,
QuickActionProvider,
DockContainer.Dialog,
Activatable {
    public static final DataKey<RunnerContentUi> KEY = DataKey.create((String)"DebuggerContentUI");
    public static final Key<Boolean> LIGHTWEIGHT_CONTENT_MARKER = Key.create((String)"LightweightContent");
    @NonNls
    private static final String LAYOUT = "Runner.Layout";
    @NonNls
    private static final String SETTINGS = "XDebugger.Settings";
    @NonNls
    private static final String VIEW_POPUP = "Runner.View.Popup";
    @NonNls
    static final String VIEW_TOOLBAR = "Runner.View.Toolbar";
    private ShowDebugContentAction myShowDebugContentAction;
    private ContentManager myManager;
    private final RunnerLayout myLayoutSettings;
    @NotNull
    private final ActionManager myActionManager;
    @NlsSafe
    private final String mySessionName;
    private final String myRunnerId;
    private NonOpaquePanel myComponent;
    private final Wrapper myToolbar;
    final MyDragOutDelegate myDragOutDelegate;
    JBRunnerTabs tabs;
    private final Comparator<TabInfo> myTabsComparator;
    private final Project myProject;
    private ActionGroup myTopLeftActions;
    private ActionGroup myTopMiddleActions;
    private ActionGroup myTopRightActions;
    private final DefaultActionGroup myViewActions;
    private final Map<GridImpl, Wrapper> myMinimizedButtonsPlaceholder;
    private final Map<GridImpl, TopToolbarWrappers> myCommonActionsPlaceholder;
    private final Map<GridImpl, TopToolbarContextActions> myContextActions;
    private boolean myUiLastStateWasRestored;
    private final Set<Object> myRestoreStateRequestors;
    private String myTopLeftActionsPlace;
    private String myTopMiddleActionsPlace;
    private String myTopRightActionsPlace;
    private final IdeFocusManager myFocusManager;
    private boolean myMinimizeActionEnabled;
    private boolean myMoveToGridActionEnabled;
    private final RunnerLayoutUi myRunnerUi;
    private final Map<Pair<String, String>, LayoutAttractionPolicy> myAttractions;
    private ActionGroup myTabPopupActions;
    private ActionGroup myAdditionalFocusActions;
    private final ActionCallback myInitialized;
    private boolean myToDisposeRemovedContent;
    private int myAttractionCount;
    private ActionGroup myLeftToolbarActions;
    private boolean myContentToolbarBefore;
    private boolean topLeftActionsVisible;
    private boolean myTopLeftActionsBefore;
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private MyDropAreaPainter myCurrentPainter;
    private Disposable myGlassPaneListenersDisposable;
    private RunnerContentUi myOriginal;
    private final CopyOnWriteArraySet<DockContainer.Listener> myDockingListeners;
    private final Set<RunnerContentUi> myChildren;
    private int myWindow;
    private boolean myDisposing;

    public RunnerContentUi(@NotNull Project project, @NotNull RunnerLayoutUi ui, @NotNull ActionManager actionManager, @NotNull IdeFocusManager focusManager, @NotNull RunnerLayout settings, @NotNull String sessionName, @NotNull String runnerId) {
        if (project == null) {
            RunnerContentUi.$$$reportNull$$$0(0);
        }
        if (ui == null) {
            RunnerContentUi.$$$reportNull$$$0(1);
        }
        if (actionManager == null) {
            RunnerContentUi.$$$reportNull$$$0(2);
        }
        if (focusManager == null) {
            RunnerContentUi.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            RunnerContentUi.$$$reportNull$$$0(4);
        }
        if (sessionName == null) {
            RunnerContentUi.$$$reportNull$$$0(5);
        }
        if (runnerId == null) {
            RunnerContentUi.$$$reportNull$$$0(6);
        }
        this.myShowDebugContentAction = null;
        this.myToolbar = new Wrapper();
        this.myDragOutDelegate = new MyDragOutDelegate();
        this.myTabsComparator = (o1, o2) -> {
            TabImpl tab1 = RunnerContentUi.getTabFor(o1);
            TabImpl tab2 = RunnerContentUi.getTabFor(o2);
            int index1 = tab1 != null ? tab1.getIndex() : -1;
            int index2 = tab2 != null ? tab2.getIndex() : -1;
            return index1 - index2;
        };
        this.myTopLeftActions = new DefaultActionGroup();
        this.myTopMiddleActions = new DefaultActionGroup();
        this.myTopRightActions = new DefaultActionGroup();
        this.myViewActions = new DefaultActionGroup();
        this.myMinimizedButtonsPlaceholder = new HashMap<GridImpl, Wrapper>();
        this.myCommonActionsPlaceholder = new HashMap<GridImpl, TopToolbarWrappers>();
        this.myContextActions = new HashMap<GridImpl, TopToolbarContextActions>();
        this.myRestoreStateRequestors = new HashSet<Object>();
        this.myTopLeftActionsPlace = "RunnerContentUI.topLeftToolbar";
        this.myTopMiddleActionsPlace = "RunnerContentUI.topMiddleToolbar";
        this.myTopRightActionsPlace = "RunnerContentUI.topRightToolbar";
        this.myMinimizeActionEnabled = true;
        this.myMoveToGridActionEnabled = true;
        this.myAttractions = new HashMap<Pair<String, String>, LayoutAttractionPolicy>();
        this.myInitialized = new ActionCallback();
        this.myToDisposeRemovedContent = true;
        this.myContentToolbarBefore = true;
        this.topLeftActionsVisible = true;
        this.myTopLeftActionsBefore = false;
        this.myGlassPaneListenersDisposable = Disposer.newDisposable();
        this.myDockingListeners = new CopyOnWriteArraySet();
        this.myChildren = new TreeSet<RunnerContentUi>(Comparator.comparingInt(o -> o.myWindow));
        this.myProject = project;
        this.myRunnerUi = ui;
        this.myLayoutSettings = settings;
        this.myActionManager = actionManager;
        this.mySessionName = sessionName;
        this.myFocusManager = focusManager;
        this.myRunnerId = runnerId;
    }

    public RunnerContentUi(@NotNull RunnerContentUi ui, @NotNull RunnerContentUi original, int window) {
        if (ui == null) {
            RunnerContentUi.$$$reportNull$$$0(7);
        }
        if (original == null) {
            RunnerContentUi.$$$reportNull$$$0(8);
        }
        this(ui.myProject, ui.myRunnerUi, ui.myActionManager, ui.myFocusManager, ui.myLayoutSettings, ui.mySessionName, original.myRunnerId);
        this.myOriginal = original;
        original.myChildren.add(this);
        this.myWindow = window == 0 ? original.findFreeWindow() : window;
    }

    void setTopLeftActions(@NotNull ActionGroup topActions, @NotNull String place) {
        if (topActions == null) {
            RunnerContentUi.$$$reportNull$$$0(9);
        }
        if (place == null) {
            RunnerContentUi.$$$reportNull$$$0(10);
        }
        this.myTopLeftActions = topActions;
        this.myTopLeftActionsPlace = place;
        this.rebuildCommonActions();
    }

    void setTopMiddleActions(@NotNull ActionGroup topActions, @NotNull String place) {
        if (topActions == null) {
            RunnerContentUi.$$$reportNull$$$0(11);
        }
        if (place == null) {
            RunnerContentUi.$$$reportNull$$$0(12);
        }
        this.myTopMiddleActions = topActions;
        this.myTopMiddleActionsPlace = place;
        this.rebuildCommonActions();
    }

    void setTopRightActions(@NotNull ActionGroup topActions, @NotNull String place) {
        if (topActions == null) {
            RunnerContentUi.$$$reportNull$$$0(13);
        }
        if (place == null) {
            RunnerContentUi.$$$reportNull$$$0(14);
        }
        this.myTopRightActions = topActions;
        this.myTopRightActionsPlace = place;
        this.rebuildCommonActions();
    }

    void setTabPopupActions(ActionGroup tabPopupActions) {
        this.myTabPopupActions = tabPopupActions;
        this.rebuildTabPopup();
    }

    void setAdditionalFocusActions(ActionGroup group2) {
        this.myAdditionalFocusActions = group2;
        this.rebuildTabPopup();
    }

    public void setLeftToolbar(ActionGroup group2, String place) {
        ActionToolbar tb = this.myActionManager.createActionToolbar(place, group2, false);
        tb.setTargetComponent((JComponent)this.myComponent);
        this.myToolbar.setContent(tb.getComponent());
        this.myLeftToolbarActions = group2;
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    void setLeftToolbarVisible(boolean value) {
        this.myToolbar.setVisible(value);
        Border border = this.tabs.getComponent().getBorder();
        if (border instanceof JBRunnerTabs.JBRunnerTabsBorder) {
            ((JBRunnerTabs.JBRunnerTabsBorder)((Object)border)).setSideMask(value ? 1 : 0);
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    void setTopLeftActionsBefore(boolean value) {
        this.myTopLeftActionsBefore = value;
        this.rebuildCommonActions();
    }

    void setContentToolbarBefore(boolean value) {
        this.myContentToolbarBefore = value;
        this.getGrids().forEach(grid -> grid.setToolbarBefore(value));
        this.myContextActions.clear();
        this.rebuildToolbar();
        HashSet usedNames = new HashSet();
        for (TabInfo each : this.tabs.getTabs()) {
            this.updateTabUI(each, usedNames);
        }
        this.tabs.updateTabActions(false);
    }

    void setTopLeftActionsVisible(boolean visible) {
        this.topLeftActionsVisible = visible;
        this.rebuildCommonActions();
    }

    private void initUi() {
        if (this.tabs != null) {
            return;
        }
        this.tabs = new JBRunnerTabs(this.myProject, this){

            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.uiDataSnapshot(sink);
                TabInfo info = RunnerContentUi.this.tabs.getTargetInfo();
                sink.set(ViewContext.CONTENT_KEY, info == null ? null : RunnerContentUi.getGridFor(info).getContents().toArray(new Content[0]));
                sink.set(ViewContext.CONTEXT_KEY, (Object)RunnerContentUi.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/execution/ui/layout/impl/RunnerContentUi$1", "uiDataSnapshot"));
            }
        };
        this.tabs.getComponent().setOpaque(false);
        this.tabs.getPresentation().setTabLabelActionsAutoHide(false).setInnerInsets((Insets)JBInsets.emptyInsets()).setToDrawBorderIfTabsHidden(false).setTabDraggingEnabled(this.isMoveToGridActionEnabled()).setUiDecorator(null);
        this.rebuildTabPopup();
        this.tabs.setPaintFocus(false);
        this.tabs.setRequestFocusOnLastFocusedComponent(true);
        MyComponent wrapper = new MyComponent();
        wrapper.add((Component)this.myToolbar, "West");
        wrapper.add(this.tabs.getComponent(), "Center");
        this.myComponent = wrapper;
        this.tabs.addListener(new TabsListener(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridImpl grid;
                if (oldSelection != null && !RunnerContentUi.this.isStateBeingRestored() && RunnerContentUi.this.getTabFor(grid = RunnerContentUi.getGridFor(oldSelection)) != null) {
                    grid.saveUiState();
                }
            }

            public void tabsMoved() {
                RunnerContentUi.this.saveUiState();
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (!RunnerContentUi.this.tabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                    RunnerContentUi.getGridFor(newSelection).processAddToUi(false);
                }
                if (oldSelection != null) {
                    RunnerContentUi.getGridFor(oldSelection).processRemoveFromUi();
                }
            }
        });
        this.tabs.addTabMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Content[] contents;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.isConsumed()) {
                    return;
                }
                if (!UIUtil.isCloseClick((MouseEvent)e)) {
                    return;
                }
                TabInfo tabInfo = RunnerContentUi.this.tabs.findInfo(e);
                GridImpl grid = tabInfo == null ? null : RunnerContentUi.getGridFor(tabInfo);
                Content[] contentArray = contents = grid != null ? grid.getContents().toArray(new Content[0]) : null;
                if (contents == null) {
                    return;
                }
                if (CloseViewAction.isEnabled(contents)) {
                    CloseViewAction.perform(RunnerContentUi.this, contents[0]);
                } else if (MinimizeViewAction.isEnabled(RunnerContentUi.this, contents, "debuggerTabToolbar")) {
                    grid.getCellFor(contents[0]).minimize(contents[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/layout/impl/RunnerContentUi$3", "mousePressed"));
            }
        });
        if (this.myOriginal != null) {
            ContentManager manager = ContentFactory.getInstance().createContentManager((ContentUI)this, false, this.myProject);
            Disposer.register((Disposable)((Disposable)this.myRunnerUi), (Disposable)manager);
            manager.getComponent();
        } else {
            DockManager dockManager;
            DockManager dockManager2 = dockManager = this.myProject.isDefault() ? null : DockManager.getInstance((Project)this.myProject);
            if (dockManager != null) {
                dockManager.register((DockContainer)this, (Disposable)this);
            }
        }
        if (UIExperiment.isNewDebuggerUIEnabled()) {
            MouseAdapter adapter = new MouseAdapter(){
                private Point myPressPoint = null;

                @Override
                public void mousePressed(MouseEvent e) {
                    InternalDecoratorImpl topLevelDecorator = InternalDecoratorImpl.Companion.findTopLevelDecorator((Component)RunnerContentUi.this.myComponent);
                    if (topLevelDecorator != null) {
                        topLevelDecorator.activate(ToolWindowEventSource.ToolWindowHeader);
                    }
                    this.myPressPoint = e.getPoint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    InternalDecoratorImpl topLevelDecorator;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (topLevelDecorator = InternalDecoratorImpl.Companion.findTopLevelDecorator((Component)RunnerContentUi.this.myComponent)) != null && !topLevelDecorator.isHeaderVisible()) {
                        String id = topLevelDecorator.getToolWindowId();
                        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx((Project)RunnerContentUi.this.myProject);
                        ToolWindow window = manager.getToolWindow(id);
                        if (window != null) {
                            manager.setMaximized(window, !manager.isMaximized(window));
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    ThreeComponentsSplitter splitter;
                    ToolWindowAnchor anchor;
                    InternalDecoratorImpl decorator = InternalDecoratorImpl.Companion.findTopLevelDecorator((Component)RunnerContentUi.this.myComponent);
                    if (decorator == null || decorator.isHeaderVisible()) {
                        return;
                    }
                    ToolWindow window = ToolWindowManager.getInstance((Project)RunnerContentUi.this.myProject).getToolWindow(decorator.getToolWindowId());
                    ToolWindowAnchor toolWindowAnchor = anchor = window != null ? window.getAnchor() : null;
                    if (anchor == ToolWindowAnchor.BOTTOM && SwingUtilities.isLeftMouseButton(e) && this.myPressPoint != null && (splitter = (ThreeComponentsSplitter)ComponentUtil.getParentOfType(ThreeComponentsSplitter.class, (Component)RunnerContentUi.this.myComponent)) != null && splitter.getOrientation() && SwingUtilities.isDescendingFrom(RunnerContentUi.this.getComponent(), splitter.getLastComponent())) {
                        int size = splitter.getLastSize();
                        int yDiff = this.myPressPoint.y - e.getPoint().y;
                        splitter.setLastSize(size + yDiff);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.myPressPoint = null;
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    InternalDecoratorImpl decorator = InternalDecoratorImpl.Companion.findTopLevelDecorator((Component)RunnerContentUi.this.myComponent);
                    if (decorator == null || decorator.isHeaderVisible()) {
                        e.getComponent().setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(8));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            };
            wrapper.addMouseListener(adapter);
            this.tabs.getComponent().addMouseListener(adapter);
            wrapper.addMouseMotionListener(adapter);
            this.tabs.getComponent().addMouseMotionListener(adapter);
        }
        this.updateRestoreLayoutActionVisibility();
    }

    private void rebuildTabPopup() {
        this.initUi();
        this.tabs.setPopupGroup(this.getCellPopupGroup("debuggerTabPopup"), "debuggerTabPopup", true);
        this.getGrids().forEach(GridImpl::rebuildTabPopup);
    }

    @Override
    public ActionGroup getCellPopupGroup(String place) {
        ActionGroup original = this.myTabPopupActions != null ? this.myTabPopupActions : (ActionGroup)this.myActionManager.getAction(VIEW_POPUP);
        ActionGroup focusPlaceholder = (ActionGroup)this.myActionManager.getAction("Runner.Focus");
        DefaultActionGroup group2 = new DefaultActionGroup(VIEW_POPUP, original.isPopup());
        if (this.myShowDebugContentAction == null && "Debug".equals(this.myRunnerId)) {
            this.myShowDebugContentAction = new ShowDebugContentAction(this, this.tabs.getComponent(), this);
        }
        if (this.myShowDebugContentAction != null) {
            group2.add((AnAction)this.myShowDebugContentAction);
        }
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), place, new Presentation(), ActionManager.getInstance(), 0);
        for (AnAction each : original.getChildren(event)) {
            if (each == focusPlaceholder) {
                AnAction[] focusActions;
                for (AnAction eachFocus : focusActions = ((ActionGroup)each).getChildren(event)) {
                    group2.add(eachFocus);
                }
                if (this.myAdditionalFocusActions == null) continue;
                for (AnAction action : this.myAdditionalFocusActions.getChildren(event)) {
                    group2.add(action);
                }
                continue;
            }
            group2.add(each);
        }
        if (this.myViewActions.getChildrenCount() > 0) {
            DefaultActionGroup layoutGroup = new DefaultActionGroup(this.myViewActions.getChildren(this.myActionManager));
            layoutGroup.getTemplatePresentation().setText(ExecutionBundle.messagePointer((String)"action.presentation.RunnerContentUi.text", (Object[])new Object[0]));
            layoutGroup.setPopup(true);
            group2.addSeparator();
            group2.addAction((AnAction)layoutGroup);
        }
        return group2;
    }

    @Override
    public boolean isOriginal() {
        return this.myOriginal == null;
    }

    @Override
    public int getWindow() {
        return this.myWindow;
    }

    @NotNull
    public JBTabs getTabs() {
        JBRunnerTabs jBRunnerTabs = this.tabs;
        if (jBRunnerTabs == null) {
            RunnerContentUi.$$$reportNull$$$0(15);
        }
        return jBRunnerTabs;
    }

    public AnAction @NotNull [] getViewActions() {
        AnAction[] anActionArray = this.myViewActions.getChildren(ActionManager.getInstance());
        if (anActionArray == null) {
            RunnerContentUi.$$$reportNull$$$0(16);
        }
        return anActionArray;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Content content;
        GridImpl grid;
        if (evt == null) {
            RunnerContentUi.$$$reportNull$$$0(17);
        }
        if ((grid = this.getGridFor(content = (Content)evt.getSource(), false)) == null) {
            return;
        }
        GridCellImpl cell = grid.findCell(content);
        if (cell == null) {
            return;
        }
        String property = evt.getPropertyName();
        if ("alerting".equals(property)) {
            this.attract(content, true);
        } else if ("displayName".equals(property) || "icon".equals(property) || "pinned".equals(property) || "actions".equals(property) || "description".equals(property) || "tabColor".equals(property)) {
            cell.updateTabPresentation(content);
            this.updateTabsUI(false);
        }
    }

    void processBounce(Content content, boolean activate) {
        TabInfo tab = this.findTabInfoFor(content);
        if (tab == null) {
            return;
        }
        GridImpl grid = RunnerContentUi.getGridFor(tab);
        if (this.getSelectedGrid() != grid) {
            tab.setAlertIcon(content.getAlertIcon());
            if (activate) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        } else {
            grid.processAlert(content, activate);
        }
    }

    @Override
    public ActionCallback detachTo(int window, GridCell cell) {
        if (this.myOriginal != null) {
            return this.myOriginal.detachTo(window, cell);
        }
        RunnerContentUi target = null;
        if (window > 0) {
            for (RunnerContentUi child : this.myChildren) {
                if (child.myWindow != window) continue;
                target = child;
                break;
            }
        }
        GridCellImpl gridCell = (GridCellImpl)cell;
        Content[] contents = gridCell.getContents();
        this.storeDefaultIndices(contents);
        for (Content content : contents) {
            content.putUserData(RunnerLayout.DROP_INDEX, (Object)this.getStateFor(content).getTab().getIndex());
        }
        Dimension size = gridCell.getSize();
        if (size == null) {
            size = JBUI.size((int)200, (int)200);
        }
        DockableGrid content = new DockableGrid(null, new Presentation(), size, Arrays.asList(contents), window);
        if (target != null) {
            target.add(content, null);
        } else {
            Point location = gridCell.getLocation();
            if (location == null) {
                location = this.getComponent().getLocationOnScreen();
            }
            location.translate(size.width / 2, size.height / 2);
            this.getDockManager().createNewDockContainerFor((DockableContent)content, new RelativePoint(location));
        }
        return ActionCallback.DONE;
    }

    private void storeDefaultIndices(Content @NotNull [] contents) {
        if (contents == null) {
            RunnerContentUi.$$$reportNull$$$0(18);
        }
        for (Content content : contents) {
            content.putUserData(RunnerLayout.DEFAULT_INDEX, (Object)this.getStateFor(content).getTab().getDefaultIndex());
        }
    }

    @NotNull
    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle(this.tabs.getComponent());
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(19);
        }
        if (!(content instanceof DockableGrid)) {
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                RunnerContentUi.$$$reportNull$$$0(20);
            }
            return contentResponse;
        }
        RunnerContentUi ui = ((DockableGrid)content).getOriginalRunnerUi();
        DockContainer.ContentResponse contentResponse = ui.getProject() == this.myProject && ui.mySessionName.equals(this.mySessionName) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            RunnerContentUi.$$$reportNull$$$0(21);
        }
        return contentResponse;
    }

    public JComponent getComponent() {
        this.initUi();
        return this.myComponent;
    }

    @NotNull
    public JComponent getContainerComponent() {
        this.initUi();
        JComponent jComponent = this.myManager.getComponent();
        if (jComponent == null) {
            RunnerContentUi.$$$reportNull$$$0(22);
        }
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull DockableContent dockable, RelativePoint dropTarget) {
        if (dockable == null) {
            RunnerContentUi.$$$reportNull$$$0(23);
        }
        DockableGrid dockableGrid = (DockableGrid)dockable;
        RunnerContentUi prev = dockableGrid.getRunnerUi();
        this.saveUiState();
        List<Content> contents = dockableGrid.getContents();
        boolean wasRestoring = this.myOriginal != null && this.myOriginal.isStateBeingRestored();
        this.setStateIsBeingRestored(true, this);
        try {
            Point point = dropTarget != null ? dropTarget.getPoint((Component)this.myComponent) : null;
            boolean hadGrid = !this.tabs.shouldAddToGlobal(point);
            for (Content content : contents) {
                View view = this.getStateFor(content);
                if (view.isMinimizedInGrid()) continue;
                prev.myManager.removeContent(content, false);
                this.myManager.removeContent(content, false);
                if (hadGrid && !wasRestoring) {
                    view.assignTab(this.getTabFor(this.getSelectedGrid()));
                    view.setPlaceInGrid(RunnerContentUi.calcPlaceInGrid(point, this.myComponent.getSize()));
                } else if (contents.size() == 1 && !wasRestoring) {
                    view.assignTab(null);
                    view.setPlaceInGrid(this.myLayoutSettings.getDefaultGridPlace(content));
                }
                view.setWindow(this.myWindow);
                this.myManager.addContent(content);
            }
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.saveUiState();
        this.updateTabsUI(true);
    }

    public void closeAll() {
        Content[] contents = this.myManager.getContents();
        if (this.myOriginal != null) {
            for (Content content : contents) {
                this.getStateFor(content).setWindow(0);
                this.myOriginal.myManager.addContent(content);
                GridCell cell = this.myOriginal.findCellFor(content);
                if (cell == null) continue;
                this.myOriginal.restore(content);
                cell.minimize(content);
            }
        }
        this.myManager.removeAllContents(false);
    }

    public void addListener(@NotNull DockContainer.Listener listener2, Disposable parent) {
        if (listener2 == null) {
            RunnerContentUi.$$$reportNull$$$0(24);
        }
        this.myDockingListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> this.myDockingListeners.remove(listener2));
    }

    public boolean isEmpty() {
        return this.tabs.isEmptyVisible() || this.myDisposing;
    }

    public Image processDropOver(@NotNull DockableContent dockable, RelativePoint dropTarget) {
        if (dockable == null) {
            RunnerContentUi.$$$reportNull$$$0(25);
        }
        JBTabs current = this.getTabsAt(dockable, dropTarget);
        if (this.myCurrentOver != null && this.myCurrentOver != current) {
            this.resetDropOver(dockable);
        }
        if (this.myCurrentOver == null && current != null) {
            this.myCurrentOver = current;
            Presentation presentation = dockable.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation.getText()).setIcon(presentation.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, dropTarget);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, dropTarget);
        }
        if (this.myCurrentPainter == null) {
            this.myCurrentPainter = new MyDropAreaPainter();
            this.myGlassPaneListenersDisposable = Disposer.newDisposable((String)"GlassPaneListeners");
            Disposer.register((Disposable)this, (Disposable)this.myGlassPaneListenersDisposable);
            IdeGlassPaneUtil.find((Component)this.myComponent).addPainter((Component)this.myComponent, (Painter)this.myCurrentPainter, this.myGlassPaneListenersDisposable);
        }
        this.myCurrentPainter.processDropOver(this, dockable, dropTarget);
        return this.myCurrentOverImg;
    }

    public void toggleContentPopup(JBTabs tabs) {
        if (this.myOriginal != null) {
            this.myOriginal.toggleContentPopup(tabs);
            return;
        }
        List<Content> contents = this.getPopupContents();
        SelectContentStep step2 = new SelectContentStep(contents);
        Content selectedContent = this.myManager.getSelectedContent();
        if (selectedContent != null) {
            step2.setDefaultOptionIndex(this.myManager.getIndexOfContent(selectedContent));
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        popup.showUnderneathOf(tabs.getTabLabel(tabs.getSelectedInfo()));
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup).addRequest(() -> popup.handleSelect(false), 50);
        }
    }

    public List<Content> getPopupContents() {
        if (this.myOriginal != null) {
            return this.myOriginal.getPopupContents();
        }
        ArrayList<Content> contents = new ArrayList<Content>(Arrays.asList(this.myManager.getContents()));
        this.myChildren.stream().flatMap(child -> Arrays.stream(child.myManager.getContents())).forEachOrdered(contents::add);
        RunContentManager contentManager = RunContentManager.getInstance((Project)this.myProject);
        RunContentDescriptor selectedDescriptor = contentManager.getSelectedContent();
        Content selectedContent = selectedDescriptor != null ? selectedDescriptor.getAttachedContent() : null;
        ToolWindow debugToolwindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Debug");
        if (debugToolwindow != null) {
            for (Content content : debugToolwindow.getContentManager().getContents()) {
                if (content == selectedContent) continue;
                contents.add(content);
            }
        }
        return contents;
    }

    @NotNull
    private static PlaceInGrid calcPlaceInGrid(Point point, Dimension size) {
        if (point.x < size.width / 3) {
            PlaceInGrid placeInGrid = PlaceInGrid.left;
            if (placeInGrid == null) {
                RunnerContentUi.$$$reportNull$$$0(26);
            }
            return placeInGrid;
        }
        if (point.x > size.width * 2 / 3) {
            PlaceInGrid placeInGrid = PlaceInGrid.right;
            if (placeInGrid == null) {
                RunnerContentUi.$$$reportNull$$$0(27);
            }
            return placeInGrid;
        }
        if (point.y > size.height * 3 / 4) {
            PlaceInGrid placeInGrid = PlaceInGrid.bottom;
            if (placeInGrid == null) {
                RunnerContentUi.$$$reportNull$$$0(28);
            }
            return placeInGrid;
        }
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            RunnerContentUi.$$$reportNull$$$0(29);
        }
        return placeInGrid;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent<?> content, RelativePoint point) {
        if (content instanceof DockableGrid) {
            Point p = point.getPoint((Component)this.getComponent());
            for (Component c = SwingUtilities.getDeepestComponentAt(this.getComponent(), p.x, p.y); c != null; c = c.getParent()) {
                if (!(c instanceof JBRunnerTabs)) continue;
                return (JBTabs)c;
            }
        }
        return null;
    }

    public void resetDropOver(@NotNull DockableContent content) {
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(30);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
            Disposer.dispose((Disposable)this.myGlassPaneListenersDisposable);
            this.myGlassPaneListenersDisposable = Disposer.newDisposable();
            this.myCurrentPainter = null;
        }
    }

    public boolean isDisposeWhenEmpty() {
        return this.myOriginal != null;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            RunnerContentUi.$$$reportNull$$$0(31);
        }
        assert (this.myManager == null);
        this.myManager = manager;
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                GridImpl grid;
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                RunnerContentUi.this.initUi();
                if (event.getContent().getUserData(LIGHTWEIGHT_CONTENT_MARKER) == Boolean.TRUE) {
                    RunnerContentUi.this.myLayoutSettings.setLightWeight(event.getContent());
                    Disposer.register((Disposable)event.getContent(), () -> RunnerContentUi.this.myLayoutSettings.clearStateFor(event.getContent()));
                }
                if ((grid = RunnerContentUi.this.getGridFor(event.getContent(), true)) == null) {
                    return;
                }
                grid.add(event.getContent());
                if (RunnerContentUi.this.getSelectedGrid() == grid) {
                    grid.processAddToUi(false);
                }
                if (RunnerContentUi.this.myManager.getComponent().isShowing() && !RunnerContentUi.this.isStateBeingRestored()) {
                    RunnerContentUi.this.setStateIsBeingRestored(true, RunnerContentUi.this);
                    try {
                        grid.restoreLastUiState();
                    }
                    finally {
                        RunnerContentUi.this.setStateIsBeingRestored(false, RunnerContentUi.this);
                    }
                }
                RunnerContentUi.this.updateTabsUI(false);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                RunnerContentUi.this.fireContentOpened(event.getContent());
                if (RunnerContentUi.this.myMinimizeActionEnabled) {
                    AnAction[] actions;
                    for (AnAction action : actions = RunnerContentUi.this.myViewActions.getChildren(ActionManager.getInstance())) {
                        if (!(action instanceof ViewLayoutModificationAction) || ((ViewLayoutModificationAction)action).getContent() != event.getContent()) continue;
                        return;
                    }
                    CustomContentLayoutSettings layoutOptionsCollection = (CustomContentLayoutSettings)event.getContent().getUserData(CustomContentLayoutSettings.KEY);
                    if (layoutOptionsCollection != null) {
                        for (AnAction action : layoutOptionsCollection.getActions(RunnerContentUi.this)) {
                            RunnerContentUi.this.myViewActions.addAction(action).setAsSecondary(true);
                        }
                    } else {
                        RestoreViewAction viewAction = new RestoreViewAction(RunnerContentUi.this, event.getContent());
                        RunnerContentUi.this.myViewActions.addAction((AnAction)viewAction).setAsSecondary(true);
                    }
                    ArrayList<AnAction> toAdd = new ArrayList<AnAction>();
                    for (AnAction anAction : RunnerContentUi.this.myViewActions.getChildren(ActionManager.getInstance())) {
                        if (anAction instanceof ViewLayoutModificationAction) continue;
                        RunnerContentUi.this.myViewActions.remove(anAction);
                        toAdd.add(anAction);
                    }
                    for (AnAction anAction : toAdd) {
                        RunnerContentUi.this.myViewActions.addAction(anAction).setAsSecondary(true);
                    }
                }
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                Content content = event.getContent();
                content.removePropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                GridImpl grid = (GridImpl)RunnerContentUi.this.findGridFor(content);
                if (grid != null) {
                    grid.remove(content);
                    if (grid.isEmpty()) {
                        grid.processRemoveFromUi();
                    }
                    RunnerContentUi.this.removeGridIfNeeded(grid);
                }
                RunnerContentUi.this.updateTabsUI(false);
                RunnerContentUi.this.fireContentClosed(content);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (Disposer.isDisposed((Disposable)content)) {
                        AnAction[] actions;
                        for (AnAction action : actions = RunnerContentUi.this.myViewActions.getChildren(ActionManager.getInstance())) {
                            if (!(action instanceof ViewLayoutModificationAction) || ((ViewLayoutModificationAction)action).getContent() != content) continue;
                            RunnerContentUi.this.myViewActions.remove(action);
                            break;
                        }
                    }
                });
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (RunnerContentUi.this.isStateBeingRestored()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    RunnerContentUi.this.select(event.getContent(), false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private GridImpl getSelectedGrid() {
        TabInfo selection = this.tabs.getSelectedInfo();
        return selection != null ? RunnerContentUi.getGridFor(selection) : null;
    }

    private void removeGridIfNeeded(GridImpl grid) {
        if (grid.isEmpty()) {
            this.tabs.removeTab(this.tabs.findInfo((Component)((Object)grid)));
            this.myMinimizedButtonsPlaceholder.remove((Object)grid);
            this.myCommonActionsPlaceholder.remove((Object)grid);
            this.myContextActions.remove((Object)grid);
            Disposer.dispose((Disposable)grid);
        }
    }

    @Nullable
    private GridImpl getGridFor(@NotNull Content content, boolean createIfMissing) {
        GridImpl grid;
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(32);
        }
        if ((grid = (GridImpl)this.findGridFor(content)) != null || !createIfMissing) {
            return grid;
        }
        grid = new GridImpl(this, this.mySessionName);
        grid.setToolbarBefore(this.myContentToolbarBefore);
        if (this.myCurrentOver != null || this.myOriginal != null) {
            int dropIndex;
            Integer forcedDropIndex = (Integer)content.getUserData(RunnerLayout.DROP_INDEX);
            int index = this.tabs.getDropInfoIndex() + (this.myOriginal != null ? this.myOriginal.getTabOffsetFor(this) : 0);
            int n = dropIndex = forcedDropIndex != null ? forcedDropIndex : index;
            if (forcedDropIndex == null) {
                this.moveFollowingTabs(dropIndex);
            }
            int defaultIndex = (Integer)content.getUserData(RunnerLayout.DEFAULT_INDEX);
            TabImpl tab = this.myLayoutSettings.getOrCreateTab(forcedDropIndex != null ? forcedDropIndex : -1);
            tab.setDefaultIndex(defaultIndex);
            tab.setIndex(dropIndex);
            this.getStateFor(content).assignTab((Tab)tab);
            content.putUserData(RunnerLayout.DROP_INDEX, null);
            content.putUserData(RunnerLayout.DEFAULT_INDEX, null);
        }
        TabInfo tab = new TabInfo((JComponent)((Object)grid)).setObject((Object)this.getStateFor(content).getTab()).setText(ExecutionBundle.message((String)"runner.context.tab", (Object[])new Object[0]));
        Wrapper foreWrapper = new Wrapper();
        Wrapper leftWrapper = new Wrapper();
        Wrapper middleWrapper = new Wrapper();
        Wrapper rightWrapper = new Wrapper();
        this.myCommonActionsPlaceholder.put(grid, new TopToolbarWrappers(foreWrapper, leftWrapper, middleWrapper, rightWrapper));
        Wrapper minimizedToolbar = new Wrapper();
        this.myMinimizedButtonsPlaceholder.put(grid, minimizedToolbar);
        Wrapper searchComponent = new Wrapper(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height > 0) {
                    size.height = JBRunnerTabs.getTabLabelPreferredHeight() - RunnerContentUi.this.tabs.getBorderThickness();
                }
                return size;
            }
        };
        if (content.getSearchComponent() != null) {
            searchComponent.setContent(content.getSearchComponent());
        }
        TwoSideComponent right = new TwoSideComponent((JComponent)searchComponent, (JComponent)minimizedToolbar);
        TwoSideComponent sideComponent = new TwoSideComponent((JComponent)leftWrapper, (JComponent)new TwoSideComponent((JComponent)middleWrapper, (JComponent)new TwoSideComponent((JComponent)right, (JComponent)rightWrapper)));
        sideComponent.setVisible(!this.tabs.isHideTopPanel());
        tab.setSideComponent((JComponent)sideComponent);
        foreWrapper.setVisible(!this.tabs.isHideTopPanel());
        tab.setForeSideComponent((JComponent)foreWrapper);
        tab.setTabLabelActions((ActionGroup)this.myActionManager.getAction(VIEW_TOOLBAR), "debuggerTabToolbar");
        this.tabs.addTab(tab);
        this.tabs.sortTabs(this.myTabsComparator);
        return grid;
    }

    private void moveFollowingTabs(int index) {
        if (this.myOriginal != null) {
            this.myOriginal.moveFollowingTabs(index);
            return;
        }
        RunnerContentUi.moveFollowingTabs(index, (JBTabs)this.tabs);
        for (RunnerContentUi child : this.myChildren) {
            RunnerContentUi.moveFollowingTabs(index, (JBTabs)child.tabs);
        }
    }

    ActionGroup getSettingsActions() {
        return (ActionGroup)this.myActionManager.getAction(SETTINGS);
    }

    public ContentManager getContentManager(Content content) {
        if (RunnerContentUi.hasContent(this.myManager, content)) {
            return this.myManager;
        }
        for (RunnerContentUi child : this.myChildren) {
            if (!RunnerContentUi.hasContent(child.myManager, content)) continue;
            return child.myManager;
        }
        return this.myManager;
    }

    private static boolean hasContent(ContentManager manager, Content content) {
        return ArrayUtil.contains((Object)content, (Object[])manager.getContents());
    }

    private static void moveFollowingTabs(int index, JBTabs tabs) {
        for (TabInfo info : tabs.getTabs()) {
            int tabIndex;
            TabImpl tab = RunnerContentUi.getTabFor(info);
            if (tab == null || (tabIndex = tab.getIndex()) < index) continue;
            tab.setIndex(tabIndex + 1);
        }
    }

    private int getTabOffsetFor(RunnerContentUi ui) {
        int offset = this.tabs.getTabCount();
        for (RunnerContentUi child : this.myChildren) {
            if (child == ui) break;
            offset += child.tabs.getTabCount();
        }
        return offset;
    }

    @Nullable
    public GridCell findCellFor(@NotNull Content content) {
        GridImpl cell;
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(33);
        }
        return (cell = this.getGridFor(content, false)) != null ? cell.getCellFor(content) : null;
    }

    private boolean rebuildToolbar() {
        boolean hasToolbarContent = this.rebuildCommonActions();
        return hasToolbarContent |= this.rebuildMinimizedActions();
    }

    private boolean rebuildCommonActions() {
        boolean hasToolbarContent = false;
        for (Map.Entry<GridImpl, TopToolbarWrappers> entry : this.myCommonActionsPlaceholder.entrySet()) {
            Wrapper forePlaceHolder = entry.getValue().fore;
            Wrapper leftPlaceHolder = entry.getValue().left;
            Wrapper middlePlaceHolder = entry.getValue().middle;
            Wrapper rightPlaceHolder = entry.getValue().right;
            TopToolbarContextActions topToolbarContextActions = this.myContextActions.get((Object)entry.getKey());
            DefaultActionGroupWithDelegate leftGroupToBuild = new DefaultActionGroupWithDelegate(this.myTopLeftActions);
            if (this.topLeftActionsVisible) {
                leftGroupToBuild.addAll(this.myTopLeftActions);
            }
            Object[] leftActions = leftGroupToBuild.getChildren(ActionManager.getInstance());
            if (topToolbarContextActions == null || !Arrays.equals(leftActions, topToolbarContextActions.left) || this.myTopLeftActionsBefore && forePlaceHolder.getTargetComponent() == forePlaceHolder || !this.myTopLeftActionsBefore && leftPlaceHolder.getTargetComponent() == leftPlaceHolder) {
                if (this.myTopLeftActionsBefore) {
                    leftPlaceHolder.setContent(null);
                    this.setActions(forePlaceHolder, this.myTopLeftActionsPlace, (DefaultActionGroup)leftGroupToBuild, false);
                    this.setForeToolbarBorder(forePlaceHolder.getTargetComponent());
                } else {
                    forePlaceHolder.setContent(null);
                    this.setActions(leftPlaceHolder, this.myTopLeftActionsPlace, (DefaultActionGroup)leftGroupToBuild, true);
                }
            }
            DefaultActionGroup middleGroupToBuild = new DefaultActionGroup();
            middleGroupToBuild.addAll(this.myTopMiddleActions);
            Object[] middleActions = middleGroupToBuild.getChildren(ActionManager.getInstance());
            if (topToolbarContextActions == null || !Arrays.equals(middleActions, topToolbarContextActions.middle)) {
                this.setActions(middlePlaceHolder, this.myTopMiddleActionsPlace, middleGroupToBuild, true);
            }
            DefaultActionGroup rightGroupToBuild = new DefaultActionGroup();
            rightGroupToBuild.addAll(this.myTopRightActions);
            Object[] rightActions = rightGroupToBuild.getChildren(ActionManager.getInstance());
            if (topToolbarContextActions == null || !Arrays.equals(rightActions, topToolbarContextActions.right)) {
                this.setActions(rightPlaceHolder, this.myTopRightActionsPlace, rightGroupToBuild, true);
            }
            this.myContextActions.put(entry.getKey(), new TopToolbarContextActions((AnAction[])leftActions, (AnAction[])middleActions, (AnAction[])rightActions));
            if (leftGroupToBuild.getChildrenCount() <= 0 && rightGroupToBuild.getChildrenCount() <= 0) continue;
            hasToolbarContent = true;
        }
        return hasToolbarContent;
    }

    private void setActions(@NotNull Wrapper placeHolder, @NotNull String place, @NotNull DefaultActionGroup group2, boolean noBorder) {
        if (placeHolder == null) {
            RunnerContentUi.$$$reportNull$$$0(34);
        }
        if (place == null) {
            RunnerContentUi.$$$reportNull$$$0(35);
        }
        if (group2 == null) {
            RunnerContentUi.$$$reportNull$$$0(36);
        }
        ActionToolbar tb = this.myActionManager.createActionToolbar(place, (ActionGroup)group2, true);
        tb.setReservePlaceAutoPopupIcon(false);
        tb.setTargetComponent((JComponent)this.myComponent);
        if (noBorder) {
            tb.getComponent().setBorder(null);
        }
        tb.getComponent().setOpaque(false);
        placeHolder.setContent(tb.getComponent());
    }

    private void setForeToolbarBorder(@NotNull JComponent component) {
        int tabLeftInsect;
        if (component == null) {
            RunnerContentUi.$$$reportNull$$$0(37);
        }
        int left = 0;
        int right = 0;
        Border border = component.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(component);
            left = insets.left;
            right = insets.right;
        }
        UiDecorator.UiDecoration decoration = this.tabs.getDecoration();
        Insets labelInsets = decoration.getLabelInsets();
        Function supplier = decoration.getContentInsetsSupplier();
        if (labelInsets != null && supplier != null && (tabLeftInsect = labelInsets.left + ((Insets)supplier.apply(TabLabel.ActionsPosition.RIGHT)).left) > right) {
            right = tabLeftInsect;
        }
        component.setBorder((Border)JBUI.Borders.empty((int)0, (int)left, (int)0, (int)right));
    }

    private boolean rebuildMinimizedActions() {
        for (Map.Entry<GridImpl, Wrapper> entry : this.myMinimizedButtonsPlaceholder.entrySet()) {
            Wrapper eachPlaceholder = entry.getValue();
            ActionToolbar tb = this.myActionManager.createActionToolbar("RunnerLayoutButtonToolbar", (ActionGroup)this.myViewActions, true);
            tb.setSecondaryActionsIcon(AllIcons.Debugger.RestoreLayout, UIExperiment.isNewDebuggerUIEnabled());
            tb.setSecondaryActionsTooltip(ExecutionBundle.message((String)"runner.content.tooltip.layout.settings", (Object[])new Object[0]));
            tb.setTargetComponent((JComponent)this.myComponent);
            tb.getComponent().setOpaque(false);
            tb.getComponent().setBorder(null);
            tb.setReservePlaceAutoPopupIcon(false);
            JComponent minimized = tb.getComponent();
            eachPlaceholder.setContent(minimized);
        }
        this.tabs.getComponent().revalidate();
        this.tabs.getComponent().repaint();
        return this.myViewActions.getChildrenCount() > 0;
    }

    public void updateTabsUI(boolean validateNow) {
        boolean hasToolbarContent = this.rebuildToolbar();
        HashSet usedNames = new HashSet();
        List tabs = this.tabs.getTabs();
        for (TabInfo each : tabs) {
            hasToolbarContent |= this.updateTabUI(each, usedNames);
        }
        int tabsCount = tabs.size() + this.myChildren.stream().mapToInt(child -> child.tabs.getTabCount()).sum();
        boolean hideTabs = !hasToolbarContent && tabsCount <= 1 && this.myOriginal == null;
        this.tabs.getPresentation().setHideTabs(hideTabs);
        this.tabs.updateTabActions(validateNow);
        if (validateNow) {
            this.tabs.sortTabs(this.myTabsComparator);
        }
    }

    private boolean updateTabUI(TabInfo tab, Set<? super String> usedNames) {
        String title;
        TabImpl t = RunnerContentUi.getTabFor(tab);
        if (t == null) {
            return false;
        }
        Icon icon = t.getIcon();
        GridImpl grid = RunnerContentUi.getGridFor(tab);
        boolean hasToolbarContent = grid.updateGridUI();
        List<Content> contents = grid.getContents();
        String string = title = contents.size() > 1 ? t.getDisplayName() : null;
        if (title == null) {
            String name = this.myLayoutSettings.getDefaultDisplayName(t.getDefaultIndex());
            title = name != null && contents.size() > 1 && !usedNames.contains(name) ? name : Strings.join(contents, Content::getTabName, (String)" | ");
        }
        usedNames.add(title);
        if (!ClientProperty.isTrue((Component)tab.getComponent(), (Object)SingleContentSupplier.DRAGGED_OUT_KEY)) {
            boolean hidden = true;
            for (Content content : contents) {
                if (grid.isMinimized(content)) continue;
                hidden = false;
                break;
            }
            tab.setHidden(hidden);
        }
        if (icon == null && contents.size() == 1) {
            icon = contents.get(0).getIcon();
        }
        tab.setDragOutDelegate((TabInfo.DragOutDelegate)(this.tabs.getTabs().size() > 1 || !this.isOriginal() ? this.myDragOutDelegate : null));
        String tooltip = contents.size() == 1 ? contents.get(0).getDescription() : null;
        Tab gridTab = grid.getTab();
        tab.setText(title).setIcon((Icon)(gridTab != null && gridTab.isDefault() && contents.size() > 1 ? null : icon)).setTooltipText(tooltip);
        return hasToolbarContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionCallback restoreLastUiState() {
        if (this.isStateBeingRestored()) {
            return ActionCallback.REJECTED;
        }
        try {
            this.setStateIsBeingRestored(true, this);
            ArrayList tabs = new ArrayList(this.tabs.getTabs());
            ActionCallback result2 = new ActionCallback(tabs.size());
            for (TabInfo each : tabs) {
                RunnerContentUi.getGridFor(each).restoreLastUiState().notifyWhenDone(result2);
            }
            ActionCallback actionCallback = result2;
            return actionCallback;
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
    }

    public void saveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        if (this.myOriginal != null) {
            this.myOriginal.saveUiState();
            return;
        }
        if (!this.myUiLastStateWasRestored) {
            return;
        }
        int offset = RunnerContentUi.updateTabsIndices((JBTabs)this.tabs, 0);
        for (RunnerContentUi child : this.myChildren) {
            offset = RunnerContentUi.updateTabsIndices((JBTabs)child.tabs, offset);
        }
        this.doSaveUiState();
    }

    private static int updateTabsIndices(JBTabs tabs, int offset) {
        for (TabInfo each : tabs.getTabs()) {
            int index = tabs.getIndexOf(each);
            TabImpl tab = RunnerContentUi.getTabFor(each);
            if (tab == null) continue;
            tab.setIndex(index >= 0 ? index + offset : index);
        }
        return offset + tabs.getTabCount();
    }

    private void doSaveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        for (TabInfo each : this.tabs.getTabs()) {
            GridImpl eachGrid = RunnerContentUi.getGridFor(each);
            eachGrid.saveUiState();
        }
        for (RunnerContentUi child : this.myChildren) {
            child.doSaveUiState();
        }
    }

    @Nullable
    public Tab getTabFor(Grid grid) {
        TabInfo info = this.tabs.findInfo((Component)grid);
        return RunnerContentUi.getTabFor(info);
    }

    public void showNotify() {
        Window window = SwingUtilities.getWindowAncestor((Component)this.myComponent);
        if (window instanceof IdeFrame.Child) {
            ((IdeFrame.Child)window).setFrameTitle(this.mySessionName);
        }
    }

    @Nullable
    private static TabImpl getTabFor(@Nullable TabInfo tab) {
        if (tab == null) {
            return null;
        }
        return (TabImpl)tab.getObject();
    }

    @NotNull
    private static GridImpl getGridFor(TabInfo tab) {
        GridImpl gridImpl = (GridImpl)((Object)tab.getComponent());
        if (gridImpl == null) {
            RunnerContentUi.$$$reportNull$$$0(38);
        }
        return gridImpl;
    }

    @Nullable
    public Grid findGridFor(@NotNull Content content) {
        TabInfo tabInfo;
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(39);
        }
        return (tabInfo = this.findTabInfoFor(content)) != null ? RunnerContentUi.getGridFor(tabInfo) : null;
    }

    @Nullable
    private TabInfo findTabInfoFor(@NotNull Content content) {
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(40);
        }
        TabImpl tab = (TabImpl)this.getStateFor(content).getTab();
        for (TabInfo each : this.tabs.getTabs()) {
            TabImpl t = RunnerContentUi.getTabFor(each);
            if (t == null || !t.equals(tab)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    private Stream<GridImpl> getGrids() {
        Stream<GridImpl> stream = this.tabs.getTabs().stream().map(RunnerContentUi::getGridFor);
        if (stream == null) {
            RunnerContentUi.$$$reportNull$$$0(41);
        }
        return stream;
    }

    public boolean isSingleSelection() {
        return false;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return true;
    }

    public void beforeDispose() {
        if (this.myOriginal != null) {
            this.myDisposing = true;
            this.fireContentClosed(null);
        }
    }

    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        GridImpl grid;
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(42);
        }
        if (implicit && (grid = this.getGridFor(content, false)) != null) {
            return !grid.isMinimized(content);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
        if (string == null) {
            RunnerContentUi.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
        if (string == null) {
            RunnerContentUi.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = ExecutionBundle.message((String)"select.previous.tab", (Object[])new Object[0]);
        if (string == null) {
            RunnerContentUi.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = ExecutionBundle.message((String)"select.next.tab", (Object[])new Object[0]);
        if (string == null) {
            RunnerContentUi.$$$reportNull$$$0(46);
        }
        return string;
    }

    public void dispose() {
        if (this.myOriginal != null) {
            this.myOriginal.myChildren.remove(this);
        }
        this.myMinimizedButtonsPlaceholder.clear();
        this.myCommonActionsPlaceholder.clear();
        this.myContextActions.clear();
        this.myOriginal = null;
        this.myTopLeftActions = null;
        this.myTopRightActions = null;
        this.myAdditionalFocusActions = null;
        this.myLeftToolbarActions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void restoreLayout() {
        void var6_13;
        int n;
        RunnerContentUi[] runnerContentUiArray;
        RunnerContentUi[] children = this.myChildren.toArray(new RunnerContentUi[0]);
        LinkedHashSet<Content> contents = new LinkedHashSet<Content>();
        Collections.addAll(contents, this.myManager.getContents());
        for (RunnerContentUi runnerContentUi : children) {
            Collections.addAll(contents, runnerContentUi.myManager.getContents());
        }
        for (RunnerContentUi runnerContentUi : this.myViewActions.getChildren(ActionManager.getInstance())) {
            if (!(runnerContentUi instanceof ViewLayoutModificationAction)) continue;
            contents.add(((ViewLayoutModificationAction)((Object)runnerContentUi)).getContent());
        }
        Content[] all = contents.toArray(new Content[0]);
        Arrays.sort(all, Comparator.comparingInt(content -> this.getStateFor((Content)content).getTab().getDefaultIndex()));
        this.setStateIsBeingRestored(true, this);
        try {
            void var6_11;
            runnerContentUiArray = children;
            n = runnerContentUiArray.length;
            boolean bl = false;
            while (var6_11 < n) {
                RunnerContentUi runnerContentUi = runnerContentUiArray[var6_11];
                runnerContentUi.myManager.removeAllContents(false);
                ++var6_11;
            }
            this.myManager.removeAllContents(false);
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.myLayoutSettings.resetToDefault();
        runnerContentUiArray = all;
        n = runnerContentUiArray.length;
        boolean bl = false;
        while (var6_13 < n) {
            RunnerContentUi runnerContentUi = runnerContentUiArray[var6_13];
            this.myManager.addContent((Content)runnerContentUi);
            CustomContentLayoutSettings customLayoutOptionsCollection = (CustomContentLayoutSettings)runnerContentUi.getUserData(CustomContentLayoutSettings.KEY);
            if (customLayoutOptionsCollection != null) {
                customLayoutOptionsCollection.restore();
            }
            ++var6_13;
        }
        this.updateTabsUI(true);
    }

    public boolean isStateBeingRestored() {
        return !this.myRestoreStateRequestors.isEmpty();
    }

    public void setStateIsBeingRestored(boolean restoredNow, Object requestor) {
        if (restoredNow) {
            this.myRestoreStateRequestors.add(requestor);
        } else {
            this.myRestoreStateRequestors.remove(requestor);
        }
    }

    ActionGroup getLayoutActions() {
        return (ActionGroup)this.myActionManager.getAction(LAYOUT);
    }

    public void updateActionsImmediately() {
        Collection<TopToolbarWrappers> values = this.myCommonActionsPlaceholder.values();
        Stream<Wrapper> foreWrappers = values.stream().map(it -> it.fore);
        Stream<Wrapper> leftWrappers = values.stream().map(it -> it.left);
        Stream<Wrapper> rightWrappers = values.stream().map(it -> it.right);
        ((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Object)this.myToolbar).append(foreWrappers)).append(leftWrappers)).append(rightWrappers)).map(Wrapper::getTargetComponent).select(ActionToolbar.class).distinct()).forEach(ActionToolbar::updateActionsImmediately);
    }

    void setMinimizeActionEnabled(boolean enabled) {
        this.myMinimizeActionEnabled = enabled;
        this.updateRestoreLayoutActionVisibility();
    }

    private void updateRestoreLayoutActionVisibility() {
        ArrayList<AnAction> specialActions = new ArrayList<AnAction>();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction action : this.myViewActions.getChildren(actionManager)) {
            if (action instanceof ViewLayoutModificationAction) continue;
            specialActions.add(action);
        }
        if (this.myMinimizeActionEnabled) {
            if (specialActions.isEmpty()) {
                this.myViewActions.addAction((AnAction)new Separator()).setAsSecondary(true);
                AnAction separateWatches = actionManager.getAction("XDebugger.SeparateWatches");
                if (separateWatches != null) {
                    this.myViewActions.addAction(separateWatches).setAsSecondary(true);
                    this.myViewActions.addAction((AnAction)new Separator()).setAsSecondary(true);
                }
                this.myViewActions.addAction(actionManager.getAction("Runner.ToggleTabLabels")).setAsSecondary(true);
                this.myViewActions.addAction(actionManager.getAction("Runner.RestoreLayout")).setAsSecondary(true);
            }
        } else {
            for (AnAction action : specialActions) {
                this.myViewActions.remove(action);
            }
        }
    }

    void setMovetoGridActionEnabled(boolean enabled) {
        this.myMoveToGridActionEnabled = enabled;
        if (this.tabs != null) {
            this.tabs.getPresentation().setTabDraggingEnabled(enabled);
        }
    }

    public boolean isMinimizeActionEnabled() {
        return this.myMinimizeActionEnabled && this.myOriginal == null;
    }

    public boolean isMoveToGridActionEnabled() {
        return this.myMoveToGridActionEnabled;
    }

    public void setPolicy(String contentId, LayoutAttractionPolicy policy) {
        this.myAttractions.put((Pair<String, String>)Pair.create((Object)contentId, null), policy);
    }

    void setConditionPolicy(String condition, LayoutAttractionPolicy policy) {
        this.myAttractions.put((Pair<String, String>)Pair.create(null, (Object)condition), policy);
    }

    @NotNull
    private static LayoutAttractionPolicy getOrCreatePolicyFor(@Nullable String contentId, @Nullable String condition, @NotNull Map<Pair<String, String>, LayoutAttractionPolicy> map, LayoutAttractionPolicy defaultPolicy) {
        LayoutAttractionPolicy policy;
        if (map == null) {
            RunnerContentUi.$$$reportNull$$$0(47);
        }
        LayoutAttractionPolicy layoutAttractionPolicy = (policy = map.putIfAbsent((Pair<String, String>)Pair.create((Object)contentId, (Object)condition), defaultPolicy)) != null ? policy : defaultPolicy;
        if (layoutAttractionPolicy == null) {
            RunnerContentUi.$$$reportNull$$$0(48);
        }
        return layoutAttractionPolicy;
    }

    @Nullable
    public Content findContent(@NotNull String key) {
        Content[] contents;
        ContentManager manager;
        if (key == null) {
            RunnerContentUi.$$$reportNull$$$0(49);
        }
        if ((manager = this.getContentManager()) == null) {
            return null;
        }
        for (Content content : contents = manager.getContents()) {
            String kind = (String)content.getUserData(ViewImpl.ID);
            if (!key.equals(kind)) continue;
            return content;
        }
        return null;
    }

    @Nullable
    private Content findMinimizedContent(@NotNull String key) {
        if (key == null) {
            RunnerContentUi.$$$reportNull$$$0(50);
        }
        for (AnAction action : this.myViewActions.getChildren(ActionManager.getInstance())) {
            Content content;
            if (!(action instanceof ViewLayoutModificationAction) || !key.equals((content = ((ViewLayoutModificationAction)action).getContent()).getUserData(ViewImpl.ID))) continue;
            return content;
        }
        return null;
    }

    @Nullable
    public Content findOrRestoreContentIfNeeded(@NotNull String key) {
        Content content;
        if (key == null) {
            RunnerContentUi.$$$reportNull$$$0(51);
        }
        if ((content = this.findContent(key)) == null && (content = this.findMinimizedContent(key)) != null) {
            this.restore(content);
        }
        return content;
    }

    @ApiStatus.Internal
    public void hideContent(@NotNull String key) {
        Content content;
        if (key == null) {
            RunnerContentUi.$$$reportNull$$$0(52);
        }
        if ((content = this.findContent(key)) == null) {
            content = this.findMinimizedContent(key);
        }
        if (content != null) {
            this.minimize(content, null);
        }
    }

    void setToDisposeRemovedContent(boolean toDispose) {
        this.myToDisposeRemovedContent = toDispose;
    }

    public boolean isToDisposeRemovedContent() {
        return this.myToDisposeRemovedContent;
    }

    private void attractOnStartup() {
        int currentCount = this.myAttractionCount;
        SwingUtilities.invokeLater(() -> {
            if (currentCount < this.myAttractionCount) {
                return;
            }
            this.attractByCondition("startup", false);
        });
    }

    public void attract(Content content, boolean afterInitialized) {
        this.processAttraction((String)content.getUserData(ViewImpl.ID), null, (LayoutAttractionPolicy)new LayoutAttractionPolicy.Bounce(), afterInitialized, true);
    }

    void attractByCondition(@NotNull String condition, boolean afterInitialized) {
        if (condition == null) {
            RunnerContentUi.$$$reportNull$$$0(53);
        }
        this.processAttractionByCondition(condition, afterInitialized, true);
    }

    void clearAttractionByCondition(String condition, boolean afterInitialized) {
        this.processAttractionByCondition(condition, afterInitialized, false);
    }

    private void processAttractionByCondition(@NotNull String condition, boolean afterInitialized, boolean activate) {
        if (condition == null) {
            RunnerContentUi.$$$reportNull$$$0(54);
        }
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), condition, this.myLayoutSettings.getAttractionPolicy(condition), afterInitialized, activate);
    }

    private void processAttraction(@Nullable String contentId, @Nullable String condition, @NotNull LayoutAttractionPolicy defaultPolicy, boolean afterInitialized, boolean activate) {
        if (defaultPolicy == null) {
            RunnerContentUi.$$$reportNull$$$0(55);
        }
        if (contentId == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> this.myInitialized.processOnDone(() -> {
            Content content = this.findContent(contentId);
            if (content == null) {
                return;
            }
            LayoutAttractionPolicy policy = RunnerContentUi.getOrCreatePolicyFor(contentId, condition, this.myAttractions, defaultPolicy);
            if (activate) {
                if (!(policy instanceof LayoutAttractionPolicy.Bounce)) {
                    ++this.myAttractionCount;
                }
                policy.attract(content, this.myRunnerUi);
            } else {
                policy.clearAttraction(content, this.myRunnerUi);
            }
        }, afterInitialized));
    }

    public static boolean ensureValid(JComponent c) {
        Container eachParent;
        if (c.getRootPane() == null) {
            return false;
        }
        for (eachParent = c.getParent(); eachParent != null && eachParent.isValid(); eachParent = eachParent.getParent()) {
        }
        if (eachParent == null) {
            eachParent = c.getRootPane();
        }
        eachParent.validate();
        return true;
    }

    ContentUI getContentUI() {
        return this;
    }

    public void minimize(Content content, CellTransform.Restore restore) {
        this.getStateFor(content).setMinimizedInGrid(true);
        this.myManager.removeContent(content, false);
        this.saveUiState();
    }

    public void restore(@NotNull Content content) {
        GridImpl grid;
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(56);
        }
        if ((grid = this.getGridFor(content, false)) == null) {
            this.getStateFor(content).assignTab((Tab)this.myLayoutSettings.getOrCreateTab(-1));
        } else {
            grid.getCellFor(content).restore(content);
        }
        this.getStateFor(content).setMinimizedInGrid(false);
        this.myManager.addContent(content);
        this.saveUiState();
    }

    public Project getProject() {
        return this.myProject;
    }

    public CellTransform.Facade getCellTransform() {
        return this;
    }

    public ContentManager getContentManager() {
        return this.myManager;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            RunnerContentUi.$$$reportNull$$$0(57);
        }
        return actionManager;
    }

    @Override
    public RunnerLayout getLayoutSettings() {
        return this.myLayoutSettings;
    }

    public View getStateFor(@NotNull Content content) {
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(58);
        }
        return this.myLayoutSettings.getStateFor(content);
    }

    public ActionCallback select(@NotNull Content content, boolean requestFocus) {
        TabInfo info;
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(59);
        }
        if ((info = this.findTabInfoFor(content)) == null) {
            return ActionCallback.DONE;
        }
        GridImpl grid = RunnerContentUi.getGridFor(info);
        ActionCallback result2 = new ActionCallback();
        this.tabs.select(info, false).doWhenDone(() -> grid.select(content, requestFocus).notifyWhenDone(result2));
        return result2;
    }

    public void validate(Content content, ActiveRunnable toRestore) {
        TabInfo current = this.tabs.getSelectedInfo();
        this.tabs.getPresentation().setPaintBlocked(true, true);
        this.select(content, false).doWhenDone(() -> {
            this.tabs.getComponent().validate();
            toRestore.run().doWhenDone(() -> {
                assert (current != null);
                this.tabs.select(current, true);
                this.tabs.getPresentation().setPaintBlocked(false, true);
            });
        });
    }

    public IdeFocusManager getFocusManager() {
        return this.myFocusManager;
    }

    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerUi;
    }

    @NotNull
    public String getName() {
        String string = this.mySessionName;
        if (string == null) {
            RunnerContentUi.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        ContainerUtil.addIfNotNull(result2, (Object)this.myLeftToolbarActions);
        if (UIExperiment.isNewDebuggerUIEnabled()) {
            ContainerUtil.addIfNotNull(result2, (Object)this.myTopLeftActions);
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            RunnerContentUi.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    private int findFreeWindow() {
        int i;
        for (i = 1; i < Integer.MAX_VALUE; ++i) {
            if (this.isUsed(i)) continue;
            return i;
        }
        return i;
    }

    private boolean isUsed(int i) {
        return ContainerUtil.exists(this.myChildren, child -> child.getWindow() == i);
    }

    private DockManagerImpl getDockManager() {
        return (DockManagerImpl)DockManager.getInstance((Project)this.myProject);
    }

    private void fireContentOpened(@NotNull Content content) {
        if (content == null) {
            RunnerContentUi.$$$reportNull$$$0(62);
        }
        for (DockContainer.Listener each : this.myDockingListeners) {
            each.contentAdded((Object)content);
        }
    }

    private void fireContentClosed(@Nullable Content content) {
        for (DockContainer.Listener each : this.myDockingListeners) {
            each.contentRemoved(content != null ? content : new Object());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 20, 21, 22, 26, 27, 28, 29, 38, 41, 43, 44, 45, 46, 48, 57, 60, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topActions";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 57: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerContentUi";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evt";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 19: 
            case 30: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 42: 
            case 56: 
            case 58: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolder";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerContentUi";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewActions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentResponse";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerComponent";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPlaceInGrid";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getGridFor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrids";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreatePolicyFor";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTopLeftActions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTopMiddleActions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTopRightActions";
                break;
            }
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 57: 
            case 60: 
            case 61: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "storeDefaultIndices";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContentResponse";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processDropOver";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resetDropOver";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setManager";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGridFor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findCellFor";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setForeToolbarBorder";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findGridFor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findTabInfoFor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "canChangeSelectionTo";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePolicyFor";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findMinimizedContent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findOrRestoreContentIfNeeded";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "hideContent";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "attractByCondition";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processAttractionByCondition";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processAttraction";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "fireContentOpened";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 20, 21, 22, 26, 27, 28, 29, 38, 41, 43, 44, 45, 46, 48, 57, 60, 61 -> new IllegalStateException(string);
        };
    }

    public static final class ShowDebugContentAction
    extends AnAction
    implements DumbAware {
        public static final String ACTION_ID = "ShowDebugContent";
        private RunnerContentUi myContentUi;

        public ShowDebugContentAction() {
        }

        public ShowDebugContentAction(RunnerContentUi runner, JComponent component, @NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                ShowDebugContentAction.$$$reportNull$$$0(0);
            }
            this.myContentUi = runner;
            new ShadowAction((AnAction)this, "ShowContent", component, parentDisposable);
            ActionUtil.copyFrom((AnAction)this, (String)"ShowContent");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDebugContentAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(this.myContentUi != null && this.myContentUi.getPopupContents().size() > 1);
            e.getPresentation().setText(ExecutionBundle.messagePointer((String)"action.presentation.RunnerContentUi.text.show.list.of.tabs", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowDebugContentAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDebugContentAction.$$$reportNull$$$0(3);
            }
            this.myContentUi.toggleContentPopup((JBTabs)e.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$ShowDebugContentAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$ShowDebugContentAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    final class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private DragSession mySession;

        MyDragOutDelegate() {
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            if (mouseEvent == null) {
                MyDragOutDelegate.$$$reportNull$$$0(0);
            }
            if (info == null) {
                MyDragOutDelegate.$$$reportNull$$$0(1);
            }
            JComponent component = info.getComponent();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
            Content[] data = (Content[])ViewContext.CONTENT_KEY.getData(dataContext);
            assert (data != null);
            RunnerContentUi.this.storeDefaultIndices(data);
            Dimension size = info.getComponent().getSize();
            Image image = JBTabsImpl.getComponentImage((TabInfo)info);
            if (component instanceof Grid) {
                info.setHidden(true);
            }
            Presentation presentation = new Presentation(info.getText());
            presentation.setIcon(info.getIcon());
            this.mySession = RunnerContentUi.this.getDockManager().createDragSession(mouseEvent, (DockableContent)new DockableGrid(image, presentation, size, Arrays.asList(data), 0));
        }

        public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
            if (event == null) {
                MyDragOutDelegate.$$$reportNull$$$0(2);
            }
            if (source == null) {
                MyDragOutDelegate.$$$reportNull$$$0(3);
            }
            this.mySession.process(event);
        }

        public void dragOutFinished(@NotNull MouseEvent event, TabInfo source) {
            if (event == null) {
                MyDragOutDelegate.$$$reportNull$$$0(4);
            }
            this.mySession.process(event);
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            this.mySession.cancel();
            this.mySession = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$MyDragOutDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutStarted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDragOut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyComponent
    extends NonOpaquePanel
    implements UiDataProvider,
    QuickActionProvider {
        private boolean myWasEverAdded;

        MyComponent() {
            super((LayoutManager)new BorderLayout());
            this.setOpaque(true);
            this.setFocusCycleRoot(!ScreenReader.isActive());
            this.setBorder();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!UIExperiment.isNewDebuggerUIEnabled()) {
                return;
            }
            InternalDecoratorImpl decorator = (InternalDecoratorImpl)ComponentUtil.getParentOfType(InternalDecoratorImpl.class, (Component)RunnerContentUi.this.myComponent);
            if (decorator != null && RunnerContentUi.this.tabs.getTabCount() > 0 && !decorator.isHeaderVisible()) {
                UIUtil.drawHeader((Graphics)g, (int)0, (int)this.getWidth(), (int)decorator.getHeaderHeight(), (boolean)decorator.isActive(), (boolean)true, (boolean)false, (boolean)false);
            }
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            ContentManager contentManager;
            if (sink == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            sink.set(KEY, (Object)RunnerContentUi.this);
            Content content = RunnerContentUi.this.getContentManager().getSelectedContent();
            if (content != null && content.isCloseable() && (contentManager = Objects.requireNonNull(content.getManager())).canCloseContents()) {
                sink.set(CloseAction.CloseTarget.KEY, () -> contentManager.removeContent(content, true, true, true));
            }
            ContentManager originalContentManager = RunnerContentUi.this.myOriginal == null ? null : RunnerContentUi.this.myOriginal.getContentManager();
            JComponent originalContentComponent = originalContentManager == null ? null : originalContentManager.getComponent();
            DataSink.uiDataSnapshot((DataSink)sink, (Object)originalContentComponent);
        }

        @NotNull
        public String getName() {
            String string = RunnerContentUi.this.getName();
            if (string == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            List<AnAction> list = RunnerContentUi.this.getActions(originalProvider);
            if (list == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            return list;
        }

        public JComponent getComponent() {
            return RunnerContentUi.this.getComponent();
        }

        public boolean isCycleRoot() {
            return RunnerContentUi.this.isCycleRoot();
        }

        public void addNotify() {
            super.addNotify();
            if (ComponentUtil.findParentByCondition((Component)((Object)this), it -> ClientProperty.isTrue((Component)it, (Object)"TEMPORARY_ADDED")) != null) {
                return;
            }
            if (!RunnerContentUi.this.myUiLastStateWasRestored && RunnerContentUi.this.myOriginal == null) {
                RunnerContentUi.this.myUiLastStateWasRestored = true;
                SwingUtilities.invokeLater(() -> RunnerContentUi.this.restoreLastUiState().doWhenDone(() -> {
                    if (!this.myWasEverAdded) {
                        this.myWasEverAdded = true;
                        RunnerContentUi.this.attractOnStartup();
                        RunnerContentUi.this.myInitialized.setDone();
                    }
                }));
            }
        }

        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this)) || Disposer.isDisposed((Disposable)RunnerContentUi.this)) {
                return;
            }
            if (this.myWasEverAdded) {
                RunnerContentUi.this.saveUiState();
            }
        }

        public void updateUI() {
            super.updateUI();
            this.setBorder();
        }

        private void setBorder() {
            this.setBorder((Border)JBUI.Borders.emptyTop((int)-1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$MyComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$MyComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    final class DockableGrid
    implements DockableContent<List<Content>> {
        private final Image myImg;
        private final Presentation myPresentation;
        private final Dimension myPreferredSize;
        private final List<Content> myContents;
        private final int myWindow;

        DockableGrid(Image img, Presentation presentation, Dimension size, List<Content> contents, int window) {
            this.myImg = img;
            this.myPresentation = presentation;
            this.myPreferredSize = size;
            this.myContents = contents;
            this.myWindow = window;
        }

        @NotNull
        public List<Content> getKey() {
            List<Content> list = this.myContents;
            if (list == null) {
                DockableGrid.$$$reportNull$$$0(0);
            }
            return list;
        }

        public Image getPreviewImage() {
            return this.myImg;
        }

        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        public String getDockContainerType() {
            return "runner-grid";
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        RunnerContentUi getRunnerUi() {
            return RunnerContentUi.this;
        }

        RunnerContentUi getOriginalRunnerUi() {
            return RunnerContentUi.this.myOriginal != null ? RunnerContentUi.this.myOriginal : RunnerContentUi.this;
        }

        @NotNull
        public List<Content> getContents() {
            List<Content> list = this.myContents;
            if (list == null) {
                DockableGrid.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void close() {
        }

        public int getWindow() {
            return this.myWindow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$DockableGrid";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContents";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class MyDropAreaPainter
    extends AbstractPainter {
        private Shape myBoundingBox;

        private MyDropAreaPainter() {
        }

        public boolean needsRepaint() {
            return this.myBoundingBox != null;
        }

        public void executePaint(@NotNull Component component, @NotNull Graphics2D g) {
            if (component == null) {
                MyDropAreaPainter.$$$reportNull$$$0(0);
            }
            if (g == null) {
                MyDropAreaPainter.$$$reportNull$$$0(1);
            }
            if (this.myBoundingBox == null) {
                return;
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
            g.fill(this.myBoundingBox);
        }

        private void processDropOver(RunnerContentUi ui, DockableContent<?> dockable, RelativePoint dropTarget) {
            Point point;
            this.myBoundingBox = null;
            this.setNeedsRepaint(true);
            if (!(dockable instanceof DockableGrid)) {
                return;
            }
            NonOpaquePanel component = ui.myComponent;
            Point point2 = point = dropTarget != null ? dropTarget.getPoint((Component)component) : null;
            if (ui.tabs.shouldAddToGlobal(point)) {
                return;
            }
            PlaceInGrid targetPlaceInGrid = null;
            for (Content c : ((DockableGrid)dockable).getContents()) {
                View view = ui.getStateFor(c);
                if (view.isMinimizedInGrid()) continue;
                PlaceInGrid defaultGridPlace = ui.getLayoutSettings().getDefaultGridPlace(c);
                PlaceInGrid placeInGrid = targetPlaceInGrid = point == null ? defaultGridPlace : RunnerContentUi.calcPlaceInGrid(point, component.getSize());
                break;
            }
            if (targetPlaceInGrid == null) {
                return;
            }
            Dimension size = component.getSize();
            Rectangle r = new Rectangle(size);
            switch (targetPlaceInGrid) {
                case left: {
                    r.width /= 3;
                    break;
                }
                case center: {
                    r.width /= 3;
                    r.x += r.width;
                    break;
                }
                case right: {
                    r.width /= 3;
                    r.x += 2 * r.width;
                    break;
                }
                case bottom: {
                    r.height /= 4;
                    r.y += 3 * r.height;
                }
            }
            for (Content c : ui.getContentManager().getContents()) {
                JComponent cellWrapper;
                PlaceInGrid placeInGrid;
                GridCell cellFor = ui.findCellFor(c);
                PlaceInGrid placeInGrid2 = placeInGrid = cellFor == null ? null : ((GridCellImpl)cellFor).getPlaceInGrid();
                if (placeInGrid != targetPlaceInGrid) continue;
                Wrapper wrapper = (Wrapper)ComponentUtil.getParentOfType(Wrapper.class, (Component)c.getComponent());
                JComponent jComponent = cellWrapper = wrapper == null ? null : (JComponent)wrapper.getParent();
                if (cellWrapper == null || !cellWrapper.isShowing()) continue;
                r = new RelativeRectangle(cellWrapper).getRectangleOn((Component)component);
                break;
            }
            this.myBoundingBox = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/ui/layout/impl/RunnerContentUi$MyDropAreaPainter";
            objectArray[2] = "executePaint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TopToolbarWrappers {
        public final Wrapper fore;
        public final Wrapper left;
        public final Wrapper middle;
        public final Wrapper right;

        private TopToolbarWrappers(Wrapper fore, Wrapper left, Wrapper middle, Wrapper right) {
            this.fore = fore;
            this.left = left;
            this.middle = middle;
            this.right = right;
        }
    }

    private static final class TopToolbarContextActions {
        public final AnAction[] left;
        public final AnAction[] middle;
        public final AnAction[] right;

        private TopToolbarContextActions(AnAction[] left, AnAction[] middle, AnAction[] right) {
            this.left = left;
            this.middle = middle;
            this.right = right;
        }
    }
}

