/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.target.ExternallySynchronized;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.VolumeCopyingRequest;
import com.intellij.execution.target.local.LocalTargets;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionExKt;
import com.intellij.execution.wsl.WslProcessToolsKt;
import com.intellij.execution.wsl.WslProxy;
import com.intellij.execution.wsl.sync.WslSync;
import com.intellij.execution.wsl.target.WslTargetEnvironmentKt;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001BB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0018H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u001c2\u0006\u00105\u001a\u00020\u001cH\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010%R \u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010%R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00106\u001a\u00020\u001c*\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006C"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/ExternallySynchronized;", "request", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;Lcom/intellij/execution/wsl/WSLDistribution;)V", "getRequest", "()Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "myUploadVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "myDownloadVolumes", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "myTargetPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "Lcom/intellij/execution/target/ResolvedPortBinding;", "myLocalPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "proxies", "", "Lcom/intellij/execution/wsl/WslProxy;", "remoteDirsToDelete", "", "", "synchronizedVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$SynchronizedVolume;", "getSynchronizedVolumes", "()Ljava/util/List;", "uploadVolumes", "", "getUploadVolumes", "()Ljava/util/Map;", "downloadVolumes", "getDownloadVolumes", "targetPortBindings", "getTargetPortBindings", "localPortBindings", "getLocalPortBindings", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "wslIpAddress", "Ljava/net/InetAddress;", "getWslPort", "localPort", "toLinuxPath", "localPath", "remoteRoot", "Lcom/intellij/execution/target/TargetEnvironment$TargetPath;", "getRemoteRoot", "(Lcom/intellij/execution/target/TargetEnvironment$TargetPath;)Ljava/lang/String;", "createProcess", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "shutdown", "", "Volume", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nWslTargetEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslTargetEnvironment.kt\ncom/intellij/execution/wsl/target/WslTargetEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,191:1\n1563#2:192\n1634#2,3:193\n1#3:196\n216#4,2:197\n*S KotlinDebug\n*F\n+ 1 WslTargetEnvironment.kt\ncom/intellij/execution/wsl/target/WslTargetEnvironment\n*L\n44#1:192\n44#1:193,3\n136#1:197,2\n*E\n"})
public final class WslTargetEnvironment
extends TargetEnvironment
implements ExternallySynchronized {
    @NotNull
    private final WslTargetEnvironmentRequest request;
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    @NotNull
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    @NotNull
    private final Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> myTargetPortBindings;
    @NotNull
    private final Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> myLocalPortBindings;
    @NotNull
    private final Map<Integer, WslProxy> proxies;
    @NotNull
    private final List<String> remoteDirsToDelete;
    @NotNull
    private final List<TargetEnvironment.SynchronizedVolume> synchronizedVolumes;
    @NotNull
    private final InetAddress wslIpAddress;

    /*
     * WARNING - void declaration
     */
    public WslTargetEnvironment(@NotNull WslTargetEnvironmentRequest request, @NotNull WSLDistribution distribution) {
        WslTargetEnvironmentRequest $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        super((TargetEnvironmentRequest)request);
        this.request = request;
        this.distribution = distribution;
        this.myUploadVolumes = new HashMap();
        this.myDownloadVolumes = new HashMap();
        this.myTargetPortBindings = new HashMap();
        this.myLocalPortBindings = new HashMap();
        this.proxies = new LinkedHashMap();
        this.remoteDirsToDelete = new ArrayList();
        Iterable iterable = WslDistributionExKt.getRootMappings(this.distribution);
        WslTargetEnvironment wslTargetEnvironment = this;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        ResolvedPortBinding resolvedPortBinding = $this$mapTo$iv$iv.iterator();
        while (resolvedPortBinding.hasNext()) {
            void it;
            Object item$iv$iv = resolvedPortBinding.next();
            PathMappingSettings.PathMapping pathMapping = (PathMappingSettings.PathMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = Path.of(it.getLocalRoot(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            String string = it.getRemoteRoot();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemoteRoot(...)");
            collection.add(new TargetEnvironment.SynchronizedVolume(path, string));
        }
        wslTargetEnvironment.synchronizedVolumes = (List)destination$iv$iv;
        InetAddress inetAddress = this.distribution.getWslIpAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getWslIpAddress(...)");
        this.wslIpAddress = inetAddress;
        $this$mapTo$iv$iv = this.getRequest();
        VolumeCopyingRequest volumeCopyingRequest = $this$mapTo$iv$iv instanceof VolumeCopyingRequest ? (VolumeCopyingRequest)$this$mapTo$iv$iv : null;
        boolean useWslSync = (volumeCopyingRequest != null ? volumeCopyingRequest.getShouldCopyVolumes() : false) && Registry.Companion.is("ide.wsl.use_wsl_sync");
        for (TargetEnvironment.UploadRoot uploadRoot : this.getRequest().getUploadVolumes()) {
            String targetRoot;
            String string = targetRoot = useWslSync ? this.getRemoteRoot(uploadRoot.getTargetRootPath()) : this.toLinuxPath(((Object)uploadRoot.getLocalRootPath().toAbsolutePath()).toString());
            if (targetRoot != null) {
                this.myUploadVolumes.put(uploadRoot, new Volume(uploadRoot.getLocalRootPath(), targetRoot, useWslSync));
                continue;
            }
            WslTargetEnvironmentKt.access$getLOG$p().error("Cannot register upload volume: WSL path not found for local path: " + uploadRoot.getLocalRootPath());
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : this.getRequest().getDownloadVolumes()) {
            String targetRoot;
            Path localRootPath;
            Path path = downloadRoot.getLocalRootPath();
            if (path == null) {
                path = localRootPath = FileUtil.createTempDirectory((String)"intellij-target.", (String)"").toPath();
            }
            if ((targetRoot = useWslSync ? this.getRemoteRoot(downloadRoot.getTargetRootPath()) : this.toLinuxPath(((Object)localRootPath.toAbsolutePath()).toString())) == null) continue;
            Intrinsics.checkNotNull((Object)localRootPath);
            this.myDownloadVolumes.put(downloadRoot, new Volume(localRootPath, targetRoot, useWslSync));
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : this.getRequest().getTargetPortBindings()) {
            int theOnlyPort = targetPortBinding.getTarget();
            if (targetPortBinding.getLocal() != null) {
                Integer n = targetPortBinding.getLocal();
                int targetRoot = theOnlyPort;
                if (n == null || n != targetRoot) {
                    throw new UnsupportedOperationException("TCP port forwarding for the local target is not implemented. Please use the same port number for both local and target ports.");
                }
            }
            Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> targetRoot = this.myTargetPortBindings;
            String string = this.wslIpAddress.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
            resolvedPortBinding = new ResolvedPortBinding(new HostPort(string, theOnlyPort), new HostPort("localhost", targetPortBinding.getTarget()));
            targetRoot.put(targetPortBinding, resolvedPortBinding);
        }
        for (TargetEnvironment.LocalPortBinding localPortBinding : this.getRequest().getLocalPortBindings()) {
            int localPort = localPortBinding.getLocal();
            HostPort hostPort = new HostPort("127.0.0.1", this.distribution.getVersion() > 1 ? this.getWslPort(localPort) : localPort);
            this.myLocalPortBindings.put(localPortBinding, new ResolvedPortBinding(hostPort, hostPort));
        }
    }

    @NotNull
    public WslTargetEnvironmentRequest getRequest() {
        return this.request;
    }

    @NotNull
    public List<TargetEnvironment.SynchronizedVolume> getSynchronizedVolumes() {
        return this.synchronizedVolumes;
    }

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map = Collections.unmodifiableMap(this.myUploadVolumes);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map = Collections.unmodifiableMap(this.myDownloadVolumes);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, ResolvedPortBinding> map = Collections.unmodifiableMap(this.myTargetPortBindings);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> map = Collections.unmodifiableMap(this.myLocalPortBindings);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX);
    }

    private final int getWslPort(int localPort) {
        WslProxy wslProxy = this.proxies.get(localPort);
        if (wslProxy != null) {
            int it = wslProxy.getWslIngressPort();
            boolean bl = false;
            return it;
        }
        WslProxy $this$getWslPort_u24lambda_u241 = new WslProxy((AbstractWslDistribution)this.distribution, localPort);
        boolean bl = false;
        this.proxies.put(localPort, $this$getWslPort_u24lambda_u241);
        return $this$getWslPort_u24lambda_u241.getWslIngressPort();
    }

    private final String toLinuxPath(String localPath) {
        return this.distribution.getWslPath(localPath);
    }

    private final String getRemoteRoot(TargetEnvironment.TargetPath $this$remoteRoot) {
        String string;
        TargetEnvironment.TargetPath targetPath = $this$remoteRoot;
        if (targetPath instanceof TargetEnvironment.TargetPath.Temporary) {
            Object object = new String[]{"mktemp", "-d"};
            object = WslProcessToolsKt.runCommand$default((AbstractWslDistribution)((AbstractWslDistribution)this.distribution), (String[])object, null, (int)2, null);
            ResultKt.throwOnFailure((Object)object);
            String it = (String)object;
            boolean bl = false;
            ((Collection)this.remoteDirsToDelete).add(it);
            string = (String)object;
        } else if (targetPath instanceof TargetEnvironment.TargetPath.Persistent) {
            string = ((TargetEnvironment.TargetPath.Persistent)$this$remoteRoot).getAbsolutePath();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        Process process2;
        Process process3;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        PtyOptions ptyOptions = commandLine.getPtyOptions();
        LocalPtyOptions ptyOptions2 = ptyOptions != null ? LocalTargets.toLocalPtyOptions((PtyOptions)ptyOptions) : null;
        GeneralCommandLine generalCommandLine = ptyOptions2 != null ? (GeneralCommandLine)new PtyCommandLine(commandLine.collectCommandsSynchronously()).withOptions(ptyOptions2) : new GeneralCommandLine(commandLine.collectCommandsSynchronously());
        generalCommandLine.getEnvironment().putAll(commandLine.getEnvironmentVariables());
        this.getRequest().getWslOptions().setRemoteWorkingDirectory(commandLine.getWorkingDirectory());
        generalCommandLine.withRedirectErrorStream(commandLine.isRedirectErrorStream());
        this.distribution.patchCommandLine(generalCommandLine, null, this.getRequest().getWslOptions());
        Process $this$createProcess_u24lambda_u241 = process3 = (process2 = (Process)ProgressManager.getInstance().runProcess(() -> WslTargetEnvironment.createProcess$lambda$0(generalCommandLine), (ProgressIndicator)new EmptyProgressIndicator()));
        boolean bl = false;
        $this$createProcess_u24lambda_u241.onExit().whenCompleteAsync((arg_0, arg_1) -> WslTargetEnvironment.createProcess$lambda$1$1((arg_0, arg_1) -> WslTargetEnvironment.createProcess$lambda$1$0(this, arg_0, arg_1), arg_0, arg_1));
        Process process4 = process3;
        Intrinsics.checkNotNullExpressionValue((Object)process4, (String)"apply(...)");
        return process4;
    }

    public void shutdown() {
        Iterator<String> iterator = this.remoteDirsToDelete.iterator();
        while (iterator.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            try {
                String dir;
                String[] stringArray = new String[]{"rm", "-rf", dir};
                WslProcessToolsKt.runCommand$default((AbstractWslDistribution)((AbstractWslDistribution)this.distribution), (String[])stringArray, null, (int)2, null);
            }
            catch (Exception ex) {
                WslTargetEnvironmentKt.access$getLOG$p().warn((Throwable)ex);
            }
        }
        this.remoteDirsToDelete.clear();
    }

    private static final Process createProcess$lambda$0(GeneralCommandLine $generalCommandLine) {
        return $generalCommandLine.createProcess();
    }

    private static final Unit createProcess$lambda$1$0(WslTargetEnvironment this$0, Process process2, Throwable throwable) {
        Map<Integer, WslProxy> $this$forEach$iv = this$0.proxies;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, WslProxy>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, WslProxy> element$iv;
            Map.Entry<Integer, WslProxy> it = element$iv = iterator.next();
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getValue()));
        }
        this$0.proxies.clear();
        return Unit.INSTANCE;
    }

    private static final void createProcess$lambda$1$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment$Volume;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "useWslSync", "", "<init>", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironment;Ljava/nio/file/Path;Ljava/lang/String;Z)V", "getLocalRoot", "()Ljava/nio/file/Path;", "getTargetRoot", "()Ljava/lang/String;", "resolveTargetPath", "relativePath", "upload", "", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "download", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.execution.impl"})
    private final class Volume
    implements TargetEnvironment.UploadableVolume,
    TargetEnvironment.DownloadableVolume {
        @NotNull
        private final Path localRoot;
        @NotNull
        private final String targetRoot;
        private final boolean useWslSync;

        public Volume(@NotNull Path localRoot, String targetRoot, boolean useWslSync) {
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
            this.localRoot = localRoot;
            this.targetRoot = targetRoot;
            this.useWslSync = useWslSync;
        }

        @NotNull
        public Path getLocalRoot() {
            return this.localRoot;
        }

        @NotNull
        public String getTargetRoot() {
            return this.targetRoot;
        }

        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            String[] stringArray = new String[]{((Object)this.getLocalRoot()).toString(), relativePath};
            String localPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])stringArray));
            Intrinsics.checkNotNull((Object)localPath);
            String string = WslTargetEnvironment.this.toLinuxPath(localPath);
            if (string == null) {
                throw new RuntimeException("Cannot find Linux path for " + localPath + " (" + WslTargetEnvironment.this.distribution.getMsId() + ")");
            }
            return string;
        }

        public void upload(@NotNull String relativePath, @NotNull TargetProgressIndicator targetProgressIndicator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
            if (!this.useWslSync) {
                return;
            }
            String string = this.getTargetRoot() + "/" + relativePath;
            Path path = this.getLocalRoot().resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            WslSync.Companion.syncWslFolders$default((WslSync.Companion)WslSync.Companion, (String)string, (Path)path, (AbstractWslDistribution)((AbstractWslDistribution)WslTargetEnvironment.this.distribution), (boolean)false, null, (boolean)false, (boolean)false, (int)112, null);
        }

        public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            if (this.useWslSync) {
                String string = this.getTargetRoot() + "/" + relativePath;
                Path path = this.getLocalRoot().resolve(relativePath);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                WslSync.Companion.syncWslFolders$default((WslSync.Companion)WslSync.Companion, (String)string, (Path)path, (AbstractWslDistribution)((AbstractWslDistribution)WslTargetEnvironment.this.distribution), (boolean)true, null, (boolean)false, (boolean)false, (int)112, null);
                return;
            }
            Path path = this.getLocalRoot().resolve(relativePath);
            long previousSize = -2L;
            Intrinsics.checkNotNull((Object)path);
            long newSize = PathKt.fileSizeSafe((Path)path, (long)-1L);
            while (previousSize < newSize) {
                Thread.sleep(100L);
                previousSize = newSize;
                newSize = PathKt.fileSizeSafe((Path)path, (long)-1L);
            }
            if (newSize == -1L) {
                WslTargetEnvironmentKt.access$getLOG$p().warn("Path " + path + " was not found on local filesystem");
            }
        }
    }
}

