/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.editor.actions.TerminalChangeFontHandler;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/editor/actions/ClassicTerminalChangeFontHandler;", "Lcom/intellij/openapi/editor/actions/TerminalChangeFontHandler;", "widget", "Lcom/intellij/terminal/JBTerminalWidget;", "<init>", "(Lcom/intellij/terminal/JBTerminalWidget;)V", "changeSize", "", "step", "", "resetTerminalFontSize", "intellij.platform.execution.impl"})
final class ClassicTerminalChangeFontHandler
implements TerminalChangeFontHandler {
    @NotNull
    private final JBTerminalWidget widget;

    public ClassicTerminalChangeFontHandler(@NotNull JBTerminalWidget widget) {
        Intrinsics.checkNotNullParameter((Object)((Object)widget), (String)"widget");
        this.widget = widget;
    }

    @Override
    public void changeSize(float step2) {
        JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase = this.widget.getSettingsProvider();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jBTerminalSystemSettingsProviderBase), (String)"getSettingsProvider(...)");
        JBTerminalSystemSettingsProviderBase settingsProvider = jBTerminalSystemSettingsProviderBase;
        float newFontSize = settingsProvider.getTerminalFontSize() + step2;
        if (newFontSize >= (float)EditorFontsConstants.getMinEditorFontSize() && newFontSize <= (float)EditorFontsConstants.getMaxEditorFontSize()) {
            settingsProvider.setTerminalFontSize(newFontSize);
        }
    }

    @Override
    public void resetTerminalFontSize() {
        this.widget.getSettingsProvider().resetTerminalFontSize();
    }
}

