/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.PtyBasedProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessHandlerTtyConnector
implements TtyConnector {
    private static final Logger LOG = Logger.getInstance(ProcessHandlerTtyConnector.class);
    private final ProcessHandler myProcessHandler;
    private final Process myPtyProcess;
    private final Charset myCharset;

    public ProcessHandlerTtyConnector(@NotNull ProcessHandler processHandler, @NotNull Charset charset) {
        if (processHandler == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(1);
        }
        this.myProcessHandler = processHandler;
        this.myPtyProcess = ProcessHandlerTtyConnector.getPtyProcess(processHandler);
        this.myCharset = charset;
    }

    @Nullable
    private static Process getPtyProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(2);
        }
        if (!(processHandler instanceof BaseProcessHandler)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ProcessHandler doesn't support terminal window resizing: " + String.valueOf(processHandler.getClass()));
            }
            return null;
        }
        Process process2 = ((BaseProcessHandler)processHandler).getProcess();
        if (!(process2 instanceof PtyProcess) && !(process2 instanceof PtyBasedProcess) && LOG.isDebugEnabled()) {
            LOG.debug("Process doesn't support terminal window resizing: " + String.valueOf(process2.getClass()));
        }
        return process2;
    }

    public void close() {
    }

    public void resize(@NotNull TermSize termSize) {
        Process process2;
        if (termSize == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(3);
        }
        if ((process2 = this.myPtyProcess) instanceof PtyProcess) {
            PtyProcess ptyProcess = (PtyProcess)process2;
            ProcessHandlerTtyConnector.setWindowSizeSafely(this.myPtyProcess, () -> ptyProcess.setWinSize(new WinSize(termSize.getColumns(), termSize.getRows())));
        } else {
            process2 = this.myPtyProcess;
            if (process2 instanceof PtyBasedProcess) {
                PtyBasedProcess ptyBasedProcess = (PtyBasedProcess)process2;
                ProcessHandlerTtyConnector.setWindowSizeSafely(this.myPtyProcess, () -> ptyBasedProcess.setWindowSize(termSize.getColumns(), termSize.getRows()));
            }
        }
    }

    private static void setWindowSizeSafely(@NotNull Process process2, @NotNull Runnable setWindowSizeCallback) {
        block6: {
            if (process2 == null) {
                ProcessHandlerTtyConnector.$$$reportNull$$$0(4);
            }
            if (setWindowSizeCallback == null) {
                ProcessHandlerTtyConnector.$$$reportNull$$$0(5);
            }
            if (process2.isAlive()) {
                try {
                    setWindowSizeCallback.run();
                }
                catch (Exception e) {
                    if (!process2.isAlive()) {
                        throw e;
                    }
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Suppressed failure of setWindowSize due to the terminated process", (Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "TtyConnector:" + this.myProcessHandler.toString();
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        throw new IllegalStateException("all reads should be performed by ProcessHandler");
    }

    public void write(byte[] bytes) throws IOException {
        this.writeBytes(bytes);
    }

    public boolean isConnected() {
        return false;
    }

    public void write(String string) throws IOException {
        this.writeBytes(string.getBytes(this.myCharset));
    }

    public int waitFor() throws InterruptedException {
        return this.myPtyProcess.waitFor();
    }

    public boolean ready() throws IOException {
        return false;
    }

    private void writeBytes(byte[] bytes) throws IOException {
        OutputStream input = this.myProcessHandler.getProcessInput();
        if (input != null) {
            input.write(bytes);
            input.flush();
        }
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(6);
        }
        return processHandler;
    }

    @Nullable
    public PtyProcess getPtyProcess() {
        return (PtyProcess)ObjectUtils.tryCast((Object)this.myPtyProcess, PtyProcess.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termSize";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setWindowSizeCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/ProcessHandlerTtyConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/ProcessHandlerTtyConnector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPtyProcess";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setWindowSizeSafely";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

