/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalTitleListener;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\rJ\u0016\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0006H\u0002J\u000b\u0010#\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010J\u000b\u0010$\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010J\n\u0010%\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0018\u0010\u001b\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/intellij/terminal/TerminalTitle;", "", "<init>", "()V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/terminal/TerminalTitleListener;", "state", "Lcom/intellij/terminal/TerminalTitle$State;", "change", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "userDefinedTitle", "", "Lorg/jetbrains/annotations/Nls;", "getUserDefinedTitle", "()Ljava/lang/String;", "applicationTitle", "getApplicationTitle", "trackTerminalApplicationTitleChanges", "", "getTrackTerminalApplicationTitleChanges$intellij_platform_execution_impl", "()Ljava/lang/Boolean;", "tag", "getTag", "defaultTitle", "getDefaultTitle", "addTitleListener", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "terminalTitleListener", "removeTitleListener", "buildTitle", "buildFullTitle", "shortenApplicationTitle", "fireTitleChanged", "toString", "State", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nTerminalTitle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTitle.kt\ncom/intellij/terminal/TerminalTitle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1869#2,2:112\n*S KotlinDebug\n*F\n+ 1 TerminalTitle.kt\ncom/intellij/terminal/TerminalTitle\n*L\n79#1:112,2\n*E\n"})
public final class TerminalTitle {
    @NotNull
    private final CopyOnWriteArrayList<TerminalTitleListener> listeners = new CopyOnWriteArrayList();
    @NotNull
    private volatile State state = new State(null, null, null, null, null, 31, null);

    public final void change(@NotNull Function1<? super State, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        State newState = State.copy$default(this.state, null, null, null, null, null, 31, null);
        block.invoke((Object)newState);
        if (!Intrinsics.areEqual((Object)newState, (Object)this.state)) {
            this.state = newState;
            this.fireTitleChanged();
        }
    }

    @Nullable
    public final String getUserDefinedTitle() {
        return this.state.getUserDefinedTitle();
    }

    @Nullable
    public final String getApplicationTitle() {
        return this.state.getApplicationTitle();
    }

    @Nullable
    public final Boolean getTrackTerminalApplicationTitleChanges$intellij_platform_execution_impl() {
        return this.state.getTrackTerminalApplicationTitleChanges();
    }

    @Nullable
    public final String getTag() {
        return this.state.getTag();
    }

    @Nullable
    public final String getDefaultTitle() {
        return this.state.getDefaultTitle();
    }

    public final void addTitleListener(@NotNull TerminalTitleListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.addTitleListener(listener2);
        if (!Disposer.tryRegister((Disposable)parentDisposable, () -> TerminalTitle.addTitleListener$lambda$0(this, listener2))) {
            this.removeTitleListener(listener2);
        }
    }

    private final void addTitleListener(TerminalTitleListener terminalTitleListener) {
        this.listeners.add(terminalTitleListener);
    }

    private final void removeTitleListener(TerminalTitleListener terminalTitleListener) {
        this.listeners.remove(terminalTitleListener);
    }

    @NotNull
    public final String buildTitle() {
        String string = this.getUserDefinedTitle();
        if (string == null && (string = this.shortenApplicationTitle()) == null && (string = this.getDefaultTitle()) == null) {
            String string2 = ExecutionBundle.message((String)"terminal.default.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String title = string;
        return this.getTag() != null ? title + " (" + this.getTag() + ")" : title;
    }

    @NotNull
    public final String buildFullTitle() {
        String string = this.getUserDefinedTitle();
        if (string == null && (string = this.getApplicationTitle()) == null && (string = this.getDefaultTitle()) == null) {
            String string2 = ExecutionBundle.message((String)"terminal.default.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    private final String shortenApplicationTitle() {
        String string = this.getApplicationTitle();
        if (string == null) {
            return null;
        }
        return StringUtil.trimMiddle((String)string, (int)30);
    }

    private final void fireTitleChanged() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalTitleListener it = (TerminalTitleListener)element$iv;
            boolean bl = false;
            it.onTitleChanged(this);
        }
    }

    @NotNull
    public String toString() {
        return this.state.toString();
    }

    private static final void addTitleListener$lambda$0(TerminalTitle this$0, TerminalTitleListener $listener) {
        this$0.removeTitleListener($listener);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\u000f\b\u0002\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000f\b\u0002\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010\u001d\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010\u001e\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010\u001f\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J^\u0010!\u001a\u00020\u00002\u000f\b\u0002\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001R!\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR!\u0010\u0005\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR!\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR!\u0010\u0007\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/terminal/TerminalTitle$State;", "", "userDefinedTitle", "", "Lorg/jetbrains/annotations/Nls;", "applicationTitle", "tag", "defaultTitle", "trackTerminalApplicationTitleChanges", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)V", "getUserDefinedTitle", "()Ljava/lang/String;", "setUserDefinedTitle", "(Ljava/lang/String;)V", "getApplicationTitle", "setApplicationTitle", "getTag", "setTag", "getDefaultTitle", "setDefaultTitle", "getTrackTerminalApplicationTitleChanges", "()Ljava/lang/Boolean;", "setTrackTerminalApplicationTitleChanges", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Lcom/intellij/terminal/TerminalTitle$State;", "equals", "other", "hashCode", "", "intellij.platform.execution.impl"})
    public static final class State {
        @Nullable
        private String userDefinedTitle;
        @Nullable
        private String applicationTitle;
        @Nullable
        private String tag;
        @Nullable
        private String defaultTitle;
        @Nullable
        private Boolean trackTerminalApplicationTitleChanges;

        public State(@Nullable String userDefinedTitle, @Nullable String applicationTitle, @Nullable String tag, @Nullable String defaultTitle, @Nullable Boolean trackTerminalApplicationTitleChanges) {
            this.userDefinedTitle = userDefinedTitle;
            this.applicationTitle = applicationTitle;
            this.tag = tag;
            this.defaultTitle = defaultTitle;
            this.trackTerminalApplicationTitleChanges = trackTerminalApplicationTitleChanges;
        }

        public /* synthetic */ State(String string, String string2, String string3, String string4, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            this(string, string2, string3, string4, bl);
        }

        @Nullable
        public final String getUserDefinedTitle() {
            return this.userDefinedTitle;
        }

        public final void setUserDefinedTitle(@Nullable String string) {
            this.userDefinedTitle = string;
        }

        @Nullable
        public final String getApplicationTitle() {
            return this.applicationTitle;
        }

        public final void setApplicationTitle(@Nullable String string) {
            this.applicationTitle = string;
        }

        @Nullable
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@Nullable String string) {
            this.tag = string;
        }

        @Nullable
        public final String getDefaultTitle() {
            return this.defaultTitle;
        }

        public final void setDefaultTitle(@Nullable String string) {
            this.defaultTitle = string;
        }

        @Nullable
        public final Boolean getTrackTerminalApplicationTitleChanges() {
            return this.trackTerminalApplicationTitleChanges;
        }

        public final void setTrackTerminalApplicationTitleChanges(@Nullable Boolean bl) {
            this.trackTerminalApplicationTitleChanges = bl;
        }

        @NotNull
        public String toString() {
            return "userDefined=" + this.userDefinedTitle + ", application=" + this.applicationTitle + ", tag=" + this.tag + ", default=" + this.defaultTitle + ", trackTerminalApplicationTitle=" + this.trackTerminalApplicationTitleChanges;
        }

        @Nullable
        public final String component1() {
            return this.userDefinedTitle;
        }

        @Nullable
        public final String component2() {
            return this.applicationTitle;
        }

        @Nullable
        public final String component3() {
            return this.tag;
        }

        @Nullable
        public final String component4() {
            return this.defaultTitle;
        }

        @Nullable
        public final Boolean component5() {
            return this.trackTerminalApplicationTitleChanges;
        }

        @NotNull
        public final State copy(@Nullable String userDefinedTitle, @Nullable String applicationTitle, @Nullable String tag, @Nullable String defaultTitle, @Nullable Boolean trackTerminalApplicationTitleChanges) {
            return new State(userDefinedTitle, applicationTitle, tag, defaultTitle, trackTerminalApplicationTitleChanges);
        }

        public static /* synthetic */ State copy$default(State state, String string, String string2, String string3, String string4, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = state.userDefinedTitle;
            }
            if ((n & 2) != 0) {
                string2 = state.applicationTitle;
            }
            if ((n & 4) != 0) {
                string3 = state.tag;
            }
            if ((n & 8) != 0) {
                string4 = state.defaultTitle;
            }
            if ((n & 0x10) != 0) {
                bl = state.trackTerminalApplicationTitleChanges;
            }
            return state.copy(string, string2, string3, string4, bl);
        }

        public int hashCode() {
            int result2 = this.userDefinedTitle == null ? 0 : this.userDefinedTitle.hashCode();
            result2 = result2 * 31 + (this.applicationTitle == null ? 0 : this.applicationTitle.hashCode());
            result2 = result2 * 31 + (this.tag == null ? 0 : this.tag.hashCode());
            result2 = result2 * 31 + (this.defaultTitle == null ? 0 : this.defaultTitle.hashCode());
            result2 = result2 * 31 + (this.trackTerminalApplicationTitleChanges == null ? 0 : ((Object)this.trackTerminalApplicationTitleChanges).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.userDefinedTitle, (Object)state.userDefinedTitle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.applicationTitle, (Object)state.applicationTitle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tag, (Object)state.tag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultTitle, (Object)state.defaultTitle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trackTerminalApplicationTitleChanges, (Object)state.trackTerminalApplicationTitleChanges);
        }

        public State() {
            this(null, null, null, null, null, 31, null);
        }
    }
}

