/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TerminalActionUtil {
    @ApiStatus.Internal
    public static final DataKey<Editor> EDITOR_KEY = DataKey.create((String)"TERMINAL_EDITOR");

    private TerminalActionUtil() {
    }

    @Nullable
    public static TerminalAction createTerminalAction(@NotNull JBTerminalWidget widget, @NonNls @NotNull String actionId, boolean hiddenAction) {
        List<KeyStroke> keyStrokes;
        if (widget == null) {
            TerminalActionUtil.$$$reportNull$$$0(0);
        }
        if (actionId == null) {
            TerminalActionUtil.$$$reportNull$$$0(1);
        }
        if ((keyStrokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)).isEmpty() && hiddenAction) {
            return null;
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            throw new AssertionError((Object)("Cannot find action " + actionId));
        }
        String name = action.getTemplateText();
        if (name != null && !hiddenAction) {
            throw new AssertionError((Object)("Action has unknown name: " + actionId));
        }
        TerminalActionPresentation presentation = new TerminalActionPresentation(StringUtil.notNullize((String)name, (String)"unknown"), keyStrokes);
        return new TerminalAction(presentation, keyEvent -> {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)widget.getTerminalPanel()));
            ActionUtil.performAction((AnAction)action, (AnActionEvent)AnActionEvent.createFromInputEvent((InputEvent)keyEvent, (String)"Terminal", null, (DataContext)dataContext));
            return true;
        }).withHidden(hiddenAction);
    }

    @NotNull
    public static TerminalAction createTerminalAction(@NotNull JBTerminalWidget widget, @NonNls @NotNull AnAction action) {
        if (widget == null) {
            TerminalActionUtil.$$$reportNull$$$0(2);
        }
        if (action == null) {
            TerminalActionUtil.$$$reportNull$$$0(3);
        }
        Collection strokes = KeymapUtil.getKeyStrokes((ShortcutSet)action.getShortcutSet());
        String name = StringUtil.notNullize((String)action.getTemplateText(), (String)"unknown");
        return new TerminalAction(new TerminalActionPresentation(name, List.copyOf(strokes)), keyEvent -> {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)widget.getTerminalPanel()));
            ActionUtil.performAction((AnAction)action, (AnActionEvent)AnActionEvent.createFromInputEvent((InputEvent)keyEvent, (String)"Terminal", null, (DataContext)dataContext));
            return true;
        });
    }

    public static TerminalAction createTerminalAction(@NotNull JBTerminalWidget widget, @NotNull TerminalActionPresentation actionPresentation, @NotNull Predicate<? super JBTerminalWidgetListener> action) {
        if (widget == null) {
            TerminalActionUtil.$$$reportNull$$$0(4);
        }
        if (actionPresentation == null) {
            TerminalActionUtil.$$$reportNull$$$0(5);
        }
        if (action == null) {
            TerminalActionUtil.$$$reportNull$$$0(6);
        }
        return new TerminalAction(actionPresentation, input -> {
            JBTerminalWidgetListener listener2 = widget.getListener();
            if (listener2 != null) {
                return action.test(listener2);
            }
            return false;
        }).withEnabledSupplier(() -> widget.getListener() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "widget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "actionId";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "actionPresentation";
                break;
            }
        }
        objectArray[1] = "com/intellij/terminal/actions/TerminalActionUtil";
        objectArray[2] = "createTerminalAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

