/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Executor {
    public static final ExtensionPointName<Executor> EXECUTOR_EXTENSION_NAME = new ExtensionPointName("com.intellij.executor");

    @NotNull
    public abstract String getToolWindowId();

    @NotNull
    public abstract Icon getToolWindowIcon();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public Icon getRerunIcon() {
        Icon icon = this.getIcon();
        if (icon == null) {
            Executor.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public abstract Icon getDisabledIcon();

    @NlsActions.ActionDescription
    public abstract String getDescription();

    @NotNull
    @NlsActions.ActionText
    public abstract String getActionName();

    @NlsContexts.TabTitle
    @NotNull
    public String getToolWindowTitle() {
        String string = this.getActionName();
        if (string == null) {
            Executor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public abstract String getId();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getStartActionText();

    @NonNls
    public abstract String getContextActionId();

    @NonNls
    public abstract String getHelpId();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getStartActionText(@NlsSafe @NotNull String configurationName) {
        if (configurationName == null) {
            Executor.$$$reportNull$$$0(2);
        }
        String configName = StringUtil.isEmpty((String)configurationName) ? "" : " '" + Executor.shortenNameIfNeeded(configurationName) + "'";
        String string = TextWithMnemonic.parse((String)this.getStartActionText()).append(configName).toString();
        if (string == null) {
            Executor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            Executor.$$$reportNull$$$0(4);
        }
        return true;
    }

    @ApiStatus.Experimental
    public boolean isSupportedOnTarget() {
        return false;
    }

    @Contract(pure=true)
    public static String shortenNameIfNeeded(@NotNull String name) {
        if (name == null) {
            Executor.$$$reportNull$$$0(5);
        }
        return StringUtil.trimMiddle((String)name, (int)Registry.intValue((String)"run.configuration.max.name.length", (int)80));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/Executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRerunIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowTitle";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/Executor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartActionText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStartActionText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shortenNameIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

