/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.TextWithMnemonic;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultRunExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = "Run";

    @Override
    @NotNull
    public String getStartActionText() {
        String string = ExecutionBundle.message("default.runner.start.action.text", new Object[0]);
        if (string == null) {
            DefaultRunExecutor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getStartActionText(@NotNull String configurationName) {
        if (configurationName == null) {
            DefaultRunExecutor.$$$reportNull$$$0(1);
        }
        if (configurationName.isEmpty()) {
            String string = this.getStartActionText();
            if (string == null) {
                DefaultRunExecutor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = TextWithMnemonic.parse((String)ExecutionBundle.message("default.runner.start.action.text.2", new Object[0])).replaceFirst("%s", DefaultRunExecutor.shortenNameIfNeeded(configurationName)).toString();
        if (string == null) {
            DefaultRunExecutor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getToolWindowId() {
        return EXECUTOR_ID;
    }

    @Override
    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowRun;
        if (icon == null) {
            DefaultRunExecutor.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Execute;
        if (icon == null) {
            DefaultRunExecutor.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Override
    @NotNull
    public Icon getRerunIcon() {
        Icon icon = AllIcons.Actions.Rerun;
        if (icon == null) {
            DefaultRunExecutor.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return IconLoader.getDisabledIcon((Icon)this.getIcon());
    }

    @Override
    public String getDescription() {
        return ExecutionBundle.message("standard.runner.description", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = ExecutionBundle.message("tool.window.name.run", new Object[0]);
        if (string == null) {
            DefaultRunExecutor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @Override
    public String getContextActionId() {
        return "RunClass";
    }

    @Override
    public String getHelpId() {
        return "ideaInterface.run";
    }

    @Override
    public boolean isSupportedOnTarget() {
        return EXECUTOR_ID.equalsIgnoreCase(this.getId());
    }

    public static Executor getRunExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/executors/DefaultRunExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartActionText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/executors/DefaultRunExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRerunIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStartActionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

