/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.BaseTargetEnvironmentRequest;
import com.intellij.execution.target.EelTargetEnvironment;
import com.intellij.execution.target.EelTargetEnvironmentRequestKt;
import com.intellij.execution.target.TargetConfigurationWithLocalFsAccess;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.VolumeCopyingRequest;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/target/EelTargetEnvironmentRequest;", "Lcom/intellij/execution/target/BaseTargetEnvironmentRequest;", "Lcom/intellij/execution/target/VolumeCopyingRequest;", "configuration", "Lcom/intellij/execution/target/EelTargetEnvironmentRequest$Configuration;", "<init>", "(Lcom/intellij/execution/target/EelTargetEnvironmentRequest$Configuration;)V", "getConfiguration", "()Lcom/intellij/execution/target/EelTargetEnvironmentRequest$Configuration;", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "prepareEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "progressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "shouldCopyVolumes", "", "getShouldCopyVolumes", "()Z", "setShouldCopyVolumes", "(Z)V", "Configuration", "intellij.platform.execution"})
@ApiStatus.Internal
public final class EelTargetEnvironmentRequest
extends BaseTargetEnvironmentRequest
implements VolumeCopyingRequest {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final TargetPlatform targetPlatform;
    private boolean shouldCopyVolumes;

    public EelTargetEnvironmentRequest(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(null, null, null, null, null, 31, null);
        this.configuration = configuration;
        this.targetPlatform = EelTargetEnvironmentRequestKt.access$toTargetPlatform(this.getConfiguration().getEel().getPlatform());
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    @NotNull
    public TargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        EelTargetEnvironment env = new EelTargetEnvironment(this);
        this.environmentPrepared(env, progressIndicator);
        return env;
    }

    @Override
    public boolean getShouldCopyVolumes() {
        return this.shouldCopyVolumes;
    }

    @Override
    public void setShouldCopyVolumes(boolean bl) {
        this.shouldCopyVolumes = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u0012\u001a\u000f\u0018\u00010\nj\u0004\u0018\u0001`\u0014\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/target/EelTargetEnvironmentRequest$Configuration;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lcom/intellij/execution/target/TargetConfigurationWithLocalFsAccess;", "eel", "Lcom/intellij/platform/eel/EelApi;", "<init>", "(Lcom/intellij/platform/eel/EelApi;)V", "getEel", "()Lcom/intellij/platform/eel/EelApi;", "projectRootOnTarget", "", "getProjectRootOnTarget", "()Ljava/lang/String;", "setProjectRootOnTarget", "(Ljava/lang/String;)V", "asTargetConfig", "getAsTargetConfig", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getTargetPathIfLocalPathIsOnTarget", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/execution/target/FullPathOnTarget;", "probablyPathOnTarget", "Ljava/nio/file/Path;", "intellij.platform.execution"})
    @SourceDebugExtension(value={"SMAP\nEelTargetEnvironmentRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelTargetEnvironmentRequest.kt\ncom/intellij/execution/target/EelTargetEnvironmentRequest$Configuration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1#2:290\n*E\n"})
    public static final class Configuration
    extends TargetEnvironmentConfiguration
    implements TargetConfigurationWithLocalFsAccess {
        @NotNull
        private final EelApi eel;
        @NotNull
        private String projectRootOnTarget;
        @NotNull
        private final TargetEnvironmentConfiguration asTargetConfig;

        public Configuration(@NotNull EelApi eel) {
            Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
            super("eel");
            this.eel = eel;
            this.projectRootOnTarget = "";
            this.asTargetConfig = this;
        }

        @NotNull
        public final EelApi getEel() {
            return this.eel;
        }

        @Override
        @NotNull
        public String getProjectRootOnTarget() {
            return this.projectRootOnTarget;
        }

        @Override
        public void setProjectRootOnTarget(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.projectRootOnTarget = string;
        }

        @Override
        @NotNull
        public TargetEnvironmentConfiguration getAsTargetConfig() {
            return this.asTargetConfig;
        }

        @Override
        @Nullable
        public String getTargetPathIfLocalPathIsOnTarget(@NotNull Path probablyPathOnTarget) {
            EelPath eelPath;
            Intrinsics.checkNotNullParameter((Object)probablyPathOnTarget, (String)"probablyPathOnTarget");
            EelPath it = eelPath = EelNioBridgeServiceKt.asEelPath((Path)probablyPathOnTarget);
            boolean bl = false;
            Object object = Intrinsics.areEqual((Object)it.getDescriptor(), (Object)this.eel.getDescriptor()) ? eelPath : null;
            return object != null ? object.toString() : null;
        }
    }
}

