/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.components.BaseState;
import com.intellij.util.text.StringKt;
import com.intellij.util.xmlb.annotations.Transient;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u000eJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000eJ\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001b\u001a\u00020\u0014H\u0016J&\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000e2\u0014\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u00140\u001eH\u0004J\u001a\u0010 \u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u001fH\u0004R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "Lcom/intellij/execution/target/ContributedConfigurationBase;", "typeId", "", "<init>", "(Ljava/lang/String;)V", "volumeTargetSpecificBits", "", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeType;", "Lcom/intellij/execution/target/TargetEnvironmentType$TargetSpecificVolumeData;", "volumePaths", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "descriptor", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "localRootPath", "Ljava/nio/file/Path;", "getTargetSpecificData", "volumeDescriptor", "setTargetSpecificData", "", "data", "getTargetPathValue", "getTargetPath", "Lcom/intellij/execution/target/TargetEnvironment$TargetPath;", "setTargetPath", "targetPath", "validateConfiguration", "saveInState", "doSave", "Lkotlin/Function1;", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration$VolumeState;", "loadVolumeState", "volumeState", "Companion", "VolumeState", "intellij.platform.execution"})
public abstract class LanguageRuntimeConfiguration
extends ContributedConfigurationBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<LanguageRuntimeType.VolumeType, TargetEnvironmentType.TargetSpecificVolumeData> volumeTargetSpecificBits;
    @NotNull
    private final Map<LanguageRuntimeType.VolumeType, String> volumePaths;

    public LanguageRuntimeConfiguration(@NotNull String typeId) {
        Intrinsics.checkNotNullParameter((Object)typeId, (String)"typeId");
        super(typeId, LanguageRuntimeType.EXTENSION_NAME);
        this.volumeTargetSpecificBits = new LinkedHashMap();
        this.volumePaths = new LinkedHashMap();
    }

    @NotNull
    public final TargetEnvironment.UploadRoot createUploadRoot(@NotNull LanguageRuntimeType.VolumeDescriptor descriptor, @NotNull Path localRootPath) {
        TargetEnvironment.UploadRoot uploadRoot;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)localRootPath, (String)"localRootPath");
        TargetEnvironment.UploadRoot it = uploadRoot = new TargetEnvironment.UploadRoot(localRootPath, this.getTargetPath(descriptor), false, 4, null);
        boolean bl = false;
        it.setVolumeData(this.getTargetSpecificData(descriptor));
        return uploadRoot;
    }

    @Nullable
    public final TargetEnvironmentType.TargetSpecificVolumeData getTargetSpecificData(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        return this.volumeTargetSpecificBits.get(volumeDescriptor.getType());
    }

    public final void setTargetSpecificData(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor, @Nullable TargetEnvironmentType.TargetSpecificVolumeData data) {
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        LanguageRuntimeConfiguration.Companion.putOrClear(this.volumeTargetSpecificBits, volumeDescriptor.getType(), data);
    }

    @Nullable
    public final String getTargetPathValue(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        return this.volumePaths.get(volumeDescriptor.getType());
    }

    @NotNull
    public final TargetEnvironment.TargetPath getTargetPath(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        String string = volumeDescriptor.getType().getId();
        String string2 = this.getTargetPathValue(volumeDescriptor);
        if (string2 == null || (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) == null) {
            string2 = StringKt.nullize$default((String)volumeDescriptor.getDefaultPath(), (boolean)false, (int)1, null);
        }
        String string3 = string2;
        String string4 = volumeDescriptor.getDirectoryPrefix();
        return new TargetEnvironment.TargetPath.Temporary(string, string4, string3);
    }

    public final void setTargetPath(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor, @Nullable String targetPath) {
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        LanguageRuntimeConfiguration.Companion.putOrClear(this.volumePaths, volumeDescriptor.getType(), targetPath);
    }

    public void validateConfiguration() throws RuntimeConfigurationException {
    }

    protected final void saveInState(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor, @NotNull Function1<? super VolumeState, Unit> doSave) {
        VolumeState volumeState;
        Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
        Intrinsics.checkNotNullParameter(doSave, (String)"doSave");
        VolumeState it = volumeState = new VolumeState();
        boolean bl = false;
        it.setRemotePath(this.getTargetPathValue(volumeDescriptor));
        it.setTargetSpecificData(this.getTargetSpecificData(volumeDescriptor));
        VolumeState volumeState2 = volumeState;
        doSave.invoke((Object)volumeState2);
    }

    protected final void loadVolumeState(@NotNull LanguageRuntimeType.VolumeDescriptor volumeDescriptor, @Nullable VolumeState volumeState) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)volumeDescriptor, (String)"volumeDescriptor");
            VolumeState volumeState2 = volumeState;
            if (volumeState2 == null) break block0;
            VolumeState it = volumeState2;
            boolean bl = false;
            this.setTargetPath(volumeDescriptor, it.getRemotePath());
            this.setTargetSpecificData(volumeDescriptor, it.getTargetSpecificData());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\t\u001a\u0002H\u00062\b\u0010\n\u001a\u0004\u0018\u0001H\u0007H\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/target/LanguageRuntimeConfiguration$Companion;", "", "<init>", "()V", "putOrClear", "", "K", "V", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "intellij.platform.execution"})
    public static final class Companion {
        private Companion() {
        }

        private final <K, V> void putOrClear(Map<K, V> $this$putOrClear, K key, V value) {
            if (value == null) {
                $this$putOrClear.remove(key);
            } else {
                $this$putOrClear.put(key, value);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R/\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nRC\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00158G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/target/LanguageRuntimeConfiguration$VolumeState;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "remotePath", "getRemotePath", "()Ljava/lang/String;", "setRemotePath", "(Ljava/lang/String;)V", "remotePath$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "targetSpecificBits", "getTargetSpecificBits", "()Ljava/util/Map;", "setTargetSpecificBits", "(Ljava/util/Map;)V", "targetSpecificBits$delegate", "data", "Lcom/intellij/execution/target/TargetEnvironmentType$TargetSpecificVolumeData;", "targetSpecificData", "getTargetSpecificData", "()Lcom/intellij/execution/target/TargetEnvironmentType$TargetSpecificVolumeData;", "setTargetSpecificData", "(Lcom/intellij/execution/target/TargetEnvironmentType$TargetSpecificVolumeData;)V", "intellij.platform.execution"})
    public static final class VolumeState
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty remotePath$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty targetSpecificBits$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[1]);

        @Nullable
        public final String getRemotePath() {
            return (String)this.remotePath$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setRemotePath(@Nullable String string) {
            this.remotePath$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @NotNull
        public final Map<String, String> getTargetSpecificBits() {
            return (Map)this.targetSpecificBits$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setTargetSpecificBits(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.targetSpecificBits$delegate.setValue((Object)this, $$delegatedProperties[1], map);
        }

        @Transient
        @Nullable
        public final TargetEnvironmentType.TargetSpecificVolumeData getTargetSpecificData() {
            return new TargetEnvironmentType.TargetSpecificVolumeData(this){
                final /* synthetic */ VolumeState this$0;
                {
                    this.this$0 = $receiver;
                }

                public Map<String, String> toStorableMap() {
                    return MapsKt.toMap(this.this$0.getTargetSpecificBits());
                }
            };
        }

        public final void setTargetSpecificData(@Nullable TargetEnvironmentType.TargetSpecificVolumeData data) {
            Object object = data;
            if (object == null || (object = object.toStorableMap()) == null) {
                object = MapsKt.emptyMap();
            }
            Object dataAsMap = object;
            this.setTargetSpecificBits(MapsKt.toMutableMap((Map)dataAsMap));
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(VolumeState.class, "remotePath", "getRemotePath()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(VolumeState.class, "targetSpecificBits", "getTargetSpecificBits()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

